/*
 * .../mach-ap4a2a/irq.c
 *
 * ALPHAPROJECT AP-SH4A-2A Support.
 *
 * Copyright (C) 2010 ALPHAPROJECT Co.,Ltd. 
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 */
#include <linux/platform_device.h>
#include <asm/sh_eth.h>
#include <mach/apsh4a2a.h>

/*
 * SH-Ether
 *
 * SH Ether of SH7763 has multi IRQ handling.
 * (57,58,59 -> 57)
 */
static struct resource sh_eth0_resources[] = {
	{
		.start  = 0xFEE00000, /* use eth0 */
		.end    = 0xFEE0077C - 1,
		.flags  = IORESOURCE_MEM,
	}, {
		.start  = 57,   /* irq number */
		.flags  = IORESOURCE_IRQ,
	},
};

static struct sh_eth_plat_data sh7763_eth0_pdata = {
	.phy = 1,
	.edmac_endian = EDMAC_LITTLE_ENDIAN,
};

static struct platform_device apsh4a2a_eth0_device = {
	.name       = "sh-eth",
	.id         = 0,	    
	.resource   = sh_eth0_resources,
	.num_resources  = ARRAY_SIZE(sh_eth0_resources),
	.dev        = {
		.platform_data = &sh7763_eth0_pdata,
	},
};

static struct resource sh_eth1_resources[] = {
	{
		.start  = 0xFEE00800, /* use eth1 */
		.end    = 0xFEE00F7C - 1,
		.flags  = IORESOURCE_MEM,
	}, {
		.start  = 58,	/* irq number */
		.flags  = IORESOURCE_IRQ,
	},
};

static struct sh_eth_plat_data sh7763_eth1_pdata = {
	.phy = 1,
	.edmac_endian = EDMAC_LITTLE_ENDIAN,
};

static struct platform_device apsh4a2a_eth1_device = {
	.name       = "sh-eth",
	.id         = 1,
	.resource   = sh_eth1_resources,
	.num_resources  = ARRAY_SIZE(sh_eth1_resources),
	.dev        = {
		.platform_data = &sh7763_eth1_pdata,
	},
};

static struct platform_device *apsh4a2a_devices[] __initdata = {
	&apsh4a2a_eth0_device,
	&apsh4a2a_eth1_device,
};

static int __init apsh4a2a_devices_setup(void)
{
	printk("%s:\n", __func__);

	return platform_add_devices(apsh4a2a_devices,
				    ARRAY_SIZE(apsh4a2a_devices));
}

device_initcall(apsh4a2a_devices_setup);

