/*
 * Copyright (C) 2009 ALPHAPROJECT Co.,Ltd. 
 * Copyright (C) 2008 Renesas Solutions Corp.
 * Copyright (C) 2008 Nobuhiro Iwamatsu <iwamatsu.nobuhiro@renesas.com>
 * Copyright (C) 2007 Kenati Technologies, Inc.
 *
 * board/sh7763rdp/lowlevel_init.S
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <config.h>
#include <version.h>

#include <asm/processor.h>
#include <asm/macro.h>

	.global	lowlevel_init

	.text
	.align	2

lowlevel_init:
	mov.l	MMSELR_A, r1
	mov.l	MMSELR_D, r0
	synco
	mov.l	r0, @r1

	mov.l	@r1, r2		/* execute two reads after setting MMSELR */
	mov.l	@r1, r2
	synco
	
	write32 MIM_H_A, MIM_H_D
	write32	MIM_L_A, MIM_L_D
	write32	SDR_H_A, D0
	write32	SDR_L_A, SDR_L_D
	write32	STR_H_A, D0
	write32	STR_L_A, STR_L_D
	write32	SCR_H_A, D0		/* DESELECT */
	write32	SCR_L_A, SCR_L_D1
	write32	EMRS, D0
	write32	MRS1, D0
	write32	SCR_H_A, D0		/* PREALL */
	write32	SCR_L_A, SCR_L_D2
	write32	SCR_H_A, D0		/* PREALL */
	write32	SCR_L_A, SCR_L_D3
	write32	SCR_H_A, D0		/* REFA1 */
	write32	SCR_L_A, SCR_L_D4
	write32	SCR_H_A, D0		/* REFA2 */
	write32	SCR_L_A, SCR_L_D5
	write32	SCR_H_A, D0		/* NORMAL */
	write32	SCR_L_A, D0
	write32	SCR_H_A, SCR_L_D6
	write32	MRS2, D0

	rts
	nop

	.align	2

EMRS:		.long	0xFE902000
MRS1:		.long	0xFE900B08
MRS2:		.long	0xFE900308
D0:		.long	0x00000000
	
/* LBSC */
MMSELR_A:	.long	0xFE600020

/* DDR I/F */
MIM_H_A:	.long	0xFE800008
MIM_L_A:	.long	0xFE80000C
SCR_H_A:	.long	0xFE800010
SCR_L_A:	.long	0xFE800014
STR_H_A:	.long	0xFE800018
STR_L_A:	.long	0xFE80001C
SDR_H_A:	.long	0xFE800030
SDR_L_A:	.long	0xFE800034
	
MMSELR_D:	.long	0xa5a50000
MIM_H_D:	.long	0x00004000
MIM_L_D:	.long	0x04110209
SDR_L_D:	.long	0x00000300
STR_L_D:	.long	0x00050040
SCR_L_D1:	.long	0x00000003
SCR_L_D2:	.long	0x00000002
SCR_L_D3:	.long	0x00000002
SCR_L_D4:	.long	0x00000004
SCR_L_D5:	.long	0x00000004
SCR_L_D6:	.long	0x00000000

SR_D:		.long	0x700000F0
