using System;
using System.Drawing;
using System.Drawing.Drawing2D;
using PdfSharp.Drawing;

namespace XDrawing.TestLab.Tester
{
  /// <summary>
  /// Demonstrates the use of XGraphics.DrawPath.
  /// </summary>
  public class PathGlyph : TesterBase
  {
    public override void RenderPage(XGraphics gfx)
    {
      base.RenderPage(gfx);

      XGraphicsPath path = new XGraphicsPath();
      // HACK: 
      //path.gdipPath.AddString("@", new FontFamily("Times"), 3, 150, new Point(90, 60), StringFormat.GenericTypographic);

      path.AddString("@", new XFontFamily("Times"), XFontStyle.BoldItalic, 500, new XPoint(90, 60), XStringFormat.Default);
      //path.gdipPath.Flatten(new Matrix(), 0.1f);
      gfx.DrawPath(properties.Pen2.Pen, properties.Brush2.Brush, path);
    }

    public override string Description
    {
      get {return "AddString & DrawPath";}
    }
  }
}
