using System;
using System.Drawing;
using System.Drawing.Drawing2D;
using PdfSharp.Drawing;

namespace XDrawing.TestLab.Tester
{
  /// <summary>
  /// Demonstrates the use of XGraphics.SetClip.
  /// </summary>
  public class PathClipGlyph : TesterBase
  {
    public override void RenderPage(XGraphics gfx)
    {
      base.RenderPage(gfx);

      // Create a new graphical path
      XGraphicsPath path = new XGraphicsPath();
      //path.gdipPath.AddString("Clip!", new FontFamily("Times"), 3, 250, new Point(30, 100), StringFormat.GenericTypographic);
      // Add the outline of the glyphs of the word 'Clip' to the path
      path.AddString("Clip!", new XFontFamily("Times"), XFontStyle.BoldItalic, 250, new XPoint(30, 100), XStringFormat.Default);
      //path.gdipPath.Flatten(new Matrix(), 0.1f);
      // Draw the path
      gfx.DrawPath(/*properties.Pen1.Pen,*/ properties.Brush2.Brush, path);

#if DEBUG
      gfx.WriteComment("SetClip");
#endif
      // Set the path a clip path
      gfx.SetClip(path);
#if DEBUG
      gfx.WriteComment("Random lines");
#endif
      // Draw some random lines to show that clipping happens.
      Random rnd = new Random(42);
      for (int idx = 0; idx < 300; idx++)
        gfx.DrawLine(properties.Pen2.Pen, rnd.Next(600), rnd.Next(500), rnd.Next(600), rnd.Next(500));
    }

    public override string Description
    {
      get {return "SetClip(path)";}
    }
  }
}
