using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using PdfSharp.Drawing;

namespace XDrawing.TestLab.FormPages
{
  /// <summary>
  /// Font properties.
  /// </summary>
  public class FontPage : System.Windows.Forms.UserControl
  {
    private XDrawing.TestLab.FormPages.ColorPage colorPage;
    private System.Windows.Forms.Label lblFamily;
    private System.Windows.Forms.CheckBox btnBold;
    private System.Windows.Forms.CheckBox btnItalic;
    private System.Windows.Forms.ComboBox cbxFamily;
    private System.Windows.Forms.NumericUpDown udSize;
    private System.Windows.Forms.Label lblSize;
    private System.Windows.Forms.TextBox tbxText;
    private System.Windows.Forms.Label lblSupportedStyles;
    private System.ComponentModel.Container components = null;

    public FontPage()
    {
      InitializeComponent();
      UITools.SetTabPageColor(this);
      this.colorPage.UpdateDrawing += new UpdateDrawing(OnUpdateDrawing);

      FontFamily[] family1 = FontFamily.Families;
      FontFamily[] family2 = FontFamily.GetFamilies(Graphics.FromHwnd(IntPtr.Zero));

      FontFamily[] families = FontFamily.Families;
      foreach (FontFamily family in families)
        this.cbxFamily.Items.Add(family.Name);
    }

    void ModelToView()
    {
      if (this.inModelToView || DesignMode)
        return;

      this.cbxFamily.SelectedItem = this.fontProperty.FamilyName;
      this.udSize.Value = (decimal)this.fontProperty.Size;
      this.btnBold.Checked = this.fontProperty.Bold;
      this.btnItalic.Checked = this.fontProperty.Italic;
      this.tbxText.Text = this.fontProperty.Text;

      this.inModelToView = false;
    }
    bool inModelToView;

    public event UpdateDrawing UpdateDrawing;

    void OnUpdateDrawing()
    {
      if (UpdateDrawing != null)
        UpdateDrawing();
    }

    public FontProperty FontProperty
    {
      get {return this.fontProperty;}
      set 
      {
        this.fontProperty = value;
        this.colorPage.ColorProperty = value.Color;
      }
    }
    FontProperty fontProperty;

    /// <summary> 
    /// Clean up any resources being used.
    /// </summary>
    protected override void Dispose(bool disposing)
    {
      if (disposing)
      {
        if (components != null)
          components.Dispose();
      }
      base.Dispose(disposing);
    }

    #region Component Designer generated code
    /// <summary> 
    /// Required method for Designer support - do not modify 
    /// the contents of this method with the code editor.
    /// </summary>
    private void InitializeComponent()
    {
      this.colorPage = new XDrawing.TestLab.FormPages.ColorPage();
      this.lblFamily = new System.Windows.Forms.Label();
      this.cbxFamily = new System.Windows.Forms.ComboBox();
      this.btnBold = new System.Windows.Forms.CheckBox();
      this.btnItalic = new System.Windows.Forms.CheckBox();
      this.udSize = new System.Windows.Forms.NumericUpDown();
      this.lblSize = new System.Windows.Forms.Label();
      this.tbxText = new System.Windows.Forms.TextBox();
      this.lblSupportedStyles = new System.Windows.Forms.Label();
      ((System.ComponentModel.ISupportInitialize)(this.udSize)).BeginInit();
      this.SuspendLayout();
      // 
      // colorPage
      // 
      this.colorPage.ColorProperty = null;
      this.colorPage.Location = new System.Drawing.Point(0, 0);
      this.colorPage.Name = "colorPage";
      this.colorPage.Size = new System.Drawing.Size(380, 150);
      this.colorPage.TabIndex = 4;
      // 
      // lblFamily
      // 
      this.lblFamily.Location = new System.Drawing.Point(8, 160);
      this.lblFamily.Name = "lblFamily";
      this.lblFamily.Size = new System.Drawing.Size(48, 16);
      this.lblFamily.TabIndex = 1;
      this.lblFamily.Text = "Family";
      // 
      // cbxFamily
      // 
      this.cbxFamily.Location = new System.Drawing.Point(60, 156);
      this.cbxFamily.Name = "cbxFamily";
      this.cbxFamily.Size = new System.Drawing.Size(192, 21);
      this.cbxFamily.TabIndex = 2;
      this.cbxFamily.SelectedIndexChanged += new System.EventHandler(this.cbxFamily_SelectedIndexChanged);
      // 
      // btnBold
      // 
      this.btnBold.FlatStyle = System.Windows.Forms.FlatStyle.System;
      this.btnBold.Location = new System.Drawing.Point(260, 156);
      this.btnBold.Name = "btnBold";
      this.btnBold.Size = new System.Drawing.Size(52, 20);
      this.btnBold.TabIndex = 3;
      this.btnBold.Text = "Bold";
      this.btnBold.CheckedChanged += new System.EventHandler(this.btnBold_CheckedChanged);
      // 
      // btnItalic
      // 
      this.btnItalic.FlatStyle = System.Windows.Forms.FlatStyle.System;
      this.btnItalic.Location = new System.Drawing.Point(320, 156);
      this.btnItalic.Name = "btnItalic";
      this.btnItalic.Size = new System.Drawing.Size(48, 20);
      this.btnItalic.TabIndex = 3;
      this.btnItalic.Text = "Italic";
      this.btnItalic.CheckedChanged += new System.EventHandler(this.btnItalic_CheckedChanged);
      // 
      // udSize
      // 
      this.udSize.DecimalPlaces = 1;
      this.udSize.Increment = new System.Decimal(new int[] {
                                                             1,
                                                             0,
                                                             0,
                                                             65536});
      this.udSize.Location = new System.Drawing.Point(68, 200);
      this.udSize.Name = "udSize";
      this.udSize.Size = new System.Drawing.Size(52, 20);
      this.udSize.TabIndex = 5;
      this.udSize.ValueChanged += new System.EventHandler(this.udSize_ValueChanged);
      // 
      // lblSize
      // 
      this.lblSize.Location = new System.Drawing.Point(8, 204);
      this.lblSize.Name = "lblSize";
      this.lblSize.Size = new System.Drawing.Size(40, 16);
      this.lblSize.TabIndex = 1;
      this.lblSize.Text = "Size";
      // 
      // tbxText
      // 
      this.tbxText.Location = new System.Drawing.Point(164, 216);
      this.tbxText.Name = "tbxText";
      this.tbxText.Size = new System.Drawing.Size(188, 20);
      this.tbxText.TabIndex = 6;
      this.tbxText.Text = "AaBbCcfg";
      this.tbxText.TextChanged += new System.EventHandler(this.tbxText_TextChanged);
      // 
      // lblSupportedStyles
      // 
      this.lblSupportedStyles.Location = new System.Drawing.Point(4, 184);
      this.lblSupportedStyles.Name = "lblSupportedStyles";
      this.lblSupportedStyles.Size = new System.Drawing.Size(364, 16);
      this.lblSupportedStyles.TabIndex = 7;
      this.lblSupportedStyles.Text = "<SupportedStyles>";
      // 
      // FontPage
      // 
      this.Controls.Add(this.lblSupportedStyles);
      this.Controls.Add(this.tbxText);
      this.Controls.Add(this.udSize);
      this.Controls.Add(this.colorPage);
      this.Controls.Add(this.btnBold);
      this.Controls.Add(this.cbxFamily);
      this.Controls.Add(this.lblFamily);
      this.Controls.Add(this.btnItalic);
      this.Controls.Add(this.lblSize);
      this.Name = "FontPage";
      this.Size = new System.Drawing.Size(380, 240);
      ((System.ComponentModel.ISupportInitialize)(this.udSize)).EndInit();
      this.ResumeLayout(false);

    }
    #endregion

    protected override void OnLoad(EventArgs e)
    {
      base.OnLoad (e);
      ModelToView();
    }

    private void cbxFamily_SelectedIndexChanged(object sender, System.EventArgs e)
    {
      if (this.inModelToView)
        return;
      int idx = this.cbxFamily.SelectedIndex;
      if (idx >= 0)
      {
        this.fontProperty.FamilyName = this.cbxFamily.SelectedItem.ToString();
        FontFamily family = new FontFamily(this.fontProperty.FamilyName);
        
        string supportedSyles = "";
        if (family.IsStyleAvailable(FontStyle.Regular))
          supportedSyles += "Regualr, ";
        if (family.IsStyleAvailable(FontStyle.Bold))
          supportedSyles += "Bold, ";
        if (family.IsStyleAvailable(FontStyle.Italic))
          supportedSyles += "Italic, ";
        if (family.IsStyleAvailable(FontStyle.Bold | FontStyle.Italic))
          supportedSyles += "BoldItalic, ";
        if (family.IsStyleAvailable(FontStyle.Strikeout))
          supportedSyles += "Strikeout, ";
        if (family.IsStyleAvailable(FontStyle.Underline))
          supportedSyles += "Underline, ";
        this.lblSupportedStyles.Text = supportedSyles;

        OnUpdateDrawing();
      }
    }

    private void udSize_ValueChanged(object sender, System.EventArgs e)
    {
      if (this.inModelToView)
        return;
      this.fontProperty.Size = Convert.ToSingle(this.udSize.Value);
      OnUpdateDrawing();
    }

    private void btnBold_CheckedChanged(object sender, System.EventArgs e)
    {
      if (this.inModelToView)
        return;
      this.fontProperty.Bold = this.btnBold.Checked;
      OnUpdateDrawing();
    }

    private void btnItalic_CheckedChanged(object sender, System.EventArgs e)
    {
      if (this.inModelToView)
        return;
      this.fontProperty.Italic = this.btnItalic.Checked;
      OnUpdateDrawing();
    }

    private void tbxText_TextChanged(object sender, System.EventArgs e)
    {
      if (this.inModelToView)
        return;
      this.fontProperty.Text = this.tbxText.Text;
      OnUpdateDrawing();
    }

  }
}
