using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using PdfSharp.Pdf;
using PdfSharp.Pdf.IO;

namespace PdfSharp.Explorer
{
  /// <summary>
  /// Entry class of PDFshpar Explorer.
  /// </summary>
  public class Program
  {
    /// <summary>
    /// The main entry point for the application.
    /// </summary>
    [STAThread]
    static void Main(string[] args) 
    {
      if (args.Length < 2)
      {
        ExplorerProcess process = new ExplorerProcess();
        if (args.Length == 1)
        {
          try
          {
            process.OpenDocument(args[0]);
          }
          catch (Exception ex)
          {
            MessageBox.Show(ex.Message, VersionInfo.Title);
            return;
          }
        }
        Application.Run(new MainForm(process));
      }
      else
      {
        switch (args[1])
        {
          case "/format":
            FormatDocument(args[0]);
            break;

          default:
            MessageBox.Show("Invalid command: '" + args[0] + "'.", VersionInfo.Title);
            break;
        }
      }
    }

    static void FormatDocument(string path)
    {
      try
      {
        PdfDocument document = PdfReader.Open(path); 
        PdfPages pages = document.Pages;
        int count = pages.Count;
        for (int idx = 0; idx < count; idx++)
          pages[0].Content.Deflate();
      
        string name = Path.GetFileName(path);
        path = Path.GetDirectoryName(path);
        name = Path.GetFileNameWithoutExtension(name) + "_" + ".pdf";
        path = Path.Combine(path, name);
        document.Save(path);
      }
      catch (Exception ex)
      {
        MessageBox.Show(ex.ToString(), VersionInfo.Title);
      }
    }
  }
}
