using System;
using System.Diagnostics;
using System.IO;
using PdfSharp.Drawing;
using PdfSharp.Pdf;
using PdfSharp.Pdf.IO;
using PdfSharp.Pdf.Advanced;
using PdfSharp.Pdf.Security;

namespace ProtectDocument
{
  /// <summary>
  /// This sample shows how to protect a document with a password.
  /// </summary>
  class Program
  {
    [STAThread]
    static void Main(string[] args)
    {
      // Get a fresh copy of the sample PDF file
      string filename = "HelloWorld.pdf";
      File.Copy(Path.Combine("../../../../PDFs/", filename), 
        Path.Combine(Directory.GetCurrentDirectory(), filename), true);

      // Open an existing document. Providing an unrequired password is ignored.
      PdfDocument document = PdfReader.Open(filename, "some text");

      PdfSecuritySettings securitySettings = document.SecuritySettings;

      // Setting one of the passwords automatically sets the security level to 
      // PdfDocumentSecurityLevel.Encrypted128Bit.
      securitySettings.UserPassword  = "user";
      securitySettings.OwnerPassword = "owner";

      // Dont use 40 bit encryption unless needed for compatibility reasons
      //securitySettings.DocumentSecurityLevel = PdfDocumentSecurityLevel.Encrypted40Bit;

      // Restrict some rights.
      securitySettings.PermitAccessibilityExtractContent = false;
      securitySettings.PermitAnnotations = false;
      securitySettings.PermitAssembleDocument = false;
      securitySettings.PermitExtractContent = false;
      securitySettings.PermitFormsFill = true;
      securitySettings.PermitFullQualityPrint = false;
      securitySettings.PermitModifyDocument = true;
      securitySettings.PermitPrint = false;

      // Save the document...
      document.Save(filename);
      // ...and start a viewer.
      Process.Start(filename);
    }
  }
}