using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using PdfSharp.Drawing;
using PdfSharp.Forms;

namespace Preview
{
  /// <summary>
  /// This sample shows to render graphic in a preview and in a PDF document.
  /// </summary>
  class Program
  {
    [STAThread]
    static void Main() 
    {
      Renderer renderer = new Renderer();
      PreviewForm form = new PreviewForm();
      form.RenderEvent = new PagePreview.RenderEvent(renderer.Render);
      Application.Run(form);
    }
  }

  class Renderer
  {
    /// <summary>
    /// Renders the content of the page.
    /// </summary>
    public void Render(XGraphics gfx)
    {
      XPen pen;
      double x = 50, y = 100;
      XFont fontH1 = new XFont("Times", 18, XFontStyle.Bold);
      XFont font = new XFont("Times", 12);
      double ls = font.GetHeight(gfx);

      // Draw some text
      gfx.DrawString("Create PDF on the fly with PDFsharp",
          fontH1, XBrushes.Black, x, x);
      gfx.DrawString("With PDFsharp you can use the same code to draw graphic, " +
          "text and images on different targets.", font, XBrushes.Black, x, y);
      y += ls;
      gfx.DrawString("The object used for drawing is the XGraphics object.", 
          font, XBrushes.Black, x, y);
      y += ls;

      // Draw an arc
      pen = new XPen(XColors.Red, 4);
      pen.DashStyle = XDashStyle.Dash;
      gfx.DrawArc(pen, x + 20, y, 100, 60, 150, 120);

      // Draw a star
      XGraphicsState gs = gfx.Save();
      gfx.TranslateTransform(x + 140, y + 30);
      for (int idx = 0; idx < 360; idx += 10)
      {
        gfx.RotateTransform(10);
        gfx.DrawLine(XPens.DarkGreen, 0, 0, 30, 0);
      }
      gfx.Restore(gs);

      // Draw a rounded rectangle
      pen = new XPen(XColors.DarkBlue, 2.5);
      gfx.DrawRoundedRectangle(pen, XBrushes.Firebrick, x + 230, y, 100, 60, 10, 10);
      
      // Draw a pie
      pen = new XPen(XColors.DarkOrange, 1.5);
      pen.DashStyle = XDashStyle.Dot;
      gfx.DrawPie(pen, XBrushes.Blue, x + 360, y, 100, 60, -130, 135);
      
      // Draw some more text
      y += 60 + ls;
      gfx.DrawString("With XGraphics you can draw on a PDF page as well as on any " +
          "System.Drawing.Graphics object.", font, XBrushes.Black, x, y);
      y += ls * 1.1;
      gfx.DrawString("Use the same code to", font, XBrushes.Black, x, y);
      x += 10;
      y += ls * 1.1;
      gfx.DrawString(" draw on a new created PDF page", font, XBrushes.Black, x, y);
      y += ls;
      gfx.DrawString(" draw above or beneath an existing PDF page", 
          font, XBrushes.Black, x, y);
      y += ls;
      gfx.DrawString(" draw in a window", font, XBrushes.Black, x, y);
      y += ls;
      gfx.DrawString(" draw on a printer", font, XBrushes.Black, x, y);
      y += ls;
      gfx.DrawString(" draw in a bitmap image", font, XBrushes.Black, x, y);
      x -= 10;
      y += ls * 1.1;
      gfx.DrawString("You can also open an existing PDF page like an image and " +
          "draw it on another PDF page.", font, XBrushes.Black, x, y);
    }
  }
}
