using System;
using System.Diagnostics;
using System.IO;
using PdfSharp;
using PdfSharp.Drawing;
using PdfSharp.Pdf;
using PdfSharp.Pdf.IO;

namespace HelloWorld
{
  /// <summary>
  /// This sample shows a document with different page sizes.
  /// Note: You can set the size of a page to any size using the Width and
  /// Height properties. This samples shows only the predefined sizes.
  /// </summary>
  class Program
  {
    [STAThread]
    static void Main(string[] args)
    {
      // Create a new PDF document
      PdfDocument document = new PdfDocument();

      // Create a font
      XFont font = new XFont("Times", 25, XFontStyle.Bold);

      PageSize[] pageSizes = (PageSize[])Enum.GetValues(typeof(PageSize));
      foreach (PageSize pageSize in pageSizes)
      {
        if (pageSize == PageSize.Undefined)
          continue;

        // One page in Portrait...
        PdfPage page = document.AddPage();
        page.Size = pageSize;
        XGraphics gfx = XGraphics.FromPdfPage(page);
        gfx.DrawString(pageSize.ToString(), font, XBrushes.DarkRed,
          new XRect(0, 0, page.Width, page.Height),
          XStringFormat.Center);

        // ... and one in Landscape orientation.
        page = document.AddPage();
        page.Size = pageSize;
        page.Orientation = PageOrientation.Landscape;
        gfx = XGraphics.FromPdfPage(page);
        gfx.DrawString(pageSize.ToString() + " (landscape)", font,
          XBrushes.DarkRed, new XRect(0, 0, page.Width, page.Height),
          XStringFormat.Center);
      }

      // Save the document...
      string filename = "PageSizes.pdf";
      document.Save(filename);
      // ...and start a viewer.
      Process.Start(filename);
    }
  }
}