//
// PDFSharp - A library for processing PDF
//
// Authors:
//   Stefan Lange (mailto:Stefan.Lange@pdfsharp.com)
//
// Copyright (c) 2005 empira Software GmbH, Cologne (Germany)
//
// http://www.pdfsharp.com
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

using System;

namespace PdfSharp
{
  public enum PageSize
  {
    // TODO: add more ISO sizes
    // http://www.engineeringtoolbox.com/drawings-paper-sheets-sizes-25_349.html

    /// <summary>
    /// The width or height of the page are set manually and override the PageSize property.
    /// </summary>
    Undefined = 0,

    /// <summary>
    /// Identifies a pager sheet size of 841 mm times 1189 mm or 33.11 inch times 46.81 inch.
    /// </summary>
    A0        = 1,

    A1        = 2,
    A2        = 3,
    A3        = 4,
    A4        = 5,
    A5        = 6,
    B4        = 7,
    B5        = 8,
    Letter    = 9,
    Legal     = 10,
    Tabloid   = 11,
    Ledger    = 12,
    Statement = 13,
    Executive = 14,
    Folio     = 15,
    Quarto    = 16,
    Size10x14 = 17,
  }
}
