//
// PDFSharp - A library for processing PDF
//
// Authors:
//   Stefan Lange (mailto:Stefan.Lange@pdfsharp.com)
//
// Copyright (c) 2005 empira Software GmbH, Cologne (Germany)
//
// http://www.pdfsharp.com
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

namespace PdfSharp
{
  internal sealed class VersionInfo
  {
    VersionInfo() {}

#if MIGRADOC
    //TODO: Must be anything different for MigraDoc???
    public const string Title         = "PdfSharp";
    public const string Description   = "PDFsharp for MigraDoc";
#else
    public const string Title         = "PDFsharp";
    public const string Description   = "A PDF on the fly processor.";
#endif
    public const string Producer      = Title + " " + Version + " (" + Url +")";
    public const string Version       = "0.7.284";
    public const string Url           = "www.pdfsharp.com";
    public const string Configuration = "";
    public const string Company       = "empira Software GmbH, Cologne (Germany)";
    public const string Product       = "PDFsharp";
    public const string Copyright     = "Copyright  2005 empira GmbH. All rights reserved.";
    public const string Trademark     = "PDFsharp";
    public const string Culture       = "";
  }
}
