//
// PDFSharp - A library for processing PDF
//
// Authors:
//   Stefan Lange (mailto:Stefan.Lange@pdfsharp.com)
//
// Copyright (c) 2005 empira Software GmbH, Cologne (Germany)
//
// http://www.pdfsharp.com
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

using System;
using System.Drawing;

namespace PdfSharp
{
  /// <summary>
  /// 
  /// </summary>
  public sealed class PageSizeConverter
  {
    PageSizeConverter()
    {
    }

    /// <summary>
    /// Converts the specified page size enumeration to a pair of values in point.
    /// </summary>
    public static Size ToSize(PageSize value)
    {
      // The international definitions are:
      //   1 inch == 25.4 mm
      //   1 inch == 72 point
      switch (value)
      {
        case PageSize.A0:
          return new Size(2380, 3368);

        case PageSize.A1:
          return new Size(1684, 2380);

        case PageSize.A2:
          return new Size(1190, 1684);

        case PageSize.A3:
          return new Size(842, 1190);

        case PageSize.A4:
          return new Size(595, 842);

        case PageSize.A5:
          return new Size(420, 595);

        case PageSize.B4:
          return new Size(729, 1032);

        case PageSize.B5:
          return new Size(516, 729);

        // The strange sizes from overseas...

        case PageSize.Letter:           // 8.5 x 11 inch
          return new Size(612, 792);

        case PageSize.Legal:            // 8.5 x 14 inch
          return new Size(612, 1008);

        case PageSize.Tabloid:          // 11 x 17 inch
          return new Size(792, 1224);

        case PageSize.Ledger:           // 17 x 11 inch
          return new Size(1224, 792);

        case PageSize.Statement:        // 5.5 x 8.5 inch
          return new Size(396, 612);

        case PageSize.Executive:        // 7.5 x 10 inch
          return new Size(540, 720);

        case PageSize.Folio:
          return new Size(612, 936);    // 8.5 x 13 inch

        case PageSize.Quarto:
          return new Size(610, 780);

        case PageSize.Size10x14:
          return new Size(720, 1008);   // 10 x 14 inch
      }
      throw new ArgumentException("Invalid PageSize.", "value");
    }
  }
}
