//
// PDFSharp - A library for processing PDF
//
// Authors:
//   Stefan Lange (mailto:Stefan.Lange@pdfsharp.com)
//
// Copyright (c) 2005 empira Software GmbH, Cologne (Germany)
//
// http://www.pdfsharp.com
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

using System;
using System.Diagnostics;
using System.Collections;
using System.Text;
using System.IO;
using PdfSharp.Internal;

namespace PdfSharp.Pdf
{
  /// <summary>
  /// 
  /// </summary>
  public sealed class PdfDocumentOptions
  {
    internal PdfDocumentOptions(PdfDocument document)
    {
      //this.deflateContents = true;
      //this.writeProcedureSets = true;
    }

    public bool CompressContentStreams
    {
      get {return this.compressContentStreams;}
      set {this.compressContentStreams = value;}
    }
#if DEBUG
    bool compressContentStreams = false;
#else
    bool compressContentStreams = true;
#endif

    /// <summary>
    /// Gets or sets a value indication that all objects are not compressed.
    /// </summary>
    public bool NoCompression
    {
      get {return this.noCompression;}
      set {this.noCompression = value;}
    }
    bool noCompression;

    //public bool WriteProcedureSets
    //{
    //  get {return this.writeProcedureSets;}
    //  set {this.writeProcedureSets = value;}
    //}
    //bool writeProcedureSets;
  }
}
