//
// PDFSharp - A library for processing PDF
//
// Authors:
//   Stefan Lange (mailto:Stefan.Lange@pdfsharp.com)
//
// Copyright (c) 2005 empira Software GmbH, Cologne (Germany)
//
// http://www.pdfsharp.com
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

using System;
using System.Diagnostics;
using PdfSharp.Internal;
using PdfSharp.Pdf.Internal;

namespace PdfSharp.Pdf.Filters
{
  // TODO: required for post scipt processing
  /// <summary>
  /// Implements the ASCII85Decode filter.
  /// </summary>
  internal class ASCII85Decode : Filter
  {
    public override byte[] Encode(byte[] data)
    {
      throw new NotImplementedException("TODO: Implementation of ASCII85Decode.");
      //int count = data.Length;
      //byte[] bytes = new byte[2 * count];
      //for (int i = 0, j = 0; i < count; i++)
      //{
      //  byte b = data[i];
      //  bytes[j++] = (byte)((b >> 4) + ((b >> 4) < 10 ? (byte)'0' : (byte)('A' - 10)));
      //  bytes[j++] = (byte)((b & 0xF) + ((b & 0xF) < 10 ? (byte)'0' : (byte)('A' - 10)));
      //}
      //return bytes;
    }

    public override byte[] Decode(byte[] data, FilterParms parms)
    {
      throw new NotImplementedException("TODO: Implementation of ASCII85Decode.");
      //data = RemoveWhiteSpace(data);
      //int count = data.Length;
      //if (count % 2 == 1)
      //{
      //  count++;
      //  byte[] temp = data;
      //  data = new byte[count];
      //  temp.CopyTo(data, 0);
      //}
      //count <<= 2;
      //byte[] bytes = new byte[count];
      //for (int i = 0, j = 0; i < count; i++)
      //{
      //  byte hi = data[j++];
      //  byte lo = data[j++];
      //  bytes[i] = (byte)((hi > '9' ? hi - 'A' : hi - '0') * 16 + (lo > '9' ? lo - 'A' : lo - '0'));
      //}
      //return bytes;
    }
  }
}

#if just_sample_code

namespace Efw
{
  /// <summary>
  /// Base64Encoder.
  /// </summary>
  public class Base64Encoder
  {
    /// <summary>
    /// Encodes a byte array (using 1 byte per character) and returnins a base64 encoded string.
    /// </summary>
    public static string Encode(byte[] buffer)
    {
      if (buffer == null)
        throw new ArgumentNullException("buffer");

      // Encode everything.
      if (buffer.Length == 0)
        return "";
  
      int bufLen    = buffer.Length;
      int padding   = (3 - (bufLen % 3)) % 3;
      int blocks    = (bufLen + padding) / 3;
      int outBufLen = blocks * 4;
      byte[] outBytes = new byte[outBufLen];
      char[] outChars = new char[outBufLen];

      int idx = 0, idxOut = 0;
      int imax = 3 * blocks - (padding == 0 ? 0 : 3);
      while (idx < imax)
      {
        byte b1 = buffer[idx++];
        byte b2 = buffer[idx++];
        byte b3 = buffer[idx++];

        outBytes[idxOut++] = (byte)((b1 & 0xFC) >> 2);
        outBytes[idxOut++] = (byte)(((b1 & 3) << 4) + ((b2 & 0xF0) >> 4));
        outBytes[idxOut++] = (byte)(((b2 & 0xF) << 2) + ((b3 & 0xC0) >> 6));
        outBytes[idxOut++] = (byte)(b3 & 0x3F);
      }

      if (padding == 1)
      {
        byte b1 = buffer[idx++];
        byte b2 = buffer[idx++];

        outBytes[idxOut++] = (byte)((b1 & 0xFC) >> 2);
        outBytes[idxOut++] = (byte)(((b1 & 3) << 4) + ((b2 & 0xF0) >> 4));
        outBytes[idxOut++] = (byte)((b2 & 0xF) << 2);
        outBytes[idxOut++] = 64;
      }
      else if (padding == 2)
      {
        byte b1 = buffer[idx++];

        outBytes[idxOut++] = (byte)((b1 & 0xFC) >> 2);
        outBytes[idxOut++] = (byte)((b1 & 3) << 4);
        outBytes[idxOut++] = 64;
        outBytes[idxOut++] = 64;
      }

      //if (_useAsterisk)
      //  encodeTable[63] = '*';

      //TODO insert CR LF and indent
      for (int ich = 0; ich < outBufLen; ich++)
        outChars[ich] = encodeTable[outBytes[ich]];

      return new string(outChars);
    }

    static char[] encodeTable = 
      new char[65]
      {
        'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z',
        'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z',
        '0','1','2','3','4','5','6','7','8','9','+','/', '='
      };
  }
}

namespace Efw
{
  /// <summary>
  /// Base64Decoder.
  /// </summary>
  public class Base64Decoder
  {
    /// <summary>
    /// Decodes base64 encoded string to a string.
    /// Note: no conversion is done, therefore use the decoder that matches the encoder that was used.
    /// </summary>
    public static string DecodeString(string base64)
    {
      if (base64 == null)
        throw new ArgumentNullException("base64");

#if true
      // Speicherplatzoptimierung
      System.Text.Encoding encoding = System.Text.Encoding.UTF8;
      byte[] abBytes = Decode(base64);
      return encoding.GetString(abBytes);
#else
      // TODO: Encoding.GetBytes Method / Encoding.GetString Method
      byte[] abBytes = Decode(base64);
      string strRes = "";
      // We read two bytes per character:
      for (int i = 0; i < abBytes.Length; i += 2)
      {
        int j = abBytes[i] + 256 * abBytes[i + 1];
        strRes += (char)j;
      }
      return strRes;
#endif
    }

    /// <summary>
    /// Decodes base64 encoded byte array to byte array.
    /// Note: no conversion is done, therefore use the decoder that matches the encoder that was used.
    /// </summary>
    public static byte[] Decode(string base64)
    {
      if (base64 == null)
        throw new ArgumentNullException("base64");

      // Decode everything.
      if (base64 == "")
        return new byte[0];

      int length = base64.Length;
      if (length % 4 != 0)
        throw new ArgumentException("Base64 string length modulo 4 is not zero.");

      int padding = 0;
      if (base64[length - 1] == '=')
      {
        padding = 1;
        if (base64[length - 2] == '=')
          padding = 2;
      }

      int outBufLen = length / 4 * 3 - padding;
      byte[] outBytes = new byte[outBufLen];

      int idx = 0, idxOut = 0;
      while (idx < length)
      {
        byte b1 = Decode(base64[idx++]);
        byte b2 = Decode(base64[idx++]);
        byte b3 = Decode(base64[idx++]);
        byte b4 = Decode(base64[idx++]);

        outBytes[idxOut++] = (byte)((b1 << 2) + ((b2 & 0x30) >> 4));
        if (b3 == 64) break;
        outBytes[idxOut++] = (byte)(((b2 & 0xF) << 4) + ((b3 & 0x3C) >> 2));
        if (b4 == 64) break;
        outBytes[idxOut++] = (byte)(((b3 & 3) << 6) + b4);
      }
      return outBytes;
    }

    static byte Decode(char ch)
    {
      if (ch >= 'A' && ch <= 'Z')
        return (byte)(ch - 'A');
      if (ch >= 'a' && ch <= 'z')
        return (byte)(ch - 'a' + 26);
      if (ch >= '0' && ch <= '9')
        return (byte)(ch - '0' + 52);
      switch (ch)
      {
        case '+':
          return 62;

        case '/':
        case '*':
          return 63;

        case '=':
          return 64;

        default:
          //L10N
          throw new ArgumentException("Invalid character in base64 string: " + ch);
      }
    }
  }
}
#endif
