//
// PDFSharp - A library for processing PDF
//
// Authors:
//   Stefan Lange (mailto:Stefan.Lange@pdfsharp.com)
//
// Copyright (c) 2005 empira Software GmbH, Cologne (Germany)
//
// http://www.pdfsharp.com
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

using System;
using System.Diagnostics;
using System.Collections;
using System.Text;
using System.IO;
using PdfSharp.Pdf.Advanced;
using PdfSharp.Pdf.IO;

namespace PdfSharp.Pdf.Annotations
{
  /// <summary>
  /// Represents the annotations array of a page.
  /// </summary>
  public sealed class PdfAnnotations : PdfArray
  {
    internal PdfAnnotations(PdfDocument document) : base(document)
    {
    }

    public void Add(PdfAnnotation annotation)
    {
      annotation.Document = this.Document;
      this.Document.xrefTable.Add(annotation);
      Elements.Add(annotation.XRef);
    }

    //public void Insert(int index, PdfAnnotation annotation)
    //{
    //  annotation.Document = this.Document;
    //  this.annotations.Insert(index, annotation);
    //}

    public int Count
    {
      get {return Elements.Count;}
    }

    public PdfAnnotation this[int index]
    {
      get {return (PdfAnnotation)((PdfXRef)Elements[index]).Value;}
    }

    internal PdfPage Page
    { 
      get {return this.page;}
      set {this.page = value;}
    }
    PdfPage page;

    internal void WriteObject(Stream stream)
    {
//      int count = this.annotations.Count;
//      for (int idx = 0; idx < count; idx++)
//        ((PdfAnnotation)this.annotations[idx]).WriteObject(stream);
    }

    //public IEnumerator GetEnumerator()
    //{
    //  return Elements.this.annotations.GetEnumerator();
    //}
  }
}
