//
// PDFSharp - A library for processing PDF
//
// Authors:
//   Stefan Lange (mailto:Stefan.Lange@pdfsharp.com)
//
// Copyright (c) 2005 empira Software GmbH, Cologne (Germany)
//
// http://www.pdfsharp.com
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

using System;
using System.Collections;
using System.Globalization;
using System.Text;
using System.IO;
using PdfSharp.Drawing;
using PdfSharp.Internal;
using PdfSharp.Fonts.TrueType;

namespace PdfSharp.Pdf.Advanced
{
  /// <summary>
  /// Base class for FontTable, ImageTable, FormXObjectTable etc.
  /// </summary>
  internal class PdfResourceTable
  {
    public PdfResourceTable(PdfDocument document)
    {
      this.document = document;
    }
    protected PdfDocument document;

#if NET_1_1__________________________
    protected Hashtable table = new Hashtable(
      new CaseInsensitiveHashCodeProvider(CultureInfo.InvariantCulture),
      new CaseInsensitiveComparer(CultureInfo.InvariantCulture));
#endif
#if NET_2_0__________________________
    protected Hashtable table = new Hashtable(StringComparer.InvariantCultureIgnoreCase);
#endif
  }
}
