//
// PDFSharp - A library for processing PDF
//
// Authors:
//   Stefan Lange (mailto:Stefan.Lange@pdfsharp.com)
//
// Copyright (c) 2005 empira Software GmbH, Cologne (Germany)
//
// http://www.pdfsharp.com
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

#if delete
using System;

namespace PdfSharp.Pdf.Advanced_______
{
  /// <summary>
  /// Representa a PDF procedure set object. Procedure sets are considered obsolete since PDF 1.4.
  /// </summary>
  internal sealed class PdfProcedureSet : PdfArray
  {
    public PdfProcedureSet()
    {
    }

    /// <summary>
    /// Predefined keys of this dictionary.
    /// </summary>
    internal sealed class Keys : KeysBase
    {
      /// <summary>
      /// Painting and graphics state.
      /// </summary>
      [KeyInfo(KeyType.Name | KeyType.Optional)]
      public const string PDF = "/PDF";

      /// <summary>
      /// Text.
      /// </summary>
      [KeyInfo(KeyType.Name | KeyType.Optional)]
      public const string Text = "/Text";

      /// <summary>
      /// Grayscale images or image masks.
      /// </summary>
      [KeyInfo(KeyType.Name | KeyType.Optional)]
      public const string ImageB = "/ImageB";

      /// <summary>
      /// Color images.
      /// </summary>
      [KeyInfo(KeyType.Name | KeyType.Optional)]
      public const string ImageC = "/ImageC";

      /// <summary>
      /// Indexed (color-table) images.
      /// </summary>
      [KeyInfo(KeyType.Name | KeyType.Optional)]
      public const string ImageI = "/ImageI";
    }
  }
}
#endif