//
// PDFSharp - A library for processing PDF
//
// Authors:
//   Stefan Lange (mailto:Stefan.Lange@pdfsharp.com)
//
// Copyright (c) 2005 empira Software GmbH, Cologne (Germany)
//
// http://www.pdfsharp.com
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

using System;
using System.Diagnostics;
using System.Collections;
using System.Text;
using System.IO;
using System.Drawing;
using System.Drawing.Imaging;
using PdfSharp.Drawing;
using PdfSharp.Fonts.TrueType;
using PdfSharp.Internal;

namespace PdfSharp.Pdf.Advanced
{
  /// <summary>
  /// Represents an external form object (an imported page i.g).
  /// </summary>
  public sealed class PdfFormXObject : PdfXObject
  {
    //public PdfFormXObject(PdfDocument document) : base(document)
    //{
    //  Type = "/XObject";
    //  Subtype = "/Image";
    //}

#if keep_code_as_referencee
    /// <summary>
    /// Initializes a new instance of PdfFormXObject from an XImage.
    /// </summary>
    static int xxxcount = 0;
    internal PdfFormXObject(bool dontUseThisFunctionAnyMore, PdfDocument document, ImportedObjectTable impDoc, PdfPage impPage) : base(document)
    {
      xxxcount++;

      Elements.Type = "/XObject";
      Elements.Subtype = "/Form";

      PdfXRef dfdsf = impPage.Document.xrefTable[new PdfObjectID(23)];
      dfdsf.GetType();

      PdfItem res = impPage.Elements["/Resources"];
      // Unlikely but possible
      if (res != null)
      {
        PdfObject resourcesRoot;
        if (res is PdfXRef)
          resourcesRoot = ((PdfXRef)res).Value;
        else
          resourcesRoot = (PdfDictionary)res;

        PdfObject[] resources = impPage.Document.Internals.GetClosure(resourcesRoot);

#if DEBUG_
        int ccc = impPage.Document.xrefTable.objectTable.Count;
        ICollection coll = impPage.Document.xrefTable.objectTable.Keys;
        object[] objs = new object[coll.Count];
        coll.CopyTo(objs, 0);
        for (int idx = 0; idx < ccc; idx++)
        {
          object item = objs[idx];
          Debug.Assert(item.ToString() == impPage.Document.xrefTable[(PdfObjectID)item].ObjectID.ToString());
          //Debug.WriteLine(String.Format("{0} {1}", item.ToString(), impPage.Document.xrefTable[(PdfObjectID)item].ObjectNumber));
        }
#endif

//        for (int idx = 0; idx < resources.Length; idx++)
//        {
//          //Debug.WriteLine(String.Format("{2} Durchlauf {0}: {1} ", xxxcount, idx, resources[idx].ObjectID.ObjectNumber.ToString()));
//          if (resources[idx].ObjectID.ObjectNumber == 23)
//            GetType();
//        }

//        if (resourcesRoot.ObjectID.ObjectNumber == 23)
//          GetType();

        int count = resources.Length;
#if DEBUG_
        for (int idx = 0; idx < count; idx++)
        {
          if (idx > 0)
          {
            Debug.Assert(resources[idx].XRef != null);
            Debug.Assert(resources[idx].XRef.Document != null);
          }
          Debug.Assert(resources[idx].Document != null);
          if (resources[idx].ObjectID.ObjectNumber == 12)
            GetType();
        }
#endif
        // 1st step. Reuse already imported objects or clone new ones.
        for (int idx = 0; idx < count; idx++)
        {
          PdfObject obj = resources[idx];
          if (obj.ObjectNumber == 5)
            GetType();
#if true
          if (impDoc.Contains(obj.ObjectID))
          {
            // external object was already imported
            PdfXRef xref = impDoc[obj.ObjectID];
            Debug.Assert(xref != null);
            if (xref.Value == null)
              GetType();
            // replace external object by the already clone counterpart
            resources[idx] = xref.Value;
          }
          else
          {
            // external object was not imported ealier and must be cloned
            PdfObject clone = obj.Clone();
            Debug.Assert(clone.XRef == null);
            clone.Document = this.Document;
            if (obj.XRef != null)
            {
              // add it to this (the importer) document
              this.Document.xrefTable.Add(clone);
              Debug.Assert(clone.XRef != null);
//              if (obj.ObjectID.ObjectNumber == 23)
//              {
//                PdfXRef sdfasfd = impPage.Document.xrefTable[new PdfObjectID(23)];
//                sdfasfd.GetType();
//                GetType();
//              }
              // save old object identifier
              impDoc.Add(obj.ObjectID, clone.XRef);
              //Debug.WriteLine("Cloned: " + obj.ObjectID.ToString());
              // replace external object by its clone
            }
            else
            {
              // The root object (the /Resources value) is not an indirect object
              Debug.Assert(idx == 0);
              // add it to this (the importer) document
              this.Document.xrefTable.Add(clone);
              Debug.Assert(clone.XRef != null);
            }
            resources[idx] = clone;
          }
#endif
        }
#if DEBUG_
        for (int idx = 0; idx < count; idx++)
        {
          Debug.Assert(resources[idx].XRef != null);
          Debug.Assert(resources[idx].XRef.Document != null);
          Debug.Assert(resources[idx].Document != null);
          if (resources[idx].ObjectID.ObjectNumber == 12)
            GetType();
        }
#endif

        // 2nd step. Fix up indirect references that still refers to the imported document.
        for (int idx = 0; idx < count; idx++)
        {
          PdfObject obj = resources[idx];
          Debug.Assert(obj.Document != null);
          FixUpObject(impDoc, obj);
        }

         Elements["/Resources"] = resources[0].XRef;
         Debug.WriteLine("/Resources: " + resources[0].XRef.ObjectID.ToString());

      }

      // HACK 
      this.Elements["/BBox"] = new PdfRectangle(0, 0, 595, 842);
      this.Elements["/Matrix"] = new PdfRawItem("[1.1 0.1 -0.1 1 0 0]");

      PdfItem filter = impPage.Content.Elements["/Filter"];
      if (filter != null)
        this.Elements["/Filter"] = filter.Clone();

      byte[] bytes = impPage.Content.Stream.Value;
      this.Stream = new PdfStream(bytes, this);
      this.Elements["/Length"] = new PdfInteger(bytes.Length);
    }
#endif

    internal PdfFormXObject(PdfDocument thisDocument, XPdfForm form) : base(thisDocument)
    {
      Elements.Type = "/XObject";
      Elements.Subtype = "/Form";

      // Get import page
      PdfPages importPages = form.importDocument.ExternalDocument.Pages;
      if (form.PageNumber < 1 || form.PageNumber > importPages.Count)
        PSSR.ImportPageNumberOutOfRange(form.PageNumber, importPages.Count, form.path);
      PdfPage importPage = importPages[form.PageNumber - 1];

      // Import resources
      PdfItem res = importPage.Elements["/Resources"];
      if (res != null) // unlikely but possible
      {
        // Get root object
        PdfObject resourcesRoot;
        if (res is PdfXRef)
          resourcesRoot = ((PdfXRef)res).Value;
        else
          resourcesRoot = (PdfDictionary)res;

        // Get transitive closure
        PdfObject[] resources = importPage.Document.Internals.GetClosure(resourcesRoot);
        int count = resources.Length;
#if DEBUG_
        for (int idx = 0; idx < count; idx++)
        {
          Debug.Assert(resources[idx].XRef != null);
          Debug.Assert(resources[idx].XRef.Document != null);
          Debug.Assert(resources[idx].Document != null);
          if (resources[idx].ObjectID.ObjectNumber == 12)
            GetType();
        }
#endif
        // 1st step. Already imported objects are reused and new ones are cloned.
        for (int idx = 0; idx < count; idx++)
        {
          PdfObject obj = resources[idx];
          if (form.importDocument.Contains(obj.ObjectID))
          {
            // external object was already imported
            PdfXRef xref = form.importDocument[obj.ObjectID];
            Debug.Assert(xref != null);
            Debug.Assert(xref.Value != null);
            Debug.Assert(xref.Document == this.Document);
            // replace external object by the already clone counterpart
            resources[idx] = xref.Value;
          }
          else
          {
            // external object was not imported ealier and must be cloned
            PdfObject clone = obj.Clone();
            Debug.Assert(clone.XRef == null);
            clone.Document = this.Document;
            if (obj.XRef != null)
            {
              // add it to this (the importer) document
              this.Document.xrefTable.Add(clone);
              Debug.Assert(clone.XRef != null);
              // save old object identifier
              form.importDocument.Add(obj.ObjectID, clone.XRef);
              //Debug.WriteLine("Cloned: " + obj.ObjectID.ToString());
            }
            else
            {
              // The root object (the /Resources value) is not an indirect object
              Debug.Assert(idx == 0);
              // add it to this (the importer) document
              this.Document.xrefTable.Add(clone);
              Debug.Assert(clone.XRef != null);
            }
            // replace external object by its clone
            resources[idx] = clone;
          }
        }
#if DEBUG_
        for (int idx = 0; idx < count; idx++)
        {
          Debug.Assert(resources[idx].XRef != null);
          Debug.Assert(resources[idx].XRef.Document != null);
          Debug.Assert(resources[idx].Document != null);
          if (resources[idx].ObjectID.ObjectNumber == 12)
            GetType();
        }
#endif

        // 2nd step. Fix up indirect references that still refers to the import document.
        for (int idx = 0; idx < count; idx++)
        {
          PdfObject obj = resources[idx];
          Debug.Assert(obj.Document != null);
          FixUpObject(form.importDocument, obj);
        }

        // Set resources key to the root of the clones
        Elements["/Resources"] = resources[0].XRef;
      }

      // Hack
      PdfItem bbox = importPage.Elements[PdfPage.Keys.MediaBox];
      if (bbox != null)
        this.Elements["/BBox"] = bbox.Clone();

      PdfItem filter = importPage.Content.Elements["/Filter"];
      if (filter != null)
        this.Elements["/Filter"] = filter.Clone();
      
      // 595 842 297.5 421
      //this.Elements["/Matrix"] = new PdfRawItem("[0.5 0 0 -0.5 0 421]");

      // Get the stream (no cloning needed because the bytes keep untouched)
      byte[] bytes = importPage.Content.Stream.Value;
      this.Stream = new PdfStream(bytes, this);
      this.Elements["/Length"] = new PdfInteger(bytes.Length);
    }

    /// <summary>
    /// Replace all indirect references to external objects by their cloned counterparts
    /// owned by the importer document.
    /// </summary>
    void FixUpObject(ImportedObjectTable importDocument, PdfObject obj)
    {
      // TODO: merge with PdfXObject.FixUpObject
      PdfDictionary dict;
      PdfArray array;
      if ((dict = obj as PdfDictionary) != null)
      {
        // Set document for cloned direct objects
        if (dict.Document == null)
          dict.Document = this.Document;
        else
          Debug.Assert(dict.Document == this.Document);

        // Search for indirect references in all keys
        PdfName[] names = dict.Elements.Keys;
        foreach (PdfName name in names)
        {
          PdfItem item = dict.Elements[name];
          // Is item an xref?
          PdfXRef xref = item as PdfXRef;
          if (xref != null)
          {
            // Does the xref already belong to this document?
            if (xref.Document == this.Document)
            {
              // Yes: fine
              continue;
            }
            else
            {
              Debug.Assert(xref.Document == importDocument.ExternalDocument);
              // No: replace with xref of cloned object
              PdfXRef newXRef = importDocument[xref.ObjectID];
              Debug.Assert(newXRef != null);
              Debug.Assert(newXRef.Document == this.Document);
              dict.Elements[name] = newXRef;
            }
          }
          else if (item is PdfObject)
          {
            // Fix up inner objects
            FixUpObject(importDocument, (PdfObject)item);
          }
        }
      }
      else if ((array = obj as PdfArray) != null)
      {
        // Set document for cloned direct objects
        if (array.Document == null)
          array.Document = this.Document;
        else
          Debug.Assert(array.Document == this.Document);

        // Search for indirect references in all array elements
        int count = array.Elements.Count;
        for (int idx = 0; idx < count; idx++)
        {
          PdfItem item = array.Elements[idx];
          // Is item an xref?
          PdfXRef xref = item as PdfXRef;
          if (xref != null)
          {
            // Does the xref belongs to this document?
            if (xref.Document == this.Document)
            {
              // Yes: fine
              continue;
            }
            else
            {
              Debug.Assert(xref.Document == importDocument.ExternalDocument);
              // No: replace with xref of cloned object
              PdfXRef newXRef = importDocument[xref.ObjectID];
              Debug.Assert(newXRef != null);
              Debug.Assert(newXRef.Document == this.Document);
              array.Elements[idx] = newXRef;
            }
          }
          else if (item is PdfObject)
          {
            // Fix up inner objects
            FixUpObject(importDocument, (PdfObject)item);
          }
        }
      }
    }

//    /// <summary>
//    /// Returns ???
//    /// </summary>
//    public override string ToString()
//    {
//      return "Form";
//    }

    /// <summary>
    /// Common keys for all streams.
    /// </summary>
    public class Keys____ : PdfDictionary.PdfStream.Keys  // TODO: check!
    {
      /// <summary>
      /// (Optional) The type of PDF object that this dictionary describes;
      /// if present, must be XObject for an image XObject.
      /// </summary>
      [KeyInfo(KeyType.Name | KeyType.Optional)]
      public const string Type = "/Type";

      /// <summary>
      /// (Required) The type of XObject that this dictionary describes;
      /// must be Image for an image XObject.
      /// </summary>
      [KeyInfo(KeyType.Name | KeyType.Required)]
      public const string Subtype = "/Subtype";

      /// <summary>
      /// (Required) The width of the image, in samples.
      /// </summary>
      [KeyInfo(KeyType.Integer | KeyType.Required)]
      public const string Width = "/Width";

      /// <summary>
      /// (Required) The height of the image, in samples.
      /// </summary>
      [KeyInfo(KeyType.Integer | KeyType.Required)]
      public const string Height = "/Height";

      /// <summary>
      /// (Required for images, except those that use the JPXDecode filter; not allowed for image masks)
      /// The color space in which image samples are specified; it can be any type of color space except
      /// Pattern. If the image uses the JPXDecode filter, this entry is optional:
      ///  If ColorSpace is present, any color space specifications in the JPEG2000 data are ignored.
      ///  If ColorSpace is absent, the color space specifications in the JPEG2000 data are used.
      ///   The Decode array is also ignored unless ImageMask is true.
      /// </summary>
      [KeyInfo(KeyType.NameOrArray | KeyType.Required)]
      public const string ColorSpace = "/ColorSpace";

      /// <summary>
      /// (Required except for image masks and images that use the JPXDecode filter)
      /// The number of bits used to represent each color component. Only a single value may be specified;
      /// the number of bits is the same for all color components. Valid values are 1, 2, 4, 8, and 
      /// (in PDF 1.5) 16. If ImageMask is true, this entry is optional, and if specified, its value 
      /// must be 1.
      /// If the image stream uses a filter, the value of BitsPerComponent must be consistent with the 
      /// size of the data samples that the filter delivers. In particular, a CCITTFaxDecode or JBIG2Decode 
      /// filter always delivers 1-bit samples, a RunLengthDecode or DCTDecode filter delivers 8-bit samples,
      /// and an LZWDecode or FlateDecode filter delivers samples of a specified size if a predictor function
      /// is used.
      /// If the image stream uses the JPXDecode filter, this entry is optional and ignored if present.
      /// The bit depth is determined in the process of decoding the JPEG2000 image.
      /// </summary>
      [KeyInfo(KeyType.Integer | KeyType.Required)]
      public const string BitsPerComponent = "/BitsPerComponent";

      /// <summary>
      /// (Optional; PDF 1.1) The name of a color rendering intent to be used in rendering the image.
      /// Default value: the current rendering intent in the graphics state.
      /// </summary>
      [KeyInfo(KeyType.Name | KeyType.Optional)]
      public const string Intent = "/Intent";

      /// <summary>
      /// (Optional) A flag indicating whether the image is to be treated as an image mask.
      /// If this flag is true, the value of BitsPerComponent must be 1 and Mask and ColorSpace should
      /// not be specified; unmasked areas are painted using the current nonstroking color.
      /// Default value: false.
      /// </summary>
      [KeyInfo(KeyType.Boolean | KeyType.Optional)]
      public const string ImageMask = "/ImageMask";

      /// <summary>
      /// (Optional except for image masks; not allowed for image masks; PDF 1.3)
      /// An image XObject defining an image mask to be applied to this image, or an array specifying 
      /// a range of colors to be applied to it as a color key mask. If ImageMask is true, this entry
      /// must not be present.
      /// </summary>
      [KeyInfo(KeyType.StreamOrArray | KeyType.Optional)]
      public const string Mask = "/Mask";

      /// <summary>
      /// (Optional) An array of numbers describing how to map image samples into the range of values
      /// appropriate for the images color space. If ImageMask is true, the array must be either
      /// [0 1] or [1 0]; otherwise, its length must be twice the number of color components required 
      /// by ColorSpace. If the image uses the JPXDecode filter and ImageMask is false, Decode is ignored.
      /// Default value: see Decode Arrays.
      /// </summary>
      [KeyInfo(KeyType.Array | KeyType.Optional)]
      public const string Decode = "/Decode";

      /// <summary>
      /// (Optional) A flag indicating whether image interpolation is to be performed. 
      /// Default value: false.
      /// </summary>
      [KeyInfo(KeyType.Boolean | KeyType.Optional)]
      public const string Interpolate = "/Interpolate";

      /// <summary>
      /// (Optional; PDF 1.3) An array of alternate image dictionaries for this image. The order of 
      /// elements within the array has no significance. This entry may not be present in an image 
      /// XObject that is itself an alternate image.
      /// </summary>
      [KeyInfo(KeyType.Array | KeyType.Optional)]
      public const string Alternates = "/Alternates";

      /// <summary>
      /// (Optional; PDF 1.4) A subsidiary image XObject defining a soft-mask image to be used as a 
      /// source of mask shape or mask opacity values in the transparent imaging model. The alpha 
      /// source parameter in the graphics state determines whether the mask values are interpreted as
      /// shape or opacity. If present, this entry overrides the current soft mask in the graphics state,
      /// as well as the images Mask entry, if any. (However, the other transparencyrelated graphics 
      /// state parametersblend mode and alpha constantremain in effect.) If SMask is absent, the 
      /// image has no associated soft mask (although the current soft mask in the graphics state may
      /// still apply).
      /// </summary>
      [KeyInfo(KeyType.Integer | KeyType.Required)]
      public const string SMask = "/SMask";

      /// <summary>
      /// (Optional for images that use the JPXDecode filter, meaningless otherwise; PDF 1.5)
      /// A code specifying how soft-mask information encoded with image samples should be used:
      /// 0 If present, encoded soft-mask image information should be ignored.
      /// 1 The images data stream includes encoded soft-mask values. An application can create
      ///   a soft-mask image from the information to be used as a source of mask shape or mask 
      ///   opacity in the transparency imaging model.
      /// 2 The images data stream includes color channels that have been preblended with a 
      ///   background; the image data also includes an opacity channel. An application can create
      ///   a soft-mask image with a Matte entry from the opacity channel information to be used as
      ///   a source of mask shape or mask opacity in the transparency model. If this entry has a 
      ///   nonzero value, SMask should not be specified.
      /// Default value: 0.
      /// </summary>
      [KeyInfo(KeyType.Integer | KeyType.Optional)]
      public const string SMaskInData = "/SMaskInData";

      /// <summary>
      /// (Required in PDF 1.0; optional otherwise) The name by which this image XObject is 
      /// referenced in the XObject subdictionary of the current resource dictionary.
      /// </summary>
      [KeyInfo(KeyType.Name | KeyType.Optional)]
      public const string Name = "/Name";

      /// <summary>
      /// (Required if the image is a structural content item; PDF 1.3) The integer key of the 
      /// images entry in the structural parent tree.
      /// </summary>
      [KeyInfo(KeyType.Integer | KeyType.Required)]
      public const string StructParent = "/StructParent";

      /// <summary>
      /// (Optional; PDF 1.3; indirect reference preferred) The digital identifier of the images
      /// parent Web Capture content set.
      /// </summary>
      [KeyInfo(KeyType.String | KeyType.Optional)]
      public const string ID = "/ID";

      /// <summary>
      /// (Optional; PDF 1.2) An OPI version dictionary for the image. If ImageMask is true, 
      /// this entry is ignored.
      /// </summary>
      [KeyInfo(KeyType.Dictionary | KeyType.Optional)]
      public const string OPI = "/OPI";

      /// <summary>
      /// (Optional; PDF 1.4) A metadata stream containing metadata for the image.
      /// </summary>
      [KeyInfo(KeyType.Stream | KeyType.Optional)]
      public const string Metadata = "/Metadata";

      /// <summary>
      /// (Optional; PDF 1.5) An optional content group or optional content membership dictionary,
      /// specifying the optional content properties for this image XObject. Before the image is
      /// processed, its visibility is determined based on this entry. If it is determined to be 
      /// invisible, the entire image is skipped, as if there were no Do operator to invoke it.
      /// </summary>
      [KeyInfo(KeyType.Dictionary | KeyType.Optional)]
      public const string OC = "/OC";
    }
  }
}
