//
// PDFSharp - A library for processing PDF
//
// Authors:
//   Stefan Lange (mailto:Stefan.Lange@pdfsharp.com)
//
// Copyright (c) 2005 empira Software GmbH, Cologne (Germany)
//
// http://www.pdfsharp.com
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

using System;
using System.Diagnostics;
using System.Collections;
using System.Text;
using System.IO;
using PdfSharp.Pdf.Advanced;
using PdfSharp.Drawing;
using PdfSharp.Fonts.TrueType;
using PdfSharp.Internal;

namespace PdfSharp.Pdf.Advanced
{
  /// <summary>
  /// Represents the imported objects of an external document. Used to cache objects that are
  /// already imported when a PdfFormXObject is added to a page.
  /// </summary>
  internal class ImportedObjectTable
  {
    public ImportedObjectTable(PdfDocument externalDocument)
    {
      this.externalDocument = externalDocument;
    }

    /// <summary>
    /// Gets the external document.
    /// </summary>
    public PdfDocument ExternalDocument
    {
      get {return this.externalDocument;}
    }
    PdfDocument externalDocument;

    /// <summary>
    /// Indicates whether the specified object is already imported.
    /// </summary>
    public bool Contains(PdfObjectID externalID)
    {
      return this.externalIDs.Contains(externalID.ToString());
    }

    /// <summary>
    /// Adds a cloned object to this table.
    /// </summary>
    /// <param name="externalID">The object identifier in the forein object.</param>
    /// <param name="xref">The cross reference to the clone of the forein object, which belongs to
    /// this document. In general the clone has a different object identifier.</param>
    public void Add(PdfObjectID externalID, PdfXRef xref)
    {
      this.externalIDs[externalID.ToString()] = xref;
    }

    /// <summary>
    /// Gets the cloned object that corresponds to the specified external identifier.
    /// </summary>
    public PdfXRef this[PdfObjectID externalID]
    {
      get { return (PdfXRef)this.externalIDs[externalID.ToString()]; }
    }

    /// <summary>
    /// Maps external object identifiers to cross reference entries of the importing document
    /// {PdfObjectID -> PdfXRef}.
    /// </summary>
    Hashtable externalIDs = new Hashtable();
  }
}
