using System;

namespace PdfSharp.Fonts
{
  /// <summary>
  /// Testing only
  /// </summary>
  public sealed class AdobeGlyphListForNewFonts
  {
    AdobeGlyphListForNewFonts() {}

    // LATIN CAPITAL LETTER A
    public const char A                      = '\u0041';
    // LATIN CAPITAL LETTER AE
    public const char AE                     = '\u00C6';
    // LATIN CAPITAL LETTER AE WITH ACUTE
    public const char AEacute                = '\u01FC';
    // LATIN CAPITAL LETTER A WITH ACUTE
    public const char Aacute                 = '\u00C1';
    // LATIN CAPITAL LETTER A WITH BREVE
    public const char Abreve                 = '\u0102';
    // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
    public const char Acircumflex            = '\u00C2';
    // LATIN CAPITAL LETTER A WITH DIAERESIS
    public const char Adieresis              = '\u00C4';
    // LATIN CAPITAL LETTER A WITH GRAVE
    public const char Agrave                 = '\u00C0';
    // GREEK CAPITAL LETTER ALPHA
    public const char Alpha                  = '\u0391';
    // GREEK CAPITAL LETTER ALPHA WITH TONOS
    public const char Alphatonos             = '\u0386';
    // LATIN CAPITAL LETTER A WITH MACRON
    public const char Amacron                = '\u0100';
    // LATIN CAPITAL LETTER A WITH OGONEK
    public const char Aogonek                = '\u0104';
    // LATIN CAPITAL LETTER A WITH RING ABOVE
    public const char Aring                  = '\u00C5';
    // LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
    public const char Aringacute             = '\u01FA';
    // LATIN CAPITAL LETTER A WITH TILDE
    public const char Atilde                 = '\u00C3';
    // LATIN CAPITAL LETTER B
    public const char B                      = '\u0042';
    // GREEK CAPITAL LETTER BETA
    public const char Beta                   = '\u0392';
    // LATIN CAPITAL LETTER C
    public const char C                      = '\u0043';
    // LATIN CAPITAL LETTER C WITH ACUTE
    public const char Cacute                 = '\u0106';
    // LATIN CAPITAL LETTER C WITH CARON
    public const char Ccaron                 = '\u010C';
    // LATIN CAPITAL LETTER C WITH CEDILLA
    public const char Ccedilla               = '\u00C7';
    // LATIN CAPITAL LETTER C WITH CIRCUMFLEX
    public const char Ccircumflex            = '\u0108';
    // LATIN CAPITAL LETTER C WITH DOT ABOVE
    public const char Cdotaccent             = '\u010A';
    // GREEK CAPITAL LETTER CHI
    public const char Chi                    = '\u03A7';
    // LATIN CAPITAL LETTER D
    public const char D                      = '\u0044';
    // LATIN CAPITAL LETTER D WITH CARON
    public const char Dcaron                 = '\u010E';
    // LATIN CAPITAL LETTER D WITH STROKE
    public const char Dcroat                 = '\u0110';
    // INCREMENT
    public const char Delta                  = '\u2206';
    // LATIN CAPITAL LETTER E
    public const char E                      = '\u0045';
    // LATIN CAPITAL LETTER E WITH ACUTE
    public const char Eacute                 = '\u00C9';
    // LATIN CAPITAL LETTER E WITH BREVE
    public const char Ebreve                 = '\u0114';
    // LATIN CAPITAL LETTER E WITH CARON
    public const char Ecaron                 = '\u011A';
    // LATIN CAPITAL LETTER E WITH CIRCUMFLEX
    public const char Ecircumflex            = '\u00CA';
    // LATIN CAPITAL LETTER E WITH DIAERESIS
    public const char Edieresis              = '\u00CB';
    // LATIN CAPITAL LETTER E WITH DOT ABOVE
    public const char Edotaccent             = '\u0116';
    // LATIN CAPITAL LETTER E WITH GRAVE
    public const char Egrave                 = '\u00C8';
    // LATIN CAPITAL LETTER E WITH MACRON
    public const char Emacron                = '\u0112';
    // LATIN CAPITAL LETTER ENG
    public const char Eng                    = '\u014A';
    // LATIN CAPITAL LETTER E WITH OGONEK
    public const char Eogonek                = '\u0118';
    // GREEK CAPITAL LETTER EPSILON
    public const char Epsilon                = '\u0395';
    // GREEK CAPITAL LETTER EPSILON WITH TONOS
    public const char Epsilontonos           = '\u0388';
    // GREEK CAPITAL LETTER ETA
    public const char Eta                    = '\u0397';
    // GREEK CAPITAL LETTER ETA WITH TONOS
    public const char Etatonos               = '\u0389';
    // LATIN CAPITAL LETTER ETH
    public const char Eth                    = '\u00D0';
    // EURO SIGN
    public const char Euro                   = '\u20AC';
    // LATIN CAPITAL LETTER F
    public const char F                      = '\u0046';
    // LATIN CAPITAL LETTER G
    public const char G                      = '\u0047';
    // GREEK CAPITAL LETTER GAMMA
    public const char Gamma                  = '\u0393';
    // LATIN CAPITAL LETTER G WITH BREVE
    public const char Gbreve                 = '\u011E';
    // LATIN CAPITAL LETTER G WITH CARON
    public const char Gcaron                 = '\u01E6';
    // LATIN CAPITAL LETTER G WITH CIRCUMFLEX
    public const char Gcircumflex            = '\u011C';
    // LATIN CAPITAL LETTER G WITH CEDILLA
    public const char Gcommaaccent           = '\u0122';
    // LATIN CAPITAL LETTER G WITH DOT ABOVE
    public const char Gdotaccent             = '\u0120';
    // LATIN CAPITAL LETTER H
    public const char H                      = '\u0048';
    // BLACK CIRCLE
    public const char H18533                 = '\u25CF';
    // BLACK SMALL SQUARE
    public const char H18543                 = '\u25AA';
    // WHITE SMALL SQUARE
    public const char H18551                 = '\u25AB';
    // WHITE SQUARE
    public const char H22073                 = '\u25A1';
    // LATIN CAPITAL LETTER H WITH STROKE
    public const char Hbar                   = '\u0126';
    // LATIN CAPITAL LETTER H WITH CIRCUMFLEX
    public const char Hcircumflex            = '\u0124';
    // LATIN CAPITAL LETTER I
    public const char I                      = '\u0049';
    // LATIN CAPITAL LIGATURE IJ
    public const char IJ                     = '\u0132';
    // LATIN CAPITAL LETTER I WITH ACUTE
    public const char Iacute                 = '\u00CD';
    // LATIN CAPITAL LETTER I WITH BREVE
    public const char Ibreve                 = '\u012C';
    // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
    public const char Icircumflex            = '\u00CE';
    // LATIN CAPITAL LETTER I WITH DIAERESIS
    public const char Idieresis              = '\u00CF';
    // LATIN CAPITAL LETTER I WITH DOT ABOVE
    public const char Idotaccent             = '\u0130';
    // BLACK-LETTER CAPITAL I
    public const char Ifraktur               = '\u2111';
    // LATIN CAPITAL LETTER I WITH GRAVE
    public const char Igrave                 = '\u00CC';
    // LATIN CAPITAL LETTER I WITH MACRON
    public const char Imacron                = '\u012A';
    // LATIN CAPITAL LETTER I WITH OGONEK
    public const char Iogonek                = '\u012E';
    // GREEK CAPITAL LETTER IOTA
    public const char Iota                   = '\u0399';
    // GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
    public const char Iotadieresis           = '\u03AA';
    // GREEK CAPITAL LETTER IOTA WITH TONOS
    public const char Iotatonos              = '\u038A';
    // LATIN CAPITAL LETTER I WITH TILDE
    public const char Itilde                 = '\u0128';
    // LATIN CAPITAL LETTER J
    public const char J                      = '\u004A';
    // LATIN CAPITAL LETTER J WITH CIRCUMFLEX
    public const char Jcircumflex            = '\u0134';
    // LATIN CAPITAL LETTER K
    public const char K                      = '\u004B';
    // GREEK CAPITAL LETTER KAPPA
    public const char Kappa                  = '\u039A';
    // LATIN CAPITAL LETTER K WITH CEDILLA
    public const char Kcommaaccent           = '\u0136';
    // LATIN CAPITAL LETTER L
    public const char L                      = '\u004C';
    // LATIN CAPITAL LETTER L WITH ACUTE
    public const char Lacute                 = '\u0139';
    // GREEK CAPITAL LETTER LAMDA
    public const char Lambda                 = '\u039B';
    // LATIN CAPITAL LETTER L WITH CARON
    public const char Lcaron                 = '\u013D';
    // LATIN CAPITAL LETTER L WITH CEDILLA
    public const char Lcommaaccent           = '\u013B';
    // LATIN CAPITAL LETTER L WITH MIDDLE DOT
    public const char Ldot                   = '\u013F';
    // LATIN CAPITAL LETTER L WITH STROKE
    public const char Lslash                 = '\u0141';
    // LATIN CAPITAL LETTER M
    public const char M                      = '\u004D';
    // GREEK CAPITAL LETTER MU
    public const char Mu                     = '\u039C';
    // LATIN CAPITAL LETTER N
    public const char N                      = '\u004E';
    // LATIN CAPITAL LETTER N WITH ACUTE
    public const char Nacute                 = '\u0143';
    // LATIN CAPITAL LETTER N WITH CARON
    public const char Ncaron                 = '\u0147';
    // LATIN CAPITAL LETTER N WITH CEDILLA
    public const char Ncommaaccent           = '\u0145';
    // LATIN CAPITAL LETTER N WITH TILDE
    public const char Ntilde                 = '\u00D1';
    // GREEK CAPITAL LETTER NU
    public const char Nu                     = '\u039D';
    // LATIN CAPITAL LETTER O
    public const char O                      = '\u004F';
    // LATIN CAPITAL LIGATURE OE
    public const char OE                     = '\u0152';
    // LATIN CAPITAL LETTER O WITH ACUTE
    public const char Oacute                 = '\u00D3';
    // LATIN CAPITAL LETTER O WITH BREVE
    public const char Obreve                 = '\u014E';
    // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
    public const char Ocircumflex            = '\u00D4';
    // LATIN CAPITAL LETTER O WITH DIAERESIS
    public const char Odieresis              = '\u00D6';
    // LATIN CAPITAL LETTER O WITH GRAVE
    public const char Ograve                 = '\u00D2';
    // LATIN CAPITAL LETTER O WITH HORN
    public const char Ohorn                  = '\u01A0';
    // LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
    public const char Ohungarumlaut          = '\u0150';
    // LATIN CAPITAL LETTER O WITH MACRON
    public const char Omacron                = '\u014C';
    // OHM SIGN
    public const char Omega                  = '\u2126';
    // GREEK CAPITAL LETTER OMEGA WITH TONOS
    public const char Omegatonos             = '\u038F';
    // GREEK CAPITAL LETTER OMICRON
    public const char Omicron                = '\u039F';
    // GREEK CAPITAL LETTER OMICRON WITH TONOS
    public const char Omicrontonos           = '\u038C';
    // LATIN CAPITAL LETTER O WITH STROKE
    public const char Oslash                 = '\u00D8';
    // LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
    public const char Oslashacute            = '\u01FE';
    // LATIN CAPITAL LETTER O WITH TILDE
    public const char Otilde                 = '\u00D5';
    // LATIN CAPITAL LETTER P
    public const char P                      = '\u0050';
    // GREEK CAPITAL LETTER PHI
    public const char Phi                    = '\u03A6';
    // GREEK CAPITAL LETTER PI
    public const char Pi                     = '\u03A0';
    // GREEK CAPITAL LETTER PSI
    public const char Psi                    = '\u03A8';
    // LATIN CAPITAL LETTER Q
    public const char Q                      = '\u0051';
    // LATIN CAPITAL LETTER R
    public const char R                      = '\u0052';
    // LATIN CAPITAL LETTER R WITH ACUTE
    public const char Racute                 = '\u0154';
    // LATIN CAPITAL LETTER R WITH CARON
    public const char Rcaron                 = '\u0158';
    // LATIN CAPITAL LETTER R WITH CEDILLA
    public const char Rcommaaccent           = '\u0156';
    // BLACK-LETTER CAPITAL R
    public const char Rfraktur               = '\u211C';
    // GREEK CAPITAL LETTER RHO
    public const char Rho                    = '\u03A1';
    // LATIN CAPITAL LETTER S
    public const char S                      = '\u0053';
    // BOX DRAWINGS LIGHT DOWN AND RIGHT
    public const char SF010000               = '\u250C';
    // BOX DRAWINGS LIGHT UP AND RIGHT
    public const char SF020000               = '\u2514';
    // BOX DRAWINGS LIGHT DOWN AND LEFT
    public const char SF030000               = '\u2510';
    // BOX DRAWINGS LIGHT UP AND LEFT
    public const char SF040000               = '\u2518';
    // BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
    public const char SF050000               = '\u253C';
    // BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
    public const char SF060000               = '\u252C';
    // BOX DRAWINGS LIGHT UP AND HORIZONTAL
    public const char SF070000               = '\u2534';
    // BOX DRAWINGS LIGHT VERTICAL AND RIGHT
    public const char SF080000               = '\u251C';
    // BOX DRAWINGS LIGHT VERTICAL AND LEFT
    public const char SF090000               = '\u2524';
    // BOX DRAWINGS LIGHT HORIZONTAL
    public const char SF100000               = '\u2500';
    // BOX DRAWINGS LIGHT VERTICAL
    public const char SF110000               = '\u2502';
    // BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
    public const char SF190000               = '\u2561';
    // BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE
    public const char SF200000               = '\u2562';
    // BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE
    public const char SF210000               = '\u2556';
    // BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE
    public const char SF220000               = '\u2555';
    // BOX DRAWINGS DOUBLE VERTICAL AND LEFT
    public const char SF230000               = '\u2563';
    // BOX DRAWINGS DOUBLE VERTICAL
    public const char SF240000               = '\u2551';
    // BOX DRAWINGS DOUBLE DOWN AND LEFT
    public const char SF250000               = '\u2557';
    // BOX DRAWINGS DOUBLE UP AND LEFT
    public const char SF260000               = '\u255D';
    // BOX DRAWINGS UP DOUBLE AND LEFT SINGLE
    public const char SF270000               = '\u255C';
    // BOX DRAWINGS UP SINGLE AND LEFT DOUBLE
    public const char SF280000               = '\u255B';
    // BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
    public const char SF360000               = '\u255E';
    // BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE
    public const char SF370000               = '\u255F';
    // BOX DRAWINGS DOUBLE UP AND RIGHT
    public const char SF380000               = '\u255A';
    // BOX DRAWINGS DOUBLE DOWN AND RIGHT
    public const char SF390000               = '\u2554';
    // BOX DRAWINGS DOUBLE UP AND HORIZONTAL
    public const char SF400000               = '\u2569';
    // BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL
    public const char SF410000               = '\u2566';
    // BOX DRAWINGS DOUBLE VERTICAL AND RIGHT
    public const char SF420000               = '\u2560';
    // BOX DRAWINGS DOUBLE HORIZONTAL
    public const char SF430000               = '\u2550';
    // BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL
    public const char SF440000               = '\u256C';
    // BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE
    public const char SF450000               = '\u2567';
    // BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE
    public const char SF460000               = '\u2568';
    // BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE
    public const char SF470000               = '\u2564';
    // BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE
    public const char SF480000               = '\u2565';
    // BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE
    public const char SF490000               = '\u2559';
    // BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE
    public const char SF500000               = '\u2558';
    // BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE
    public const char SF510000               = '\u2552';
    // BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE
    public const char SF520000               = '\u2553';
    // BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE
    public const char SF530000               = '\u256B';
    // BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
    public const char SF540000               = '\u256A';
    // LATIN CAPITAL LETTER S WITH ACUTE
    public const char Sacute                 = '\u015A';
    // LATIN CAPITAL LETTER S WITH CARON
    public const char Scaron                 = '\u0160';
    // LATIN CAPITAL LETTER S WITH CEDILLA
    public const char Scedilla               = '\u015E';
    // LATIN CAPITAL LETTER S WITH CIRCUMFLEX
    public const char Scircumflex            = '\u015C';
    // LATIN CAPITAL LETTER S WITH COMMA BELOW
    public const char Scommaaccent           = '\u0218';
    // GREEK CAPITAL LETTER SIGMA
    public const char Sigma                  = '\u03A3';
    // LATIN CAPITAL LETTER T
    public const char T                      = '\u0054';
    // GREEK CAPITAL LETTER TAU
    public const char Tau                    = '\u03A4';
    // LATIN CAPITAL LETTER T WITH STROKE
    public const char Tbar                   = '\u0166';
    // LATIN CAPITAL LETTER T WITH CARON
    public const char Tcaron                 = '\u0164';
    // LATIN CAPITAL LETTER T WITH CEDILLA
    public const char Tcommaaccent           = '\u0162';
    // GREEK CAPITAL LETTER THETA
    public const char Theta                  = '\u0398';
    // LATIN CAPITAL LETTER THORN
    public const char Thorn                  = '\u00DE';
    // LATIN CAPITAL LETTER U
    public const char U                      = '\u0055';
    // LATIN CAPITAL LETTER U WITH ACUTE
    public const char Uacute                 = '\u00DA';
    // LATIN CAPITAL LETTER U WITH BREVE
    public const char Ubreve                 = '\u016C';
    // LATIN CAPITAL LETTER U WITH CIRCUMFLEX
    public const char Ucircumflex            = '\u00DB';
    // LATIN CAPITAL LETTER U WITH DIAERESIS
    public const char Udieresis              = '\u00DC';
    // LATIN CAPITAL LETTER U WITH GRAVE
    public const char Ugrave                 = '\u00D9';
    // LATIN CAPITAL LETTER U WITH HORN
    public const char Uhorn                  = '\u01AF';
    // LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
    public const char Uhungarumlaut          = '\u0170';
    // LATIN CAPITAL LETTER U WITH MACRON
    public const char Umacron                = '\u016A';
    // LATIN CAPITAL LETTER U WITH OGONEK
    public const char Uogonek                = '\u0172';
    // GREEK CAPITAL LETTER UPSILON
    public const char Upsilon                = '\u03A5';
    // GREEK UPSILON WITH HOOK SYMBOL
    public const char Upsilon1               = '\u03D2';
    // GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
    public const char Upsilondieresis        = '\u03AB';
    // GREEK CAPITAL LETTER UPSILON WITH TONOS
    public const char Upsilontonos           = '\u038E';
    // LATIN CAPITAL LETTER U WITH RING ABOVE
    public const char Uring                  = '\u016E';
    // LATIN CAPITAL LETTER U WITH TILDE
    public const char Utilde                 = '\u0168';
    // LATIN CAPITAL LETTER V
    public const char V                      = '\u0056';
    // LATIN CAPITAL LETTER W
    public const char W                      = '\u0057';
    // LATIN CAPITAL LETTER W WITH ACUTE
    public const char Wacute                 = '\u1E82';
    // LATIN CAPITAL LETTER W WITH CIRCUMFLEX
    public const char Wcircumflex            = '\u0174';
    // LATIN CAPITAL LETTER W WITH DIAERESIS
    public const char Wdieresis              = '\u1E84';
    // LATIN CAPITAL LETTER W WITH GRAVE
    public const char Wgrave                 = '\u1E80';
    // LATIN CAPITAL LETTER X
    public const char X                      = '\u0058';
    // GREEK CAPITAL LETTER XI
    public const char Xi                     = '\u039E';
    // LATIN CAPITAL LETTER Y
    public const char Y                      = '\u0059';
    // LATIN CAPITAL LETTER Y WITH ACUTE
    public const char Yacute                 = '\u00DD';
    // LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
    public const char Ycircumflex            = '\u0176';
    // LATIN CAPITAL LETTER Y WITH DIAERESIS
    public const char Ydieresis              = '\u0178';
    // LATIN CAPITAL LETTER Y WITH GRAVE
    public const char Ygrave                 = '\u1EF2';
    // LATIN CAPITAL LETTER Z
    public const char Z                      = '\u005A';
    // LATIN CAPITAL LETTER Z WITH ACUTE
    public const char Zacute                 = '\u0179';
    // LATIN CAPITAL LETTER Z WITH CARON
    public const char Zcaron                 = '\u017D';
    // LATIN CAPITAL LETTER Z WITH DOT ABOVE
    public const char Zdotaccent             = '\u017B';
    // GREEK CAPITAL LETTER ZETA
    public const char Zeta                   = '\u0396';
    // LATIN SMALL LETTER A
    public const char a                      = '\u0061';
    // LATIN SMALL LETTER A WITH ACUTE
    public const char aacute                 = '\u00E1';
    // LATIN SMALL LETTER A WITH BREVE
    public const char abreve                 = '\u0103';
    // LATIN SMALL LETTER A WITH CIRCUMFLEX
    public const char acircumflex            = '\u00E2';
    // ACUTE ACCENT
    public const char acute                  = '\u00B4';
    // COMBINING ACUTE ACCENT
    public const char acutecomb              = '\u0301';
    // LATIN SMALL LETTER A WITH DIAERESIS
    public const char adieresis              = '\u00E4';
    // LATIN SMALL LETTER AE
    public const char ae                     = '\u00E6';
    // LATIN SMALL LETTER AE WITH ACUTE
    public const char aeacute                = '\u01FD';
    // HORIZONTAL BAR
    public const char afii00208              = '\u2015';
    // CYRILLIC CAPITAL LETTER A
    public const char afii10017              = '\u0410';
    // CYRILLIC CAPITAL LETTER BE
    public const char afii10018              = '\u0411';
    // CYRILLIC CAPITAL LETTER VE
    public const char afii10019              = '\u0412';
    // CYRILLIC CAPITAL LETTER GHE
    public const char afii10020              = '\u0413';
    // CYRILLIC CAPITAL LETTER DE
    public const char afii10021              = '\u0414';
    // CYRILLIC CAPITAL LETTER IE
    public const char afii10022              = '\u0415';
    // CYRILLIC CAPITAL LETTER IO
    public const char afii10023              = '\u0401';
    // CYRILLIC CAPITAL LETTER ZHE
    public const char afii10024              = '\u0416';
    // CYRILLIC CAPITAL LETTER ZE
    public const char afii10025              = '\u0417';
    // CYRILLIC CAPITAL LETTER I
    public const char afii10026              = '\u0418';
    // CYRILLIC CAPITAL LETTER SHORT I
    public const char afii10027              = '\u0419';
    // CYRILLIC CAPITAL LETTER KA
    public const char afii10028              = '\u041A';
    // CYRILLIC CAPITAL LETTER EL
    public const char afii10029              = '\u041B';
    // CYRILLIC CAPITAL LETTER EM
    public const char afii10030              = '\u041C';
    // CYRILLIC CAPITAL LETTER EN
    public const char afii10031              = '\u041D';
    // CYRILLIC CAPITAL LETTER O
    public const char afii10032              = '\u041E';
    // CYRILLIC CAPITAL LETTER PE
    public const char afii10033              = '\u041F';
    // CYRILLIC CAPITAL LETTER ER
    public const char afii10034              = '\u0420';
    // CYRILLIC CAPITAL LETTER ES
    public const char afii10035              = '\u0421';
    // CYRILLIC CAPITAL LETTER TE
    public const char afii10036              = '\u0422';
    // CYRILLIC CAPITAL LETTER U
    public const char afii10037              = '\u0423';
    // CYRILLIC CAPITAL LETTER EF
    public const char afii10038              = '\u0424';
    // CYRILLIC CAPITAL LETTER HA
    public const char afii10039              = '\u0425';
    // CYRILLIC CAPITAL LETTER TSE
    public const char afii10040              = '\u0426';
    // CYRILLIC CAPITAL LETTER CHE
    public const char afii10041              = '\u0427';
    // CYRILLIC CAPITAL LETTER SHA
    public const char afii10042              = '\u0428';
    // CYRILLIC CAPITAL LETTER SHCHA
    public const char afii10043              = '\u0429';
    // CYRILLIC CAPITAL LETTER HARD SIGN
    public const char afii10044              = '\u042A';
    // CYRILLIC CAPITAL LETTER YERU
    public const char afii10045              = '\u042B';
    // CYRILLIC CAPITAL LETTER SOFT SIGN
    public const char afii10046              = '\u042C';
    // CYRILLIC CAPITAL LETTER E
    public const char afii10047              = '\u042D';
    // CYRILLIC CAPITAL LETTER YU
    public const char afii10048              = '\u042E';
    // CYRILLIC CAPITAL LETTER YA
    public const char afii10049              = '\u042F';
    // CYRILLIC CAPITAL LETTER GHE WITH UPTURN
    public const char afii10050              = '\u0490';
    // CYRILLIC CAPITAL LETTER DJE
    public const char afii10051              = '\u0402';
    // CYRILLIC CAPITAL LETTER GJE
    public const char afii10052              = '\u0403';
    // CYRILLIC CAPITAL LETTER UKRAINIAN IE
    public const char afii10053              = '\u0404';
    // CYRILLIC CAPITAL LETTER DZE
    public const char afii10054              = '\u0405';
    // CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
    public const char afii10055              = '\u0406';
    // CYRILLIC CAPITAL LETTER YI
    public const char afii10056              = '\u0407';
    // CYRILLIC CAPITAL LETTER JE
    public const char afii10057              = '\u0408';
    // CYRILLIC CAPITAL LETTER LJE
    public const char afii10058              = '\u0409';
    // CYRILLIC CAPITAL LETTER NJE
    public const char afii10059              = '\u040A';
    // CYRILLIC CAPITAL LETTER TSHE
    public const char afii10060              = '\u040B';
    // CYRILLIC CAPITAL LETTER KJE
    public const char afii10061              = '\u040C';
    // CYRILLIC CAPITAL LETTER SHORT U
    public const char afii10062              = '\u040E';
    // CYRILLIC SMALL LETTER A
    public const char afii10065              = '\u0430';
    // CYRILLIC SMALL LETTER BE
    public const char afii10066              = '\u0431';
    // CYRILLIC SMALL LETTER VE
    public const char afii10067              = '\u0432';
    // CYRILLIC SMALL LETTER GHE
    public const char afii10068              = '\u0433';
    // CYRILLIC SMALL LETTER DE
    public const char afii10069              = '\u0434';
    // CYRILLIC SMALL LETTER IE
    public const char afii10070              = '\u0435';
    // CYRILLIC SMALL LETTER IO
    public const char afii10071              = '\u0451';
    // CYRILLIC SMALL LETTER ZHE
    public const char afii10072              = '\u0436';
    // CYRILLIC SMALL LETTER ZE
    public const char afii10073              = '\u0437';
    // CYRILLIC SMALL LETTER I
    public const char afii10074              = '\u0438';
    // CYRILLIC SMALL LETTER SHORT I
    public const char afii10075              = '\u0439';
    // CYRILLIC SMALL LETTER KA
    public const char afii10076              = '\u043A';
    // CYRILLIC SMALL LETTER EL
    public const char afii10077              = '\u043B';
    // CYRILLIC SMALL LETTER EM
    public const char afii10078              = '\u043C';
    // CYRILLIC SMALL LETTER EN
    public const char afii10079              = '\u043D';
    // CYRILLIC SMALL LETTER O
    public const char afii10080              = '\u043E';
    // CYRILLIC SMALL LETTER PE
    public const char afii10081              = '\u043F';
    // CYRILLIC SMALL LETTER ER
    public const char afii10082              = '\u0440';
    // CYRILLIC SMALL LETTER ES
    public const char afii10083              = '\u0441';
    // CYRILLIC SMALL LETTER TE
    public const char afii10084              = '\u0442';
    // CYRILLIC SMALL LETTER U
    public const char afii10085              = '\u0443';
    // CYRILLIC SMALL LETTER EF
    public const char afii10086              = '\u0444';
    // CYRILLIC SMALL LETTER HA
    public const char afii10087              = '\u0445';
    // CYRILLIC SMALL LETTER TSE
    public const char afii10088              = '\u0446';
    // CYRILLIC SMALL LETTER CHE
    public const char afii10089              = '\u0447';
    // CYRILLIC SMALL LETTER SHA
    public const char afii10090              = '\u0448';
    // CYRILLIC SMALL LETTER SHCHA
    public const char afii10091              = '\u0449';
    // CYRILLIC SMALL LETTER HARD SIGN
    public const char afii10092              = '\u044A';
    // CYRILLIC SMALL LETTER YERU
    public const char afii10093              = '\u044B';
    // CYRILLIC SMALL LETTER SOFT SIGN
    public const char afii10094              = '\u044C';
    // CYRILLIC SMALL LETTER E
    public const char afii10095              = '\u044D';
    // CYRILLIC SMALL LETTER YU
    public const char afii10096              = '\u044E';
    // CYRILLIC SMALL LETTER YA
    public const char afii10097              = '\u044F';
    // CYRILLIC SMALL LETTER GHE WITH UPTURN
    public const char afii10098              = '\u0491';
    // CYRILLIC SMALL LETTER DJE
    public const char afii10099              = '\u0452';
    // CYRILLIC SMALL LETTER GJE
    public const char afii10100              = '\u0453';
    // CYRILLIC SMALL LETTER UKRAINIAN IE
    public const char afii10101              = '\u0454';
    // CYRILLIC SMALL LETTER DZE
    public const char afii10102              = '\u0455';
    // CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
    public const char afii10103              = '\u0456';
    // CYRILLIC SMALL LETTER YI
    public const char afii10104              = '\u0457';
    // CYRILLIC SMALL LETTER JE
    public const char afii10105              = '\u0458';
    // CYRILLIC SMALL LETTER LJE
    public const char afii10106              = '\u0459';
    // CYRILLIC SMALL LETTER NJE
    public const char afii10107              = '\u045A';
    // CYRILLIC SMALL LETTER TSHE
    public const char afii10108              = '\u045B';
    // CYRILLIC SMALL LETTER KJE
    public const char afii10109              = '\u045C';
    // CYRILLIC SMALL LETTER SHORT U
    public const char afii10110              = '\u045E';
    // CYRILLIC CAPITAL LETTER DZHE
    public const char afii10145              = '\u040F';
    // CYRILLIC CAPITAL LETTER YAT
    public const char afii10146              = '\u0462';
    // CYRILLIC CAPITAL LETTER FITA
    public const char afii10147              = '\u0472';
    // CYRILLIC CAPITAL LETTER IZHITSA
    public const char afii10148              = '\u0474';
    // CYRILLIC SMALL LETTER DZHE
    public const char afii10193              = '\u045F';
    // CYRILLIC SMALL LETTER YAT
    public const char afii10194              = '\u0463';
    // CYRILLIC SMALL LETTER FITA
    public const char afii10195              = '\u0473';
    // CYRILLIC SMALL LETTER IZHITSA
    public const char afii10196              = '\u0475';
    // CYRILLIC SMALL LETTER SCHWA
    public const char afii10846              = '\u04D9';
    // LEFT-TO-RIGHT MARK
    public const char afii299                = '\u200E';
    // RIGHT-TO-LEFT MARK
    public const char afii300                = '\u200F';
    // ZERO WIDTH JOINER
    public const char afii301                = '\u200D';
    // ARABIC PERCENT SIGN
    public const char afii57381              = '\u066A';
    // ARABIC COMMA
    public const char afii57388              = '\u060C';
    // ARABIC-INDIC DIGIT ZERO
    public const char afii57392              = '\u0660';
    // ARABIC-INDIC DIGIT ONE
    public const char afii57393              = '\u0661';
    // ARABIC-INDIC DIGIT TWO
    public const char afii57394              = '\u0662';
    // ARABIC-INDIC DIGIT THREE
    public const char afii57395              = '\u0663';
    // ARABIC-INDIC DIGIT FOUR
    public const char afii57396              = '\u0664';
    // ARABIC-INDIC DIGIT FIVE
    public const char afii57397              = '\u0665';
    // ARABIC-INDIC DIGIT SIX
    public const char afii57398              = '\u0666';
    // ARABIC-INDIC DIGIT SEVEN
    public const char afii57399              = '\u0667';
    // ARABIC-INDIC DIGIT EIGHT
    public const char afii57400              = '\u0668';
    // ARABIC-INDIC DIGIT NINE
    public const char afii57401              = '\u0669';
    // ARABIC SEMICOLON
    public const char afii57403              = '\u061B';
    // ARABIC QUESTION MARK
    public const char afii57407              = '\u061F';
    // ARABIC LETTER HAMZA
    public const char afii57409              = '\u0621';
    // ARABIC LETTER ALEF WITH MADDA ABOVE
    public const char afii57410              = '\u0622';
    // ARABIC LETTER ALEF WITH HAMZA ABOVE
    public const char afii57411              = '\u0623';
    // ARABIC LETTER WAW WITH HAMZA ABOVE
    public const char afii57412              = '\u0624';
    // ARABIC LETTER ALEF WITH HAMZA BELOW
    public const char afii57413              = '\u0625';
    // ARABIC LETTER YEH WITH HAMZA ABOVE
    public const char afii57414              = '\u0626';
    // ARABIC LETTER ALEF
    public const char afii57415              = '\u0627';
    // ARABIC LETTER BEH
    public const char afii57416              = '\u0628';
    // ARABIC LETTER TEH MARBUTA
    public const char afii57417              = '\u0629';
    // ARABIC LETTER TEH
    public const char afii57418              = '\u062A';
    // ARABIC LETTER THEH
    public const char afii57419              = '\u062B';
    // ARABIC LETTER JEEM
    public const char afii57420              = '\u062C';
    // ARABIC LETTER HAH
    public const char afii57421              = '\u062D';
    // ARABIC LETTER KHAH
    public const char afii57422              = '\u062E';
    // ARABIC LETTER DAL
    public const char afii57423              = '\u062F';
    // ARABIC LETTER THAL
    public const char afii57424              = '\u0630';
    // ARABIC LETTER REH
    public const char afii57425              = '\u0631';
    // ARABIC LETTER ZAIN
    public const char afii57426              = '\u0632';
    // ARABIC LETTER SEEN
    public const char afii57427              = '\u0633';
    // ARABIC LETTER SHEEN
    public const char afii57428              = '\u0634';
    // ARABIC LETTER SAD
    public const char afii57429              = '\u0635';
    // ARABIC LETTER DAD
    public const char afii57430              = '\u0636';
    // ARABIC LETTER TAH
    public const char afii57431              = '\u0637';
    // ARABIC LETTER ZAH
    public const char afii57432              = '\u0638';
    // ARABIC LETTER AIN
    public const char afii57433              = '\u0639';
    // ARABIC LETTER GHAIN
    public const char afii57434              = '\u063A';
    // ARABIC TATWEEL
    public const char afii57440              = '\u0640';
    // ARABIC LETTER FEH
    public const char afii57441              = '\u0641';
    // ARABIC LETTER QAF
    public const char afii57442              = '\u0642';
    // ARABIC LETTER KAF
    public const char afii57443              = '\u0643';
    // ARABIC LETTER LAM
    public const char afii57444              = '\u0644';
    // ARABIC LETTER MEEM
    public const char afii57445              = '\u0645';
    // ARABIC LETTER NOON
    public const char afii57446              = '\u0646';
    // ARABIC LETTER WAW
    public const char afii57448              = '\u0648';
    // ARABIC LETTER ALEF MAKSURA
    public const char afii57449              = '\u0649';
    // ARABIC LETTER YEH
    public const char afii57450              = '\u064A';
    // ARABIC FATHATAN
    public const char afii57451              = '\u064B';
    // ARABIC DAMMATAN
    public const char afii57452              = '\u064C';
    // ARABIC KASRATAN
    public const char afii57453              = '\u064D';
    // ARABIC FATHA
    public const char afii57454              = '\u064E';
    // ARABIC DAMMA
    public const char afii57455              = '\u064F';
    // ARABIC KASRA
    public const char afii57456              = '\u0650';
    // ARABIC SHADDA
    public const char afii57457              = '\u0651';
    // ARABIC SUKUN
    public const char afii57458              = '\u0652';
    // ARABIC LETTER HEH
    public const char afii57470              = '\u0647';
    // ARABIC LETTER VEH
    public const char afii57505              = '\u06A4';
    // ARABIC LETTER PEH
    public const char afii57506              = '\u067E';
    // ARABIC LETTER TCHEH
    public const char afii57507              = '\u0686';
    // ARABIC LETTER JEH
    public const char afii57508              = '\u0698';
    // ARABIC LETTER GAF
    public const char afii57509              = '\u06AF';
    // ARABIC LETTER TTEH
    public const char afii57511              = '\u0679';
    // ARABIC LETTER DDAL
    public const char afii57512              = '\u0688';
    // ARABIC LETTER RREH
    public const char afii57513              = '\u0691';
    // ARABIC LETTER NOON GHUNNA
    public const char afii57514              = '\u06BA';
    // ARABIC LETTER YEH BARREE
    public const char afii57519              = '\u06D2';
    // ARABIC LETTER AE
    public const char afii57534              = '\u06D5';
    // NEW SHEQEL SIGN
    public const char afii57636              = '\u20AA';
    // HEBREW PUNCTUATION MAQAF
    public const char afii57645              = '\u05BE';
    // HEBREW PUNCTUATION SOF PASUQ
    public const char afii57658              = '\u05C3';
    // HEBREW LETTER ALEF
    public const char afii57664              = '\u05D0';
    // HEBREW LETTER BET
    public const char afii57665              = '\u05D1';
    // HEBREW LETTER GIMEL
    public const char afii57666              = '\u05D2';
    // HEBREW LETTER DALET
    public const char afii57667              = '\u05D3';
    // HEBREW LETTER HE
    public const char afii57668              = '\u05D4';
    // HEBREW LETTER VAV
    public const char afii57669              = '\u05D5';
    // HEBREW LETTER ZAYIN
    public const char afii57670              = '\u05D6';
    // HEBREW LETTER HET
    public const char afii57671              = '\u05D7';
    // HEBREW LETTER TET
    public const char afii57672              = '\u05D8';
    // HEBREW LETTER YOD
    public const char afii57673              = '\u05D9';
    // HEBREW LETTER FINAL KAF
    public const char afii57674              = '\u05DA';
    // HEBREW LETTER KAF
    public const char afii57675              = '\u05DB';
    // HEBREW LETTER LAMED
    public const char afii57676              = '\u05DC';
    // HEBREW LETTER FINAL MEM
    public const char afii57677              = '\u05DD';
    // HEBREW LETTER MEM
    public const char afii57678              = '\u05DE';
    // HEBREW LETTER FINAL NUN
    public const char afii57679              = '\u05DF';
    // HEBREW LETTER NUN
    public const char afii57680              = '\u05E0';
    // HEBREW LETTER SAMEKH
    public const char afii57681              = '\u05E1';
    // HEBREW LETTER AYIN
    public const char afii57682              = '\u05E2';
    // HEBREW LETTER FINAL PE
    public const char afii57683              = '\u05E3';
    // HEBREW LETTER PE
    public const char afii57684              = '\u05E4';
    // HEBREW LETTER FINAL TSADI
    public const char afii57685              = '\u05E5';
    // HEBREW LETTER TSADI
    public const char afii57686              = '\u05E6';
    // HEBREW LETTER QOF
    public const char afii57687              = '\u05E7';
    // HEBREW LETTER RESH
    public const char afii57688              = '\u05E8';
    // HEBREW LETTER SHIN
    public const char afii57689              = '\u05E9';
    // HEBREW LETTER TAV
    public const char afii57690              = '\u05EA';
    // HEBREW LIGATURE YIDDISH DOUBLE VAV
    public const char afii57716              = '\u05F0';
    // HEBREW LIGATURE YIDDISH VAV YOD
    public const char afii57717              = '\u05F1';
    // HEBREW LIGATURE YIDDISH DOUBLE YOD
    public const char afii57718              = '\u05F2';
    // HEBREW POINT HIRIQ
    public const char afii57793              = '\u05B4';
    // HEBREW POINT TSERE
    public const char afii57794              = '\u05B5';
    // HEBREW POINT SEGOL
    public const char afii57795              = '\u05B6';
    // HEBREW POINT QUBUTS
    public const char afii57796              = '\u05BB';
    // HEBREW POINT QAMATS
    public const char afii57797              = '\u05B8';
    // HEBREW POINT PATAH
    public const char afii57798              = '\u05B7';
    // HEBREW POINT SHEVA
    public const char afii57799              = '\u05B0';
    // HEBREW POINT HATAF PATAH
    public const char afii57800              = '\u05B2';
    // HEBREW POINT HATAF SEGOL
    public const char afii57801              = '\u05B1';
    // HEBREW POINT HATAF QAMATS
    public const char afii57802              = '\u05B3';
    // HEBREW POINT SIN DOT
    public const char afii57803              = '\u05C2';
    // HEBREW POINT SHIN DOT
    public const char afii57804              = '\u05C1';
    // HEBREW POINT HOLAM
    public const char afii57806              = '\u05B9';
    // HEBREW POINT DAGESH OR MAPIQ
    public const char afii57807              = '\u05BC';
    // HEBREW POINT METEG
    public const char afii57839              = '\u05BD';
    // HEBREW POINT RAFE
    public const char afii57841              = '\u05BF';
    // HEBREW PUNCTUATION PASEQ
    public const char afii57842              = '\u05C0';
    // MODIFIER LETTER APOSTROPHE
    public const char afii57929              = '\u02BC';
    // CARE OF
    public const char afii61248              = '\u2105';
    // SCRIPT SMALL L
    public const char afii61289              = '\u2113';
    // NUMERO SIGN
    public const char afii61352              = '\u2116';
    // POP DIRECTIONAL FORMATTING
    public const char afii61573              = '\u202C';
    // LEFT-TO-RIGHT OVERRIDE
    public const char afii61574              = '\u202D';
    // RIGHT-TO-LEFT OVERRIDE
    public const char afii61575              = '\u202E';
    // ZERO WIDTH NON-JOINER
    public const char afii61664              = '\u200C';
    // ARABIC FIVE POINTED STAR
    public const char afii63167              = '\u066D';
    // MODIFIER LETTER REVERSED COMMA
    public const char afii64937              = '\u02BD';
    // LATIN SMALL LETTER A WITH GRAVE
    public const char agrave                 = '\u00E0';
    // ALEF SYMBOL
    public const char aleph                  = '\u2135';
    // GREEK SMALL LETTER ALPHA
    public const char alpha                  = '\u03B1';
    // GREEK SMALL LETTER ALPHA WITH TONOS
    public const char alphatonos             = '\u03AC';
    // LATIN SMALL LETTER A WITH MACRON
    public const char amacron                = '\u0101';
    // AMPERSAND
    public const char ampersand              = '\u0026';
    // ANGLE
    public const char angle                  = '\u2220';
    // LEFT-POINTING ANGLE BRACKET
    public const char angleleft              = '\u2329';
    // RIGHT-POINTING ANGLE BRACKET
    public const char angleright             = '\u232A';
    // GREEK ANO TELEIA
    public const char anoteleia              = '\u0387';
    // LATIN SMALL LETTER A WITH OGONEK
    public const char aogonek                = '\u0105';
    // ALMOST EQUAL TO
    public const char approxequal            = '\u2248';
    // LATIN SMALL LETTER A WITH RING ABOVE
    public const char aring                  = '\u00E5';
    // LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
    public const char aringacute             = '\u01FB';
    // LEFT RIGHT ARROW
    public const char arrowboth              = '\u2194';
    // LEFT RIGHT DOUBLE ARROW
    public const char arrowdblboth           = '\u21D4';
    // DOWNWARDS DOUBLE ARROW
    public const char arrowdbldown           = '\u21D3';
    // LEFTWARDS DOUBLE ARROW
    public const char arrowdblleft           = '\u21D0';
    // RIGHTWARDS DOUBLE ARROW
    public const char arrowdblright          = '\u21D2';
    // UPWARDS DOUBLE ARROW
    public const char arrowdblup             = '\u21D1';
    // DOWNWARDS ARROW
    public const char arrowdown              = '\u2193';
    // LEFTWARDS ARROW
    public const char arrowleft              = '\u2190';
    // RIGHTWARDS ARROW
    public const char arrowright             = '\u2192';
    // UPWARDS ARROW
    public const char arrowup                = '\u2191';
    // UP DOWN ARROW
    public const char arrowupdn              = '\u2195';
    // UP DOWN ARROW WITH BASE
    public const char arrowupdnbse           = '\u21A8';

    // EXTENDER
    //public const char ARROW                   = '\u;arrowvertex;VERTICAL' 

    // CIRCUMFLEX ACCENT                                      
    public const char asciicircum            = '\u005E';
    // TILDE
    public const char asciitilde             = '\u007E';
    // ASTERISK
    public const char asterisk               = '\u002A';
    // ASTERISK OPERATOR
    public const char asteriskmath           = '\u2217';
    // COMMERCIAL AT
    public const char at                     = '\u0040';
    // LATIN SMALL LETTER A WITH TILDE
    public const char atilde                 = '\u00E3';
    // LATIN SMALL LETTER B
    public const char b                      = '\u0062';
    // REVERSE SOLIDUS
    public const char backslash              = '\u005C';
    // VERTICAL LINE
    public const char bar                    = '\u007C';
    // GREEK SMALL LETTER BETA
    public const char beta                   = '\u03B2';
    // FULL BLOCK
    public const char block                  = '\u2588';
    // LEFT CURLY BRACKET
    public const char braceleft              = '\u007B';
    // RIGHT CURLY BRACKET
    public const char braceright             = '\u007D';
    // LEFT SQUARE BRACKET
    public const char bracketleft            = '\u005B';
    // RIGHT SQUARE BRACKET
    public const char bracketright           = '\u005D';
    // BREVE
    public const char breve                  = '\u02D8';
    // BROKEN BAR
    public const char brokenbar              = '\u00A6';
    // BULLET
    public const char bullet                 = '\u2022';
    // LATIN SMALL LETTER C
    public const char c                      = '\u0063';
    // LATIN SMALL LETTER C WITH ACUTE
    public const char cacute                 = '\u0107';
    // CARON
    public const char caron                  = '\u02C7';
    // DOWNWARDS ARROW WITH CORNER LEFTWARDS
    public const char carriagereturn         = '\u21B5';
    // LATIN SMALL LETTER C WITH CARON
    public const char ccaron                 = '\u010D';
    // LATIN SMALL LETTER C WITH CEDILLA
    public const char ccedilla               = '\u00E7';
    // LATIN SMALL LETTER C WITH CIRCUMFLEX
    public const char ccircumflex            = '\u0109';
    // LATIN SMALL LETTER C WITH DOT ABOVE
    public const char cdotaccent             = '\u010B';
    // CEDILLA
    public const char cedilla                = '\u00B8';
    // CENT SIGN
    public const char cent                   = '\u00A2';
    // GREEK SMALL LETTER CHI
    public const char chi                    = '\u03C7';
    // WHITE CIRCLE
    public const char circle                 = '\u25CB';
    // CIRCLED TIMES
    public const char circlemultiply         = '\u2297';
    // CIRCLED PLUS
    public const char circleplus             = '\u2295';
    // MODIFIER LETTER CIRCUMFLEX ACCENT
    public const char circumflex             = '\u02C6';
    // BLACK CLUB SUIT
    public const char club                   = '\u2663';
    // COLON
    public const char colon                  = '\u003A';
    // COLON SIGN
    public const char colonmonetary          = '\u20A1';
    // COMMA
    public const char comma                  = '\u002C';
    // APPROXIMATELY EQUAL TO
    public const char congruent              = '\u2245';
    // COPYRIGHT SIGN
    public const char copyright              = '\u00A9';
    // CURRENCY SIGN
    public const char currency               = '\u00A4';
    // LATIN SMALL LETTER D
    public const char d                      = '\u0064';
    // DAGGER
    public const char dagger                 = '\u2020';
    // DOUBLE DAGGER
    public const char daggerdbl              = '\u2021';
    // LATIN SMALL LETTER D WITH CARON
    public const char dcaron                 = '\u010F';
    // LATIN SMALL LETTER D WITH STROKE
    public const char dcroat                 = '\u0111';
    // DEGREE SIGN
    public const char degree                 = '\u00B0';
    // GREEK SMALL LETTER DELTA
    public const char delta                  = '\u03B4';
    // BLACK DIAMOND SUIT
    public const char diamond                = '\u2666';
    // DIAERESIS
    public const char dieresis               = '\u00A8';
    // GREEK DIALYTIKA TONOS
    public const char dieresistonos          = '\u0385';
    // DIVISION SIGN
    public const char divide                 = '\u00F7';
    // DARK SHADE
    public const char dkshade                = '\u2593';
    // LOWER HALF BLOCK
    public const char dnblock                = '\u2584';
    // DOLLAR SIGN
    public const char dollar                 = '\u0024';
    // DONG SIGN
    public const char dong                   = '\u20AB';
    // DOT ABOVE
    public const char dotaccent              = '\u02D9';
    // COMBINING DOT BELOW
    public const char dotbelowcomb           = '\u0323';
    // LATIN SMALL LETTER DOTLESS I
    public const char dotlessi               = '\u0131';
    // DOT OPERATOR
    public const char dotmath                = '\u22C5';
    // LATIN SMALL LETTER E
    public const char e                      = '\u0065';
    // LATIN SMALL LETTER E WITH ACUTE
    public const char eacute                 = '\u00E9';
    // LATIN SMALL LETTER E WITH BREVE
    public const char ebreve                 = '\u0115';
    // LATIN SMALL LETTER E WITH CARON
    public const char ecaron                 = '\u011B';
    // LATIN SMALL LETTER E WITH CIRCUMFLEX
    public const char ecircumflex            = '\u00EA';
    // LATIN SMALL LETTER E WITH DIAERESIS
    public const char edieresis              = '\u00EB';
    // LATIN SMALL LETTER E WITH DOT ABOVE
    public const char edotaccent             = '\u0117';
    // LATIN SMALL LETTER E WITH GRAVE
    public const char egrave                 = '\u00E8';
    // DIGIT EIGHT
    public const char eight                  = '\u0038';
    // ELEMENT OF
    public const char element                = '\u2208';
    // HORIZONTAL ELLIPSIS
    public const char ellipsis               = '\u2026';
    // LATIN SMALL LETTER E WITH MACRON
    public const char emacron                = '\u0113';
    // EM DASH
    public const char emdash                 = '\u2014';
    // EMPTY SET
    public const char emptyset               = '\u2205';
    // EN DASH
    public const char endash                 = '\u2013';
    // LATIN SMALL LETTER ENG
    public const char eng                    = '\u014B';
    // LATIN SMALL LETTER E WITH OGONEK
    public const char eogonek                = '\u0119';
    // GREEK SMALL LETTER EPSILON
    public const char epsilon                = '\u03B5';
    // GREEK SMALL LETTER EPSILON WITH TONOS
    public const char epsilontonos           = '\u03AD';
    // EQUALS SIGN
    public const char equal                  = '\u003D';
    // IDENTICAL TO
    public const char equivalence            = '\u2261';
    // ESTIMATED SYMBOL
    public const char estimated              = '\u212E';
    // GREEK SMALL LETTER ETA
    public const char eta                    = '\u03B7';
    // GREEK SMALL LETTER ETA WITH TONOS
    public const char etatonos               = '\u03AE';
    // LATIN SMALL LETTER ETH
    public const char eth                    = '\u00F0';
    // EXCLAMATION MARK
    public const char exclam                 = '\u0021';
    // DOUBLE EXCLAMATION MARK
    public const char exclamdbl              = '\u203C';
    // INVERTED EXCLAMATION MARK
    public const char exclamdown             = '\u00A1';
    // THERE EXISTS
    public const char existential            = '\u2203';
    // LATIN SMALL LETTER F
    public const char f                      = '\u0066';
    // FEMALE SIGN
    public const char female                 = '\u2640';
    // FIGURE DASH
    public const char figuredash             = '\u2012';
    // BLACK SQUARE
    public const char filledbox              = '\u25A0';
    // BLACK RECTANGLE
    public const char filledrect             = '\u25AC';
    // DIGIT FIVE
    public const char five                   = '\u0035';
    // VULGAR FRACTION FIVE EIGHTHS
    public const char fiveeighths            = '\u215D';
    // LATIN SMALL LETTER F WITH HOOK
    public const char florin                 = '\u0192';
    // DIGIT FOUR
    public const char four                   = '\u0034';
    // FRACTION SLASH
    public const char fraction               = '\u2044';
    // FRENCH FRANC SIGN
    public const char franc                  = '\u20A3';
    // LATIN SMALL LETTER G
    public const char g                      = '\u0067';
    // GREEK SMALL LETTER GAMMA
    public const char gamma                  = '\u03B3';
    // LATIN SMALL LETTER G WITH BREVE
    public const char gbreve                 = '\u011F';
    // LATIN SMALL LETTER G WITH CARON
    public const char gcaron                 = '\u01E7';
    // LATIN SMALL LETTER G WITH CIRCUMFLEX
    public const char gcircumflex            = '\u011D';
    // LATIN SMALL LETTER G WITH CEDILLA
    public const char gcommaaccent           = '\u0123';
    // LATIN SMALL LETTER G WITH DOT ABOVE
    public const char gdotaccent             = '\u0121';
    // LATIN SMALL LETTER SHARP S
    public const char germandbls             = '\u00DF';
    // NABLA
    public const char gradient               = '\u2207';
    // GRAVE ACCENT
    public const char grave                  = '\u0060';
    // COMBINING GRAVE ACCENT
    public const char gravecomb              = '\u0300';
    // GREATER-THAN SIGN
    public const char greater                = '\u003E';
    // GREATER-THAN OR EQUAL TO
    public const char greaterequal           = '\u2265';
    // LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    public const char guillemotleft          = '\u00AB';
    // RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    public const char guillemotright         = '\u00BB';
    // SINGLE LEFT-POINTING ANGLE QUOTATION MARK
    public const char guilsinglleft          = '\u2039';
    // SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
    public const char guilsinglright         = '\u203A';
    // LATIN SMALL LETTER H
    public const char h                      = '\u0068';
    // LATIN SMALL LETTER H WITH STROKE
    public const char hbar                   = '\u0127';
    // LATIN SMALL LETTER H WITH CIRCUMFLEX
    public const char hcircumflex            = '\u0125';
    // BLACK HEART SUIT
    public const char heart                  = '\u2665';
    // COMBINING HOOK ABOVE
    public const char hookabovecomb          = '\u0309';
    // HOUSE
    public const char house                  = '\u2302';
    // DOUBLE ACUTE ACCENT
    public const char hungarumlaut           = '\u02DD';
    // HYPHEN-MINUS
    public const char hyphen                 = '\u002D';
    // LATIN SMALL LETTER I
    public const char i                      = '\u0069';
    // LATIN SMALL LETTER I WITH ACUTE
    public const char iacute                 = '\u00ED';
    // LATIN SMALL LETTER I WITH BREVE
    public const char ibreve                 = '\u012D';
    // LATIN SMALL LETTER I WITH CIRCUMFLEX
    public const char icircumflex            = '\u00EE';
    // LATIN SMALL LETTER I WITH DIAERESIS
    public const char idieresis              = '\u00EF';
    // LATIN SMALL LETTER I WITH GRAVE
    public const char igrave                 = '\u00EC';
    // LATIN SMALL LIGATURE IJ
    public const char ij                     = '\u0133';
    // LATIN SMALL LETTER I WITH MACRON
    public const char imacron                = '\u012B';
    // INFINITY
    public const char infinity               = '\u221E';
    // INTEGRAL
    public const char integral               = '\u222B';
    // BOTTOM HALF INTEGRAL
    public const char integralbt             = '\u2321';
    // TOP HALF INTEGRAL
    public const char integraltp             = '\u2320';
    // INTERSECTION
    public const char intersection           = '\u2229';
    // INVERSE BULLET
    public const char invbullet              = '\u25D8';
    // INVERSE WHITE CIRCLE
    public const char invcircle              = '\u25D9';
    // BLACK SMILING FACE
    public const char invsmileface           = '\u263B';
    // LATIN SMALL LETTER I WITH OGONEK
    public const char iogonek                = '\u012F';
    // GREEK SMALL LETTER IOTA
    public const char iota                   = '\u03B9';
    // GREEK SMALL LETTER IOTA WITH DIALYTIKA
    public const char iotadieresis           = '\u03CA';
    // GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
    public const char iotadieresistonos      = '\u0390';
    // GREEK SMALL LETTER IOTA WITH TONOS
    public const char iotatonos              = '\u03AF';
    // LATIN SMALL LETTER I WITH TILDE
    public const char itilde                 = '\u0129';
    // LATIN SMALL LETTER J
    public const char j                      = '\u006A';
    // LATIN SMALL LETTER J WITH CIRCUMFLEX
    public const char jcircumflex            = '\u0135';
    // LATIN SMALL LETTER K
    public const char k                      = '\u006B';
    // GREEK SMALL LETTER KAPPA
    public const char kappa                  = '\u03BA';
    // LATIN SMALL LETTER K WITH CEDILLA
    public const char kcommaaccent           = '\u0137';
    // LATIN SMALL LETTER KRA
    public const char kgreenlandic           = '\u0138';
    // LATIN SMALL LETTER L
    public const char l                      = '\u006C';
    // LATIN SMALL LETTER L WITH ACUTE
    public const char lacute                 = '\u013A';
    // GREEK SMALL LETTER LAMDA
    public const char lambda                 = '\u03BB';
    // LATIN SMALL LETTER L WITH CARON
    public const char lcaron                 = '\u013E';
    // LATIN SMALL LETTER L WITH CEDILLA
    public const char lcommaaccent           = '\u013C';
    // LATIN SMALL LETTER L WITH MIDDLE DOT
    public const char ldot                   = '\u0140';
    // LESS-THAN SIGN
    public const char less                   = '\u003C';
    // LESS-THAN OR EQUAL TO
    public const char lessequal              = '\u2264';
    // LEFT HALF BLOCK
    public const char lfblock                = '\u258C';
    // LIRA SIGN
    public const char lira                   = '\u20A4';
    // LOGICAL AND
    public const char logicaland             = '\u2227';
    // NOT SIGN
    public const char logicalnot             = '\u00AC';
    // LOGICAL OR
    public const char logicalor              = '\u2228';
    // LATIN SMALL LETTER LONG S
    public const char longs                  = '\u017F';
    // LOZENGE
    public const char lozenge                = '\u25CA';
    // LATIN SMALL LETTER L WITH STROKE
    public const char lslash                 = '\u0142';
    // LIGHT SHADE
    public const char ltshade                = '\u2591';
    // LATIN SMALL LETTER M
    public const char m                      = '\u006D';
    // MACRON
    public const char macron                 = '\u00AF';
    // MALE SIGN
    public const char male                   = '\u2642';
    // MINUS SIGN
    public const char minus                  = '\u2212';
    // PRIME
    public const char minute                 = '\u2032';
    // MICRO SIGN
    public const char mu                     = '\u00B5';
    // MULTIPLICATION SIGN
    public const char multiply               = '\u00D7';
    // EIGHTH NOTE
    public const char musicalnote            = '\u266A';
    // BEAMED EIGHTH NOTES
    public const char musicalnotedbl         = '\u266B';
    // LATIN SMALL LETTER N
    public const char n                      = '\u006E';
    // LATIN SMALL LETTER N WITH ACUTE
    public const char nacute                 = '\u0144';
    // LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
    public const char napostrophe            = '\u0149';
    // LATIN SMALL LETTER N WITH CARON
    public const char ncaron                 = '\u0148';
    // LATIN SMALL LETTER N WITH CEDILLA
    public const char ncommaaccent           = '\u0146';
    // DIGIT NINE
    public const char nine                   = '\u0039';
    // NOT AN ELEMENT OF
    public const char notelement             = '\u2209';
    // NOT EQUAL TO
    public const char notequal               = '\u2260';
    // NOT A SUBSET OF
    public const char notsubset              = '\u2284';
    // LATIN SMALL LETTER N WITH TILDE
    public const char ntilde                 = '\u00F1';
    // GREEK SMALL LETTER NU
    public const char nu                     = '\u03BD';
    // NUMBER SIGN
    public const char numbersign             = '\u0023';
    // LATIN SMALL LETTER O
    public const char o                      = '\u006F';
    // LATIN SMALL LETTER O WITH ACUTE
    public const char oacute                 = '\u00F3';
    // LATIN SMALL LETTER O WITH BREVE
    public const char obreve                 = '\u014F';
    // LATIN SMALL LETTER O WITH CIRCUMFLEX
    public const char ocircumflex            = '\u00F4';
    // LATIN SMALL LETTER O WITH DIAERESIS
    public const char odieresis              = '\u00F6';
    // LATIN SMALL LIGATURE OE
    public const char oe                     = '\u0153';
    // OGONEK
    public const char ogonek                 = '\u02DB';
    // LATIN SMALL LETTER O WITH GRAVE
    public const char ograve                 = '\u00F2';
    // LATIN SMALL LETTER O WITH HORN
    public const char ohorn                  = '\u01A1';
    // LATIN SMALL LETTER O WITH DOUBLE ACUTE
    public const char ohungarumlaut          = '\u0151';
    // LATIN SMALL LETTER O WITH MACRON
    public const char omacron                = '\u014D';
    // GREEK SMALL LETTER OMEGA
    public const char omega                  = '\u03C9';
    // GREEK PI SYMBOL
    public const char omega1                 = '\u03D6';
    // GREEK SMALL LETTER OMEGA WITH TONOS
    public const char omegatonos             = '\u03CE';
    // GREEK SMALL LETTER OMICRON
    public const char omicron                = '\u03BF';
    // GREEK SMALL LETTER OMICRON WITH TONOS
    public const char omicrontonos           = '\u03CC';
    // DIGIT ONE
    public const char one                    = '\u0031';
    // ONE DOT LEADER
    public const char onedotenleader         = '\u2024';
    // VULGAR FRACTION ONE EIGHTH
    public const char oneeighth              = '\u215B';
    // VULGAR FRACTION ONE HALF
    public const char onehalf                = '\u00BD';
    // VULGAR FRACTION ONE QUARTER
    public const char onequarter             = '\u00BC';
    // VULGAR FRACTION ONE THIRD
    public const char onethird               = '\u2153';
    // WHITE BULLET
    public const char openbullet             = '\u25E6';
    // FEMININE ORDINAL INDICATOR
    public const char ordfeminine            = '\u00AA';
    // MASCULINE ORDINAL INDICATOR
    public const char ordmasculine           = '\u00BA';
    // RIGHT ANGLE
    public const char orthogonal             = '\u221F';
    // LATIN SMALL LETTER O WITH STROKE
    public const char oslash                 = '\u00F8';
    // LATIN SMALL LETTER O WITH STROKE AND ACUTE
    public const char oslashacute            = '\u01FF';
    // LATIN SMALL LETTER O WITH TILDE
    public const char otilde                 = '\u00F5';
    // LATIN SMALL LETTER P
    public const char p                      = '\u0070';
    // PILCROW SIGN
    public const char paragraph              = '\u00B6';
    // LEFT PARENTHESIS
    public const char parenleft              = '\u0028';
    // RIGHT PARENTHESIS
    public const char parenright             = '\u0029';
    // PARTIAL DIFFERENTIAL
    public const char partialdiff            = '\u2202';
    // PERCENT SIGN
    public const char percent                = '\u0025';
    // FULL STOP
    public const char period                 = '\u002E';
    // MIDDLE DOT
    public const char periodcentered         = '\u00B7';
    // UP TACK
    public const char perpendicular          = '\u22A5';
    // PER MILLE SIGN
    public const char perthousand            = '\u2030';
    // PESETA SIGN
    public const char peseta                 = '\u20A7';
    // GREEK SMALL LETTER PHI
    public const char phi                    = '\u03C6';
    // GREEK PHI SYMBOL
    public const char phi1                   = '\u03D5';
    // GREEK SMALL LETTER PI
    public const char pi                     = '\u03C0';
    // PLUS SIGN
    public const char plus                   = '\u002B';
    // PLUS-MINUS SIGN
    public const char plusminus              = '\u00B1';
    // PRESCRIPTION TAKE
    public const char prescription           = '\u211E';
    // N-ARY PRODUCT
    public const char product                = '\u220F';
    // SUBSET OF
    public const char propersubset           = '\u2282';
    // SUPERSET OF
    public const char propersuperset         = '\u2283';
    // PROPORTIONAL TO
    public const char proportional           = '\u221D';
    // GREEK SMALL LETTER PSI
    public const char psi                    = '\u03C8';
    // LATIN SMALL LETTER Q
    public const char q                      = '\u0071';
    // QUESTION MARK
    public const char question               = '\u003F';
    // INVERTED QUESTION MARK
    public const char questiondown           = '\u00BF';
    // QUOTATION MARK
    public const char quotedbl               = '\u0022';
    // DOUBLE LOW-9 QUOTATION MARK
    public const char quotedblbase           = '\u201E';
    // LEFT DOUBLE QUOTATION MARK
    public const char quotedblleft           = '\u201C';
    // RIGHT DOUBLE QUOTATION MARK
    public const char quotedblright          = '\u201D';
    // LEFT SINGLE QUOTATION MARK
    public const char quoteleft              = '\u2018';
    // SINGLE HIGH-REVERSED-9 QUOTATION MARK
    public const char quotereversed          = '\u201B';
    // RIGHT SINGLE QUOTATION MARK
    public const char quoteright             = '\u2019';
    // SINGLE LOW-9 QUOTATION MARK
    public const char quotesinglbase         = '\u201A';
    // APOSTROPHE
    public const char quotesingle            = '\u0027';
    // LATIN SMALL LETTER R
    public const char r                      = '\u0072';
    // LATIN SMALL LETTER R WITH ACUTE
    public const char racute                 = '\u0155';
    // SQUARE ROOT
    public const char radical                = '\u221A';
    // LATIN SMALL LETTER R WITH CARON
    public const char rcaron                 = '\u0159';
    // LATIN SMALL LETTER R WITH CEDILLA
    public const char rcommaaccent           = '\u0157';
    // SUBSET OF OR EQUAL TO
    public const char reflexsubset           = '\u2286';
    // SUPERSET OF OR EQUAL TO
    public const char reflexsuperset         = '\u2287';
    // REGISTERED SIGN
    public const char registered             = '\u00AE';
    // REVERSED NOT SIGN
    public const char revlogicalnot          = '\u2310';
    // GREEK SMALL LETTER RHO
    public const char rho                    = '\u03C1';
    // RING ABOVE
    public const char ring                   = '\u02DA';
    // RIGHT HALF BLOCK
    public const char rtblock                = '\u2590';
    // LATIN SMALL LETTER S
    public const char s                      = '\u0073';
    // LATIN SMALL LETTER S WITH ACUTE
    public const char sacute                 = '\u015B';
    // LATIN SMALL LETTER S WITH CARON
    public const char scaron                 = '\u0161';
    // LATIN SMALL LETTER S WITH CEDILLA
    public const char scedilla               = '\u015F';
    // LATIN SMALL LETTER S WITH CIRCUMFLEX
    public const char scircumflex            = '\u015D';
    // LATIN SMALL LETTER S WITH COMMA BELOW
    public const char scommaaccent           = '\u0219';
    // DOUBLE PRIME
    public const char second                 = '\u2033';
    // SECTION SIGN
    public const char section                = '\u00A7';
    // SEMICOLON
    public const char semicolon              = '\u003B';
    // DIGIT SEVEN
    public const char seven                  = '\u0037';
    // VULGAR FRACTION SEVEN EIGHTHS
    public const char seveneighths           = '\u215E';
    // MEDIUM SHADE
    public const char shade                  = '\u2592';
    // GREEK SMALL LETTER SIGMA
    public const char sigma                  = '\u03C3';
    // GREEK SMALL LETTER FINAL SIGMA
    public const char sigma1                 = '\u03C2';
    // TILDE OPERATOR
    public const char similar                = '\u223C';
    // DIGIT SIX
    public const char six                    = '\u0036';
    // SOLIDUS
    public const char slash                  = '\u002F';
    // WHITE SMILING FACE
    public const char smileface              = '\u263A';
    // SPACE
    public const char space                  = '\u0020';
    // BLACK SPADE SUIT
    public const char spade                  = '\u2660';
    // POUND SIGN
    public const char sterling               = '\u00A3';
    // CONTAINS AS MEMBER
    public const char suchthat               = '\u220B';
    // N-ARY SUMMATION
    public const char summation              = '\u2211';
    // WHITE SUN WITH RAYS
    public const char sun                    = '\u263C';
    // LATIN SMALL LETTER T
    public const char t                      = '\u0074';
    // GREEK SMALL LETTER TAU
    public const char tau                    = '\u03C4';
    // LATIN SMALL LETTER T WITH STROKE
    public const char tbar                   = '\u0167';
    // LATIN SMALL LETTER T WITH CARON
    public const char tcaron                 = '\u0165';
    // LATIN SMALL LETTER T WITH CEDILLA
    public const char tcommaaccent           = '\u0163';
    // THEREFORE
    public const char therefore              = '\u2234';
    // GREEK SMALL LETTER THETA
    public const char theta                  = '\u03B8';
    // GREEK THETA SYMBOL
    public const char theta1                 = '\u03D1';
    // LATIN SMALL LETTER THORN
    public const char thorn                  = '\u00FE';
    // DIGIT THREE
    public const char three                  = '\u0033';
    // VULGAR FRACTION THREE EIGHTHS
    public const char threeeighths           = '\u215C';
    // VULGAR FRACTION THREE QUARTERS
    public const char threequarters          = '\u00BE';
    // SMALL TILDE
    public const char tilde                  = '\u02DC';
    // COMBINING TILDE
    public const char tildecomb              = '\u0303';
    // GREEK TONOS
    public const char tonos                  = '\u0384';
    // TRADE MARK SIGN
    public const char trademark              = '\u2122';
    // BLACK DOWN-POINTING TRIANGLE
    public const char triagdn                = '\u25BC';
    // BLACK LEFT-POINTING POINTER
    public const char triaglf                = '\u25C4';
    // BLACK RIGHT-POINTING POINTER
    public const char triagrt                = '\u25BA';
    // BLACK UP-POINTING TRIANGLE
    public const char triagup                = '\u25B2';
    // DIGIT TWO
    public const char two                    = '\u0032';
    // TWO DOT LEADER
    public const char twodotenleader         = '\u2025';
    // VULGAR FRACTION TWO THIRDS
    public const char twothirds              = '\u2154';
    // LATIN SMALL LETTER U
    public const char u                      = '\u0075';
    // LATIN SMALL LETTER U WITH ACUTE
    public const char uacute                 = '\u00FA';
    // LATIN SMALL LETTER U WITH BREVE
    public const char ubreve                 = '\u016D';
    // LATIN SMALL LETTER U WITH CIRCUMFLEX
    public const char ucircumflex            = '\u00FB';
    // LATIN SMALL LETTER U WITH DIAERESIS
    public const char udieresis              = '\u00FC';
    // LATIN SMALL LETTER U WITH GRAVE
    public const char ugrave                 = '\u00F9';
    // LATIN SMALL LETTER U WITH HORN
    public const char uhorn                  = '\u01B0';
    // LATIN SMALL LETTER U WITH DOUBLE ACUTE
    public const char uhungarumlaut          = '\u0171';
    // LATIN SMALL LETTER U WITH MACRON
    public const char umacron                = '\u016B';
    // LOW LINE
    public const char underscore             = '\u005F';
    // DOUBLE LOW LINE
    public const char underscoredbl          = '\u2017';
    // UNION
    public const char union                  = '\u222A';
    // FOR ALL
    public const char universal              = '\u2200';
    // LATIN SMALL LETTER U WITH OGONEK
    public const char uogonek                = '\u0173';
    // UPPER HALF BLOCK
    public const char upblock                = '\u2580';
    // GREEK SMALL LETTER UPSILON
    public const char upsilon                = '\u03C5';
    // GREEK SMALL LETTER UPSILON WITH DIALYTIKA
    public const char upsilondieresis        = '\u03CB';
    // GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
    public const char upsilondieresistonos   = '\u03B0';
    // GREEK SMALL LETTER UPSILON WITH TONOS
    public const char upsilontonos           = '\u03CD';
    // LATIN SMALL LETTER U WITH RING ABOVE
    public const char uring                  = '\u016F';
    // LATIN SMALL LETTER U WITH TILDE
    public const char utilde                 = '\u0169';
    // LATIN SMALL LETTER V
    public const char v                      = '\u0076';
    // LATIN SMALL LETTER W
    public const char w                      = '\u0077';
    // LATIN SMALL LETTER W WITH ACUTE
    public const char wacute                 = '\u1E83';
    // LATIN SMALL LETTER W WITH CIRCUMFLEX
    public const char wcircumflex            = '\u0175';
    // LATIN SMALL LETTER W WITH DIAERESIS
    public const char wdieresis              = '\u1E85';
    // SCRIPT CAPITAL P
    public const char weierstrass            = '\u2118';
    // LATIN SMALL LETTER W WITH GRAVE
    public const char wgrave                 = '\u1E81';
    // LATIN SMALL LETTER X
    public const char x                      = '\u0078';
    // GREEK SMALL LETTER XI
    public const char xi                     = '\u03BE';
    // LATIN SMALL LETTER Y
    public const char y                      = '\u0079';
    // LATIN SMALL LETTER Y WITH ACUTE
    public const char yacute                 = '\u00FD';
    // LATIN SMALL LETTER Y WITH CIRCUMFLEX
    public const char ycircumflex            = '\u0177';
    // LATIN SMALL LETTER Y WITH DIAERESIS
    public const char ydieresis              = '\u00FF';
    // YEN SIGN
    public const char yen                    = '\u00A5';
    // LATIN SMALL LETTER Y WITH GRAVE
    public const char ygrave                 = '\u1EF3';
    // LATIN SMALL LETTER Z
    public const char z                      = '\u007A';
    // LATIN SMALL LETTER Z WITH ACUTE
    public const char zacute                 = '\u017A';
    // LATIN SMALL LETTER Z WITH CARON
    public const char zcaron                 = '\u017E';
    // LATIN SMALL LETTER Z WITH DOT ABOVE
    public const char zdotaccent             = '\u017C';
    // DIGIT ZERO
    public const char zero                   = '\u0030';
    // GREEK SMALL LETTER ZETA
    public const char zeta                   = '\u03B6';
  }
}
