namespace PdfSharp.Drawing
{
  /// <summary>
  /// Specifies the unit of measure.
  /// </summary>
  public enum XGraphicsUnit  // NOT the same values as System.Drawing.GraphicsUnit
  {
    //World = 0,
    //Display = 1,
    //Pixel = 2,

    /// <summary>
    /// Specifies a printer's point (1/72 inch) as the unit of measure.
    /// </summary>
    Point = 0,  // must be 0 to let a new XUnit be 0 point

    /// <summary>
    /// Specifies the inch (2.54 cm) as the unit of measure.
    /// </summary>
    Inch = 1,

    //Document = 5,

    /// <summary>
    /// Specifies the millimeter as the unit of measure.
    /// </summary>
    Millimeter = 2,

    /// <summary>
    /// Specifies the centimeter as the unit of measure.
    /// </summary>
    Centimeter = 3,

    // 
    //  /// <summary>
    //  /// Measure is in picas. A pica represents 12 points.
    //  /// </summary>
    //  Pica,
    //
    //  /// <summary>
    //  /// Measure is in lines. A line represents 12 points. 
    //  /// </summary>
    //  Line,
  }
}
