//
// PDFSharp - A library for processing PDF
//
// Authors:
//   Stefan Lange (mailto:Stefan.Lange@pdfsharp.com)
//
// Copyright (c) 2005 empira Software GmbH, Cologne (Germany)
//
// http://www.pdfsharp.com
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

using System;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.IO;
using PdfSharp.Internal;

namespace PdfSharp.Drawing
{
  ////[Flags]
  ////public enum XStringFormatFlags
  ////{
  ////  DirectionRightToLeft  = 0x0001,
  ////  DirectionVertical     = 0x0002,
  ////  FitBlackBox           = 0x0004,
  ////  DisplayFormatControl  = 0x0020,
  ////  NoFontFallback        = 0x0400,
  ////  MeasureTrailingSpaces = 0x0800,
  ////  NoWrap                = 0x1000,
  ////  LineLimit             = 0x2000,
  ////  NoClip                = 0x4000,
  ////}

  ////public enum StringTrimming
  ////{
  ////  None              = 0,
  ////  Character         = 1,
  ////  Word              = 2,
  ////  EllipsisCharacter = 3,
  ////  EllipsisWord      = 4,
  ////  EllipsisPath      = 5,
  ////}

  /// <summary>
  /// Encapsulates text layout information.
  /// </summary>
  public class XStringFormat
  {
    public XStringFormat()
    {
      // We must clone GenericTypographic, otherwise we change the original!
      this.stringFormat = (StringFormat)StringFormat.GenericTypographic.Clone();
    }

    //TODO public StringFormat(StringFormat format);
    //public StringFormat(StringFormatFlags options);
    //public StringFormat(StringFormatFlags options, int language);
    //public object Clone();
    //public void Dispose();
    //private void Dispose(bool disposing);
    //protected override void Finalize();
    //public float[] GetTabStops(out float firstTabOffset);
    //public void SetDigitSubstitution(int language, StringDigitSubstitute substitute);
    //public void SetMeasurableCharacterRanges(CharacterRange[] ranges);
    //public void SetTabStops(float firstTabOffset, float[] tabStops);
    //public override string ToString();

    /// <summary>
    /// Gets or sets horizontal text alignment information.
    /// </summary>
    public XStringAlignment Alignment
    { 
      get {return this.alignment;}
      set
      {
        this.alignment = value;
        this.stringFormat.Alignment = (StringAlignment)value;
      }
    }
    XStringAlignment alignment;

    //public int DigitSubstitutionLanguage { get; }
    //public StringDigitSubstitute DigitSubstitutionMethod { get; }
    //public StringFormatFlags FormatFlags { get; set; }
    //public static StringFormat GenericDefault { get; }
    //public static StringFormat GenericTypographic { get; }
    //public HotkeyPrefix HotkeyPrefix { get; set; }

    /// <summary>
    /// Gets or sets the line alignment.
    /// </summary>
    public XLineAlignment LineAlignment
    { 
      get {return this.lineAlignment;}
      set
      {
        this.lineAlignment = value;
        if (value == XLineAlignment.BaseLine)
          this.stringFormat.LineAlignment = StringAlignment.Near;
        else
          this.stringFormat.LineAlignment = (StringAlignment)value;
      }
    }
    XLineAlignment lineAlignment;

    //public StringTrimming Trimming { get; set; }

    /// <summary>
    /// Gets an XStringFormat object that aligns the text left on the base line.
    /// </summary>
    public static XStringFormat Default
    {
      get
      {
        XStringFormat format = new XStringFormat();
        //format.Alignment = XStringAlignment.Near;
        format.LineAlignment = XLineAlignment.BaseLine;
        return format;
      }
    }

    /// <summary>
    /// Gets an XStringFormat object that centers the text in the middle of the layout rectangle.
    /// </summary>
    public static XStringFormat Center
    {
      get
      {
        XStringFormat format = new XStringFormat();
        format.Alignment = XStringAlignment.Center;
        format.LineAlignment = XLineAlignment.Center;
        return format;
      }
    }

    /// <summary>
    /// Gets an XStringFormat object that centers the text at the top of the layout rectangle.
    /// </summary>
    public static XStringFormat CenterTop
    {
      get
      {
        XStringFormat format = new XStringFormat();
        format.Alignment = XStringAlignment.Center;
        format.LineAlignment = XLineAlignment.Near;
        return format;
      }
    }

    internal StringFormat RealizeGdiStringFormat()
    {
      if (this.stringFormat == null)
      {
        this.stringFormat = StringFormat.GenericTypographic; //.GenericDefault;
        this.stringFormat.Alignment = (StringAlignment)this.alignment;
        this.stringFormat.LineAlignment = (StringAlignment)this.lineAlignment;
        //this.stringFormat.FormatFlags = StringFormatFlags.FitBlackBox;
      }
      return this.stringFormat;
    }
    StringFormat stringFormat;
  }
}
