using System;

namespace PdfSharp.Drawing
{
  /// <summary>
  /// Specifies the format of the image.
  /// </summary>
  public class XImageFormat
  {
    Guid guid;

    XImageFormat(Guid guid)
    {
      this.guid = guid;
    }

    internal Guid Guid
    {
      get { return this.guid; }
    }

    public override bool Equals(object obj)
    {
      XImageFormat format = obj as XImageFormat;
      if (format == null)
        return false;
      return this.guid == format.guid;
    }

    public override int GetHashCode()
    {
      return this.guid.GetHashCode ();
    }

    public static XImageFormat Png
    {
      get { return XImageFormat.png; }
    }

    public static XImageFormat Gif
    {
      get { return XImageFormat.gif; }
    }

    public static XImageFormat Jpeg
    {
      get { return XImageFormat.jpeg; }
    }

    public static XImageFormat Tiff
    {
      get { return XImageFormat.tiff; }
    }

    public static XImageFormat Pdf
    {
      get { return XImageFormat.pdf; }
    }

    public static XImageFormat Icon
    {
      get { return XImageFormat.icon; }
    }

    static XImageFormat()
    {
      //ImageFormat.memoryBMP = new ImageFormat(new Guid("{b96b3caa-0728-11d3-9d7b-0000f81ef32e}"));
      //ImageFormat.bmp = new ImageFormat(new Guid("{b96b3cab-0728-11d3-9d7b-0000f81ef32e}"));
      //ImageFormat.emf = new ImageFormat(new Guid("{b96b3cac-0728-11d3-9d7b-0000f81ef32e}"));
      //ImageFormat.wmf = new ImageFormat(new Guid("{b96b3cad-0728-11d3-9d7b-0000f81ef32e}"));
      //ImageFormat.jpeg = new ImageFormat(new Guid("{b96b3cae-0728-11d3-9d7b-0000f81ef32e}"));
      //ImageFormat.png = new ImageFormat(new Guid("{b96b3caf-0728-11d3-9d7b-0000f81ef32e}"));
      //ImageFormat.gif = new ImageFormat(new Guid("{b96b3cb0-0728-11d3-9d7b-0000f81ef32e}"));
      //ImageFormat.tiff = new ImageFormat(new Guid("{b96b3cb1-0728-11d3-9d7b-0000f81ef32e}"));
      //ImageFormat.exif = new ImageFormat(new Guid("{b96b3cb2-0728-11d3-9d7b-0000f81ef32e}"));
      //ImageFormat.photoCD = new ImageFormat(new Guid("{b96b3cb3-0728-11d3-9d7b-0000f81ef32e}"));
      //ImageFormat.flashPIX = new ImageFormat(new Guid("{b96b3cb4-0728-11d3-9d7b-0000f81ef32e}"));
      //ImageFormat.icon = new ImageFormat(new Guid("{b96b3cb5-0728-11d3-9d7b-0000f81ef32e}"));
    }

    private static XImageFormat png  = new XImageFormat(new Guid("{B96B3CAF-0728-11D3-9D7B-0000F81EF32E}"));
    private static XImageFormat gif  = new XImageFormat(new Guid("{B96B3CB0-0728-11D3-9D7B-0000F81EF32E}"));
    private static XImageFormat jpeg = new XImageFormat(new Guid("{B96B3CAE-0728-11D3-9D7B-0000F81EF32E}"));
    private static XImageFormat tiff = new XImageFormat(new Guid("{B96B3CB1-0728-11D3-9D7B-0000F81EF32E}"));
    private static XImageFormat icon = new XImageFormat(new Guid("{B96B3CB5-0728-11D3-9D7B-0000F81EF32E}"));//!!!newTHHO 15.09.05 why not???
    // not GDI+ conform
    private static XImageFormat pdf  = new XImageFormat(new Guid("{84570158-DBF0-4C6B-8368-62D6A3CA76E0}"));
  }
}
