//
// PDFSharp - A library for processing PDF
//
// Authors:
//   Stefan Lange (mailto:Stefan.Lange@pdfsharp.com)
//
// Copyright (c) 2005 empira Software GmbH, Cologne (Germany)
//
// http://www.pdfsharp.com
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

using System;
using System.Drawing;
using System.Drawing.Drawing2D;

namespace PdfSharp.Drawing
{
  /// <summary>
  /// Converts XGraphics enums to GDI+ enums.
  /// </summary>
  internal class XConvert
  {
    XConvert()
    {
    }

    /// <summary>
    /// Converts XLineJoin to LineJoin.
    /// </summary>
    public static LineJoin ToLineJoin(XLineJoin lineJoin)
    {
      return xlj[(int)lineJoin];
    }
    static LineJoin[] xlj = new LineJoin[3]{LineJoin.Miter, LineJoin.Round, LineJoin.Bevel};

    /// <summary>
    /// Converts XLineCap to LineCap.
    /// </summary>
    public static LineCap ToLineCap(XLineCap lineCap)
    {
      return xlc[(int)lineCap];
    }
    static LineCap[] xlc = new LineCap[3]{LineCap.Flat, LineCap.Round, LineCap.Square};

  }
}
