//
// PDFSharp - A library for processing PDF
//
// Authors:
//   Stefan Lange (mailto:Stefan.Lange@pdfsharp.com)
//
// Copyright (c) 2005 empira Software GmbH, Cologne (Germany)
//
// http://www.pdfsharp.com
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

using System;
using System.Globalization;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using PdfSharp.Internal;

namespace PdfSharp.Drawing
{
  ///<summary>
  /// Represents a set of 141 pre-defined RGB colors. Incidentally the values are the same
  /// as in System.Drawing.Color.
  /// </summary>
  public sealed class XColors
  {
    private XColors()
    {}

    ///<summary>Gets a predefined color.</summary>
    public static XColor AliceBlue {get {return new XColor(XKnownColor.AliceBlue);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor AntiqueWhite {get {return new XColor(XKnownColor.AntiqueWhite);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Aqua {get {return new XColor(XKnownColor.Aqua);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Aquamarine {get {return new XColor(XKnownColor.Aquamarine);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Azure {get {return new XColor(XKnownColor.Azure);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Beige {get {return new XColor(XKnownColor.Beige);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Bisque {get {return new XColor(XKnownColor.Bisque);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Black {get {return new XColor(XKnownColor.Black);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor BlanchedAlmond {get {return new XColor(XKnownColor.BlanchedAlmond);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Blue {get {return new XColor(XKnownColor.Blue);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor BlueViolet {get {return new XColor(XKnownColor.BlueViolet);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Brown {get {return new XColor(XKnownColor.Brown);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor BurlyWood {get {return new XColor(XKnownColor.BurlyWood);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor CadetBlue {get {return new XColor(XKnownColor.CadetBlue);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Chartreuse {get {return new XColor(XKnownColor.Chartreuse);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Chocolate {get {return new XColor(XKnownColor.Chocolate);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Coral {get {return new XColor(XKnownColor.Coral);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor CornflowerBlue {get {return new XColor(XKnownColor.CornflowerBlue);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Cornsilk {get {return new XColor(XKnownColor.Cornsilk);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Crimson {get {return new XColor(XKnownColor.Crimson);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Cyan {get {return new XColor(XKnownColor.Cyan);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkBlue {get {return new XColor(XKnownColor.DarkBlue);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkCyan {get {return new XColor(XKnownColor.DarkCyan);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkGoldenrod {get {return new XColor(XKnownColor.DarkGoldenrod);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkGray {get {return new XColor(XKnownColor.DarkGray);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkGreen {get {return new XColor(XKnownColor.DarkGreen);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkKhaki {get {return new XColor(XKnownColor.DarkKhaki);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkMagenta {get {return new XColor(XKnownColor.DarkMagenta);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkOliveGreen {get {return new XColor(XKnownColor.DarkOliveGreen);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkOrange {get {return new XColor(XKnownColor.DarkOrange);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkOrchid {get {return new XColor(XKnownColor.DarkOrchid);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkRed {get {return new XColor(XKnownColor.DarkRed);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkSalmon {get {return new XColor(XKnownColor.DarkSalmon);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkSeaGreen {get {return new XColor(XKnownColor.DarkSeaGreen);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkSlateBlue {get {return new XColor(XKnownColor.DarkSlateBlue);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkSlateGray {get {return new XColor(XKnownColor.DarkSlateGray);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkTurquoise {get {return new XColor(XKnownColor.DarkTurquoise);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor DarkViolet {get {return new XColor(XKnownColor.DarkViolet);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor DeepPink {get {return new XColor(XKnownColor.DeepPink);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor DeepSkyBlue {get {return new XColor(XKnownColor.DeepSkyBlue);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor DimGray {get {return new XColor(XKnownColor.DimGray);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor DodgerBlue {get {return new XColor(XKnownColor.DodgerBlue);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Firebrick {get {return new XColor(XKnownColor.Firebrick);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor FloralWhite {get {return new XColor(XKnownColor.FloralWhite);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor ForestGreen {get {return new XColor(XKnownColor.ForestGreen);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Fuchsia {get {return new XColor(XKnownColor.Fuchsia);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Gainsboro {get {return new XColor(XKnownColor.Gainsboro);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor GhostWhite {get {return new XColor(XKnownColor.GhostWhite);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Gold {get {return new XColor(XKnownColor.Gold);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Goldenrod {get {return new XColor(XKnownColor.Goldenrod);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Gray {get {return new XColor(XKnownColor.Gray);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Green {get {return new XColor(XKnownColor.Green);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor GreenYellow {get {return new XColor(XKnownColor.GreenYellow);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Honeydew {get {return new XColor(XKnownColor.Honeydew);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor HotPink {get {return new XColor(XKnownColor.HotPink);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor IndianRed {get {return new XColor(XKnownColor.IndianRed);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Indigo {get {return new XColor(XKnownColor.Indigo);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Ivory {get {return new XColor(XKnownColor.Ivory);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Khaki {get {return new XColor(XKnownColor.Khaki);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Lavender {get {return new XColor(XKnownColor.Lavender);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor LavenderBlush {get {return new XColor(XKnownColor.LavenderBlush);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor LawnGreen {get {return new XColor(XKnownColor.LawnGreen);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor LemonChiffon {get {return new XColor(XKnownColor.LemonChiffon);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightBlue {get {return new XColor(XKnownColor.LightBlue);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightCoral {get {return new XColor(XKnownColor.LightCoral);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightCyan {get {return new XColor(XKnownColor.LightCyan);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightGoldenrodYellow {get {return new XColor(XKnownColor.LightGoldenrodYellow);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightGray {get {return new XColor(XKnownColor.LightGray);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightGreen {get {return new XColor(XKnownColor.LightGreen);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightPink {get {return new XColor(XKnownColor.LightPink);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightSalmon {get {return new XColor(XKnownColor.LightSalmon);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightSeaGreen {get {return new XColor(XKnownColor.LightSeaGreen);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightSkyBlue {get {return new XColor(XKnownColor.LightSkyBlue);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightSlateGray {get {return new XColor(XKnownColor.LightSlateGray);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightSteelBlue {get {return new XColor(XKnownColor.LightSteelBlue);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor LightYellow {get {return new XColor(XKnownColor.LightYellow);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Lime {get {return new XColor(XKnownColor.Lime);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor LimeGreen {get {return new XColor(XKnownColor.LimeGreen);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Linen {get {return new XColor(XKnownColor.Linen);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Magenta {get {return new XColor(XKnownColor.Magenta);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Maroon {get {return new XColor(XKnownColor.Maroon);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor MediumAquamarine {get {return new XColor(XKnownColor.MediumAquamarine);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor MediumBlue {get {return new XColor(XKnownColor.MediumBlue);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor MediumOrchid {get {return new XColor(XKnownColor.MediumOrchid);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor MediumPurple {get {return new XColor(XKnownColor.MediumPurple);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor MediumSeaGreen {get {return new XColor(XKnownColor.MediumSeaGreen);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor MediumSlateBlue {get {return new XColor(XKnownColor.MediumSlateBlue);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor MediumSpringGreen {get {return new XColor(XKnownColor.MediumSpringGreen);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor MediumTurquoise {get {return new XColor(XKnownColor.MediumTurquoise);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor MediumVioletRed {get {return new XColor(XKnownColor.MediumVioletRed);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor MidnightBlue {get {return new XColor(XKnownColor.MidnightBlue);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor MintCream {get {return new XColor(XKnownColor.MintCream);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor MistyRose {get {return new XColor(XKnownColor.MistyRose);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Moccasin {get {return new XColor(XKnownColor.Moccasin);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor NavajoWhite {get {return new XColor(XKnownColor.NavajoWhite);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Navy {get {return new XColor(XKnownColor.Navy);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor OldLace {get {return new XColor(XKnownColor.OldLace);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Olive {get {return new XColor(XKnownColor.Olive);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor OliveDrab {get {return new XColor(XKnownColor.OliveDrab);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Orange {get {return new XColor(XKnownColor.Orange);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor OrangeRed {get {return new XColor(XKnownColor.OrangeRed);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Orchid {get {return new XColor(XKnownColor.Orchid);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor PaleGoldenrod {get {return new XColor(XKnownColor.PaleGoldenrod);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor PaleGreen {get {return new XColor(XKnownColor.PaleGreen);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor PaleTurquoise {get {return new XColor(XKnownColor.PaleTurquoise);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor PaleVioletRed {get {return new XColor(XKnownColor.PaleVioletRed);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor PapayaWhip {get {return new XColor(XKnownColor.PapayaWhip);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor PeachPuff {get {return new XColor(XKnownColor.PeachPuff);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Peru {get {return new XColor(XKnownColor.Peru);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Pink {get {return new XColor(XKnownColor.Pink);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Plum {get {return new XColor(XKnownColor.Plum);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor PowderBlue {get {return new XColor(XKnownColor.PowderBlue);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Purple {get {return new XColor(XKnownColor.Purple);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Red {get {return new XColor(XKnownColor.Red);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor RosyBrown {get {return new XColor(XKnownColor.RosyBrown);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor RoyalBlue {get {return new XColor(XKnownColor.RoyalBlue);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor SaddleBrown {get {return new XColor(XKnownColor.SaddleBrown);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Salmon {get {return new XColor(XKnownColor.Salmon);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor SandyBrown {get {return new XColor(XKnownColor.SandyBrown);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor SeaGreen {get {return new XColor(XKnownColor.SeaGreen);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor SeaShell {get {return new XColor(XKnownColor.SeaShell);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Sienna {get {return new XColor(XKnownColor.Sienna);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Silver {get {return new XColor(XKnownColor.Silver);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor SkyBlue {get {return new XColor(XKnownColor.SkyBlue);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor SlateBlue {get {return new XColor(XKnownColor.SlateBlue);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor SlateGray {get {return new XColor(XKnownColor.SlateGray);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Snow {get {return new XColor(XKnownColor.Snow);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor SpringGreen {get {return new XColor(XKnownColor.SpringGreen);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor SteelBlue {get {return new XColor(XKnownColor.SteelBlue);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Tan {get {return new XColor(XKnownColor.Tan);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Teal {get {return new XColor(XKnownColor.Teal);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Thistle {get {return new XColor(XKnownColor.Thistle);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Tomato {get {return new XColor(XKnownColor.Tomato);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Transparent {get {return new XColor(XKnownColor.Transparent);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Turquoise {get {return new XColor(XKnownColor.Turquoise);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Violet {get {return new XColor(XKnownColor.Violet);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Wheat {get {return new XColor(XKnownColor.Wheat);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor White {get {return new XColor(XKnownColor.White);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor WhiteSmoke {get {return new XColor(XKnownColor.WhiteSmoke);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor Yellow {get {return new XColor(XKnownColor.Yellow);}}
    ///<summary>Gets a predefined color.</summary>
    public static XColor YellowGreen {get {return new XColor(XKnownColor.YellowGreen);}}
  }

  internal class XKnownColorTable
  {
    private static uint[] colorTable;

    public static uint KnownColorToArgb(XKnownColor color)
    {
      if (XKnownColorTable.colorTable == null)
        InitColorTable();
      if (color <= XKnownColor.YellowGreen)
        return XKnownColorTable.colorTable[(int)color];
      return 0;
    }

    private static void InitColorTable()
    {
      // Same values as in GDI+ and System.Windows.Media.Colors
      uint[] colors = new uint[141];
      colors[  0] = 0xFFF0F8FF;  // AliceBlue
      colors[  1] = 0xFFFAEBD7;  // AntiqueWhite
      colors[  2] = 0xFF00FFFF;  // Aqua
      colors[  3] = 0xFF7FFFD4;  // Aquamarine
      colors[  4] = 0xFFF0FFFF;  // Azure
      colors[  5] = 0xFFF5F5DC;  // Beige
      colors[  6] = 0xFFFFE4C4;  // Bisque
      colors[  7] = 0xFF000000;  // Black
      colors[  8] = 0xFFFFEBCD;  // BlanchedAlmond
      colors[  9] = 0xFF0000FF;  // Blue
      colors[ 10] = 0xFF8A2BE2;  // BlueViolet
      colors[ 11] = 0xFFA52A2A;  // Brown
      colors[ 12] = 0xFFDEB887;  // BurlyWood
      colors[ 13] = 0xFF5F9EA0;  // CadetBlue
      colors[ 14] = 0xFF7FFF00;  // Chartreuse
      colors[ 15] = 0xFFD2691E;  // Chocolate
      colors[ 16] = 0xFFFF7F50;  // Coral
      colors[ 17] = 0xFF6495ED;  // CornflowerBlue
      colors[ 18] = 0xFFFFF8DC;  // Cornsilk
      colors[ 29] = 0xFFDC143C;  // Crimson
      colors[ 20] = 0xFF00FFFF;  // Cyan
      colors[ 21] = 0xFF00008B;  // DarkBlue
      colors[ 22] = 0xFF008B8B;  // DarkCyan
      colors[ 23] = 0xFFB8860B;  // DarkGoldenrod
      colors[ 24] = 0xFFA9A9A9;  // DarkGray
      colors[ 25] = 0xFF006400;  // DarkGreen
      colors[ 26] = 0xFFBDB76B;  // DarkKhaki
      colors[ 27] = 0xFF8B008B;  // DarkMagenta
      colors[ 28] = 0xFF556B2F;  // DarkOliveGreen
      colors[ 29] = 0xFFFF8C00;  // DarkOrange
      colors[ 30] = 0xFF9932CC;  // DarkOrchid
      colors[ 31] = 0xFF8B0000;  // DarkRed
      colors[ 32] = 0xFFE9967A;  // DarkSalmon
      colors[ 33] = 0xFF8FBC8B;  // DarkSeaGreen
      colors[ 34] = 0xFF483D8B;  // DarkSlateBlue
      colors[ 35] = 0xFF2F4F4F;  // DarkSlateGray
      colors[ 36] = 0xFF00CED1;  // DarkTurquoise
      colors[ 37] = 0xFF9400D3;  // DarkViolet
      colors[ 38] = 0xFFFF1493;  // DeepPink
      colors[ 39] = 0xFF00BFFF;  // DeepSkyBlue
      colors[ 40] = 0xFF696969;  // DimGray
      colors[ 41] = 0xFF1E90FF;  // DodgerBlue
      colors[ 42] = 0xFFB22222;  // Firebrick
      colors[ 43] = 0xFFFFFAF0;  // FloralWhite
      colors[ 44] = 0xFF228B22;  // ForestGreen
      colors[ 45] = 0xFFFF00FF;  // Fuchsia
      colors[ 46] = 0xFFDCDCDC;  // Gainsboro
      colors[ 47] = 0xFFF8F8FF;  // GhostWhite
      colors[ 48] = 0xFFFFD700;  // Gold
      colors[ 49] = 0xFFDAA520;  // Goldenrod
      colors[ 50] = 0xFF808080;  // Gray
      colors[ 51] = 0xFF008000;  // Green
      colors[ 52] = 0xFFADFF2F;  // GreenYellow
      colors[ 53] = 0xFFF0FFF0;  // Honeydew
      colors[ 54] = 0xFFFF69B4;  // HotPink
      colors[ 55] = 0xFFCD5C5C;  // IndianRed
      colors[ 56] = 0xFF4B0082;  // Indigo
      colors[ 57] = 0xFFFFFFF0;  // Ivory
      colors[ 58] = 0xFFF0E68C;  // Khaki
      colors[ 59] = 0xFFE6E6FA;  // Lavender
      colors[ 60] = 0xFFFFF0F5;  // LavenderBlush
      colors[ 61] = 0xFF7CFC00;  // LawnGreen
      colors[ 62] = 0xFFFFFACD;  // LemonChiffon
      colors[ 63] = 0xFFADD8E6;  // LightBlue
      colors[ 64] = 0xFFF08080;  // LightCoral
      colors[ 65] = 0xFFE0FFFF;  // LightCyan
      colors[ 66] = 0xFFFAFAD2;  // LightGoldenrodYellow
      colors[ 67] = 0xFFD3D3D3;  // LightGray
      colors[ 68] = 0xFF90EE90;  // LightGreen
      colors[ 69] = 0xFFFFB6C1;  // LightPink
      colors[ 70] = 0xFFFFA07A;  // LightSalmon
      colors[ 71] = 0xFF20B2AA;  // LightSeaGreen
      colors[ 72] = 0xFF87CEFA;  // LightSkyBlue
      colors[ 73] = 0xFF778899;  // LightSlateGray
      colors[ 74] = 0xFFB0C4DE;  // LightSteelBlue
      colors[ 75] = 0xFFFFFFE0;  // LightYellow
      colors[ 76] = 0xFF00FF00;  // Lime
      colors[ 77] = 0xFF32CD32;  // LimeGreen
      colors[ 78] = 0xFFFAF0E6;  // Linen
      colors[ 79] = 0xFFFF00FF;  // Magenta
      colors[ 80] = 0xFF800000;  // Maroon
      colors[ 81] = 0xFF66CDAA;  // MediumAquamarine
      colors[ 82] = 0xFF0000CD;  // MediumBlue
      colors[ 83] = 0xFFBA55D3;  // MediumOrchid
      colors[ 84] = 0xFF9370DB;  // MediumPurple
      colors[ 85] = 0xFF3CB371;  // MediumSeaGreen
      colors[ 86] = 0xFF7B68EE;  // MediumSlateBlue
      colors[ 87] = 0xFF00FA9A;  // MediumSpringGreen
      colors[ 88] = 0xFF48D1CC;  // MediumTurquoise
      colors[ 89] = 0xFFC71585;  // MediumVioletRed
      colors[ 90] = 0xFF191970;  // MidnightBlue
      colors[ 91] = 0xFFF5FFFA;  // MintCream
      colors[ 92] = 0xFFFFE4E1;  // MistyRose
      colors[ 93] = 0xFFFFE4B5;  // Moccasin
      colors[ 94] = 0xFFFFDEAD;  // NavajoWhite
      colors[ 95] = 0xFF000080;  // Navy
      colors[ 96] = 0xFFFDF5E6;  // OldLace
      colors[ 97] = 0xFF808000;  // Olive
      colors[ 98] = 0xFF6B8E23;  // OliveDrab
      colors[ 99] = 0xFFFFA500;  // Orange
      colors[100] = 0xFFFF4500;  // OrangeRed
      colors[101] = 0xFFDA70D6;  // Orchid
      colors[102] = 0xFFEEE8AA;  // PaleGoldenrod
      colors[103] = 0xFF98FB98;  // PaleGreen
      colors[104] = 0xFFAFEEEE;  // PaleTurquoise
      colors[105] = 0xFFDB7093;  // PaleVioletRed
      colors[106] = 0xFFFFEFD5;  // PapayaWhip
      colors[107] = 0xFFFFDAB9;  // PeachPuff
      colors[108] = 0xFFCD853F;  // Peru
      colors[109] = 0xFFFFC0CB;  // Pink
      colors[110] = 0xFFDDA0DD;  // Plum
      colors[111] = 0xFFB0E0E6;  // PowderBlue
      colors[112] = 0xFF800080;  // Purple
      colors[113] = 0xFFFF0000;  // Red
      colors[114] = 0xFFBC8F8F;  // RosyBrown
      colors[115] = 0xFF4169E1;  // RoyalBlue
      colors[116] = 0xFF8B4513;  // SaddleBrown
      colors[117] = 0xFFFA8072;  // Salmon
      colors[118] = 0xFFF4A460;  // SandyBrown
      colors[119] = 0xFF2E8B57;  // SeaGreen
      colors[120] = 0xFFFFF5EE;  // SeaShell
      colors[121] = 0xFFA0522D;  // Sienna
      colors[122] = 0xFFC0C0C0;  // Silver
      colors[123] = 0xFF87CEEB;  // SkyBlue
      colors[124] = 0xFF6A5ACD;  // SlateBlue
      colors[125] = 0xFF708090;  // SlateGray
      colors[126] = 0xFFFFFAFA;  // Snow
      colors[127] = 0xFF00FF7F;  // SpringGreen
      colors[128] = 0xFF4682B4;  // SteelBlue
      colors[129] = 0xFFD2B48C;  // Tan
      colors[130] = 0xFF008080;  // Teal
      colors[131] = 0xFFD8BFD8;  // Thistle
      colors[132] = 0xFFFF6347;  // Tomato
      colors[133] = 0x00FFFFFF;  // Transparent
      colors[134] = 0xFF40E0D0;  // Turquoise
      colors[135] = 0xFFEE82EE;  // Violet
      colors[136] = 0xFFF5DEB3;  // Wheat
      colors[137] = 0xFFFFFFFF;  // White
      colors[138] = 0xFFF5F5F5;  // WhiteSmoke
      colors[139] = 0xFFFFFF00;  // Yellow
      colors[140] = 0xFF9ACD32;  // YellowGreen

      XKnownColorTable.colorTable = colors;
    }
  }

  /*
  enum KnownColor2
  {
    AliceBlue            =   0,
    AntiqueWhite         =   1,
    Aqua                 =   2,
    Aquamarine           =   3,
    Azure                =   4,
    Beige                =   5,
    Bisque               =   6,
    Black                =   7,
    BlanchedAlmond       =   8,
    Blue                 =   9,
    BlueViolet           =  10,
    Brown                =  11,
    BurlyWood            =  12,
    CadetBlue            =  13,
    Chartreuse           =  14,
    Chocolate            =  15,
    Coral                =  16,
    CornflowerBlue       =  17,
    Cornsilk             =  18,
    Crimson              =  29,
    Cyan                 =  20,
    DarkBlue             =  21,
    DarkCyan             =  22,
    DarkGoldenrod        =  23,
    DarkGray             =  24,
    DarkGreen            =  25,
    DarkKhaki            =  26,
    DarkMagenta          =  27,
    DarkOliveGreen       =  28,
    DarkOrange           =  29,
    DarkOrchid           =  30,
    DarkRed              =  31,
    DarkSalmon           =  32,
    DarkSeaGreen         =  33,
    DarkSlateBlue        =  34,
    DarkSlateGray        =  35,
    DarkTurquoise        =  36,
    DarkViolet           =  37,
    DeepPink             =  38,
    DeepSkyBlue          =  39,
    DimGray              =  40,
    DodgerBlue           =  41,
    Firebrick            =  42,
    FloralWhite          =  43,
    ForestGreen          =  44,
    Fuchsia              =  45,
    Gainsboro            =  46,
    GhostWhite           =  47,
    Gold                 =  48,
    Goldenrod            =  49,
    Gray                 =  50,
    Green                =  51,
    GreenYellow          =  52,
    Honeydew             =  53,
    HotPink              =  54,
    IndianRed            =  55,
    Indigo               =  56,
    Ivory                =  57,
    Khaki                =  58,
    Lavender             =  59,
    LavenderBlush        =  60,
    LawnGreen            =  61,
    LemonChiffon         =  62,
    LightBlue            =  63,
    LightCoral           =  64,
    LightCyan            =  65,
    LightGoldenrodYellow =  66,
    LightGray            =  67,
    LightGreen           =  68,
    LightPink            =  69,
    LightSalmon          =  70,
    LightSeaGreen        =  71,
    LightSkyBlue         =  72,
    LightSlateGray       =  73,
    LightSteelBlue       =  74,
    LightYellow          =  75,
    Lime                 =  76,
    LimeGreen            =  77,
    Linen                =  78,
    Magenta              =  79,
    Maroon               =  80,
    MediumAquamarine     =  81,
    MediumBlue           =  82,
    MediumOrchid         =  83,
    MediumPurple         =  84,
    MediumSeaGreen       =  85,
    MediumSlateBlue      =  86,
    MediumSpringGreen    =  87,
    MediumTurquoise      =  88,
    MediumVioletRed      =  89,
    MidnightBlue         =  90,
    MintCream            =  91,
    MistyRose            =  92,
    Moccasin             =  93,
    NavajoWhite          =  94,
    Navy                 =  95,
    OldLace              =  96,
    Olive                =  97,
    OliveDrab            =  98,
    Orange               =  99,
    OrangeRed            = 100,
    Orchid               = 101,
    PaleGoldenrod        = 102,
    PaleGreen            = 103,
    PaleTurquoise        = 104,
    PaleVioletRed        = 105,
    PapayaWhip           = 106,
    PeachPuff            = 107,
    Peru                 = 108,
    Pink                 = 109,
    Plum                 = 110,
    PowderBlue           = 111,
    Purple               = 112,
    Red                  = 113,
    RosyBrown            = 114,
    RoyalBlue            = 115,
    SaddleBrown          = 116,
    Salmon               = 117,
    SandyBrown           = 118,
    SeaGreen             = 119,
    SeaShell             = 120,
    Sienna               = 121,
    Silver               = 122,
    SkyBlue              = 123,
    SlateBlue            = 124,
    SlateGray            = 125,
    Snow                 = 126,
    SpringGreen          = 127,
    SteelBlue            = 128,
    Tan                  = 129,
    Teal                 = 130,
    Thistle              = 131,
    Tomato               = 132,
    Transparent          = 133,
    Turquoise            = 134,
    Violet               = 135,
    Wheat                = 136,
    White                = 137,
    WhiteSmoke           = 138,
    Yellow               = 139,
    YellowGreen          = 140,
  }

  internal class Kct
  {
    private static int[] colorTable;

    private static void InitColorTable()
    {
      int[] colors = new int[141];

      colors[  0] = 0xFFF0F8FF;  // AliceBlue
      colors[  1] = 0xFFFAEBD7;  // AntiqueWhite
      colors[  2] = 0xFF00FFFF;  // Aqua
      colors[  3] = 0xFF7FFFD4;  // Aquamarine
      colors[  4] = 0xFFF0FFFF;  // Azure
      colors[  5] = 0xFFF5F5DC;  // Beige
      colors[  6] = 0xFFFFE4C4;  // Bisque
      colors[  7] = 0xFF000000;  // Black
      colors[  8] = 0xFFFFEBCD;  // BlanchedAlmond
      colors[  9] = 0xFF0000FF;  // Blue
      colors[ 10] = 0xFF8A2BE2;  // BlueViolet
      colors[ 11] = 0xFFA52A2A;  // Brown
      colors[ 12] = 0xFFDEB887;  // BurlyWood
      colors[ 13] = 0xFF5F9EA0;  // CadetBlue
      colors[ 14] = 0xFF7FFF00;  // Chartreuse
      colors[ 15] = 0xFFD2691E;  // Chocolate
      colors[ 16] = 0xFFFF7F50;  // Coral
      colors[ 17] = 0xFF6495ED;  // CornflowerBlue
      colors[ 18] = 0xFFFFF8DC;  // Cornsilk
      colors[ 29] = 0xFFDC143C;  // Crimson
      colors[ 20] = 0xFF00FFFF;  // Cyan
      colors[ 21] = 0xFF00008B;  // DarkBlue
      colors[ 22] = 0xFF008B8B;  // DarkCyan
      colors[ 23] = 0xFFB8860B;  // DarkGoldenrod
      colors[ 24] = 0xFFA9A9A9;  // DarkGray
      colors[ 25] = 0xFF006400;  // DarkGreen
      colors[ 26] = 0xFFBDB76B;  // DarkKhaki
      colors[ 27] = 0xFF8B008B;  // DarkMagenta
      colors[ 28] = 0xFF556B2F;  // DarkOliveGreen
      colors[ 29] = 0xFFFF8C00;  // DarkOrange
      colors[ 30] = 0xFF9932CC;  // DarkOrchid
      colors[ 31] = 0xFF8B0000;  // DarkRed
      colors[ 32] = 0xFFE9967A;  // DarkSalmon
      colors[ 33] = 0xFF8FBC8B;  // DarkSeaGreen
      colors[ 34] = 0xFF483D8B;  // DarkSlateBlue
      colors[ 35] = 0xFF2F4F4F;  // DarkSlateGray
      colors[ 36] = 0xFF00CED1;  // DarkTurquoise
      colors[ 37] = 0xFF9400D3;  // DarkViolet
      colors[ 38] = 0xFFFF1493;  // DeepPink
      colors[ 39] = 0xFF00BFFF;  // DeepSkyBlue
      colors[ 40] = 0xFF696969;  // DimGray
      colors[ 41] = 0xFF1E90FF;  // DodgerBlue
      colors[ 42] = 0xFFB22222;  // Firebrick
      colors[ 43] = 0xFFFFFAF0;  // FloralWhite
      colors[ 44] = 0xFF228B22;  // ForestGreen
      colors[ 45] = 0xFFFF00FF;  // Fuchsia
      colors[ 46] = 0xFFDCDCDC;  // Gainsboro
      colors[ 47] = 0xFFF8F8FF;  // GhostWhite
      colors[ 48] = 0xFFFFD700;  // Gold
      colors[ 49] = 0xFFDAA520;  // Goldenrod
      colors[ 50] = 0xFF808080;  // Gray
      colors[ 51] = 0xFF008000;  // Green
      colors[ 52] = 0xFFADFF2F;  // GreenYellow
      colors[ 53] = 0xFFF0FFF0;  // Honeydew
      colors[ 54] = 0xFFFF69B4;  // HotPink
      colors[ 55] = 0xFFCD5C5C;  // IndianRed
      colors[ 56] = 0xFF4B0082;  // Indigo
      colors[ 57] = 0xFFFFFFF0;  // Ivory
      colors[ 58] = 0xFFF0E68C;  // Khaki
      colors[ 59] = 0xFFE6E6FA;  // Lavender
      colors[ 60] = 0xFFFFF0F5;  // LavenderBlush
      colors[ 61] = 0xFF7CFC00;  // LawnGreen
      colors[ 62] = 0xFFFFFACD;  // LemonChiffon
      colors[ 63] = 0xFFADD8E6;  // LightBlue
      colors[ 64] = 0xFFF08080;  // LightCoral
      colors[ 65] = 0xFFE0FFFF;  // LightCyan
      colors[ 66] = 0xFFFAFAD2;  // LightGoldenrodYellow
      colors[ 67] = 0xFFD3D3D3;  // LightGray
      colors[ 68] = 0xFF90EE90;  // LightGreen
      colors[ 69] = 0xFFFFB6C1;  // LightPink
      colors[ 70] = 0xFFFFA07A;  // LightSalmon
      colors[ 71] = 0xFF20B2AA;  // LightSeaGreen
      colors[ 72] = 0xFF87CEFA;  // LightSkyBlue
      colors[ 73] = 0xFF778899;  // LightSlateGray
      colors[ 74] = 0xFFB0C4DE;  // LightSteelBlue
      colors[ 75] = 0xFFFFFFE0;  // LightYellow
      colors[ 76] = 0xFF00FF00;  // Lime
      colors[ 77] = 0xFF32CD32;  // LimeGreen
      colors[ 78] = 0xFFFAF0E6;  // Linen
      colors[ 79] = 0xFFFF00FF;  // Magenta
      colors[ 80] = 0xFF800000;  // Maroon
      colors[ 81] = 0xFF66CDAA;  // MediumAquamarine
      colors[ 82] = 0xFF0000CD;  // MediumBlue
      colors[ 83] = 0xFFBA55D3;  // MediumOrchid
      colors[ 84] = 0xFF9370DB;  // MediumPurple
      colors[ 85] = 0xFF3CB371;  // MediumSeaGreen
      colors[ 86] = 0xFF7B68EE;  // MediumSlateBlue
      colors[ 87] = 0xFF00FA9A;  // MediumSpringGreen
      colors[ 88] = 0xFF48D1CC;  // MediumTurquoise
      colors[ 89] = 0xFFC71585;  // MediumVioletRed
      colors[ 90] = 0xFF191970;  // MidnightBlue
      colors[ 91] = 0xFFF5FFFA;  // MintCream
      colors[ 92] = 0xFFFFE4E1;  // MistyRose
      colors[ 93] = 0xFFFFE4B5;  // Moccasin
      colors[ 94] = 0xFFFFDEAD;  // NavajoWhite
      colors[ 95] = 0xFF000080;  // Navy
      colors[ 96] = 0xFFFDF5E6;  // OldLace
      colors[ 97] = 0xFF808000;  // Olive
      colors[ 98] = 0xFF6B8E23;  // OliveDrab
      colors[ 99] = 0xFFFFA500;  // Orange
      colors[100] = 0xFFFF4500;  // OrangeRed
      colors[101] = 0xFFDA70D6;  // Orchid
      colors[102] = 0xFFEEE8AA;  // PaleGoldenrod
      colors[103] = 0xFF98FB98;  // PaleGreen
      colors[104] = 0xFFAFEEEE;  // PaleTurquoise
      colors[105] = 0xFFDB7093;  // PaleVioletRed
      colors[106] = 0xFFFFEFD5;  // PapayaWhip
      colors[107] = 0xFFFFDAB9;  // PeachPuff
      colors[108] = 0xFFCD853F;  // Peru
      colors[109] = 0xFFFFC0CB;  // Pink
      colors[110] = 0xFFDDA0DD;  // Plum
      colors[111] = 0xFFB0E0E6;  // PowderBlue
      colors[112] = 0xFF800080;  // Purple
      colors[113] = 0xFFFF0000;  // Red
      colors[114] = 0xFFBC8F8F;  // RosyBrown
      colors[115] = 0xFF4169E1;  // RoyalBlue
      colors[116] = 0xFF8B4513;  // SaddleBrown
      colors[117] = 0xFFFA8072;  // Salmon
      colors[118] = 0xFFF4A460;  // SandyBrown
      colors[119] = 0xFF2E8B57;  // SeaGreen
      colors[120] = 0xFFFFF5EE;  // SeaShell
      colors[121] = 0xFFA0522D;  // Sienna
      colors[122] = 0xFFC0C0C0;  // Silver
      colors[123] = 0xFF87CEEB;  // SkyBlue
      colors[124] = 0xFF6A5ACD;  // SlateBlue
      colors[125] = 0xFF708090;  // SlateGray
      colors[126] = 0xFFFFFAFA;  // Snow
      colors[127] = 0xFF00FF7F;  // SpringGreen
      colors[128] = 0xFF4682B4;  // SteelBlue
      colors[129] = 0xFFD2B48C;  // Tan
      colors[130] = 0xFF008080;  // Teal
      colors[131] = 0xFFD8BFD8;  // Thistle
      colors[132] = 0xFFFF6347;  // Tomato
      colors[133] = 0x00FFFFFF;  // Transparent
      colors[134] = 0xFF40E0D0;  // Turquoise
      colors[135] = 0xFFEE82EE;  // Violet
      colors[136] = 0xFFF5DEB3;  // Wheat
      colors[137] = 0xFFFFFFFF;  // White
      colors[138] = 0xFFF5F5F5;  // WhiteSmoke
      colors[139] = 0xFFFFFF00;  // Yellow
      colors[140] = 0xFF9ACD32;  // YellowGreen
    }
  }
  */
}
