using System;
using System.Runtime.InteropServices;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.IO;
using System.ComponentModel;
using PdfSharp.Internal;
using PdfSharp.Fonts.TrueType;
using PdfSharp.Pdf;
using PdfSharp.Pdf.Advanced;

namespace PdfSharp.Drawing
{
  /// <summary>
  /// under construction
  /// </summary>
  public class PdfFontOptions
  {
    internal PdfFontOptions()
    {
    }

    public PdfFontOptions(bool embed, bool unicode, string baseFont, string fontFile)
    {
      if (baseFont == null)
        throw new ArgumentNullException("baseFont");
      if (fontFile == null)
        throw new ArgumentNullException("fontFile");

      this.embed = embed;
      this.unicode = unicode;
      this.baseFont = baseFont;
      this.fontFile = fontFile;
    }

    public PdfFontOptions(bool embed, string baseFont) :
      this(embed, false, baseFont, "")
    {}

    public PdfFontOptions(bool embed) :
      this(embed, false, "", "")
    {}

    public bool Embed
    {
      get {return this.embed;}
    }
    bool embed;

    //    public bool Subset
    //    {
    //      get {return this.subset;}
    //    }
    //    bool subset;

    public bool Unicode
    {
      get {return this.unicode;}
    }
    bool unicode;

    public string BaseFont
    {
      get {return this.baseFont;}
    }
    string baseFont = "";

    public string FontFile
    {
      get {return this.fontFile;}
    }
    string fontFile = "";

// this is part of XGraphics
//    public double CharacterSpacing;
//    public double WordSpacing;
//    public double HorizontalScaling;
//    public double Leading;
//    public double TextRise;
//    Kerning
  }
}
