//
// PDFSharp - A library for processing PDF
//
// Authors:
//   Stefan Lange (mailto:Stefan.Lange@pdfsharp.com)
//
// Copyright (c) 2005 empira Software GmbH, Cologne (Germany)
//
// http://www.pdfsharp.com
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

using System;
using System.Diagnostics;
using System.Collections;
using System.Drawing;
using System.Drawing.Drawing2D;

namespace PdfSharp.Drawing
{
  /// <summary>
  /// Represents a stack of XGraphicsState and XGraphicsContainer objects.
  /// </summary>
  internal class GraphicsStateStack
  {
    public GraphicsStateStack()
    {
    }

    public void Push(XGraphicsState state)
    {
      this.stack.Push(state);
    }

    public void Push(XGraphicsContainer container)
    {
      this.stack.Push(container);
    }

    public int Restore(object obj)
    {
      if (!this.stack.Contains(obj))
        throw new ArgumentException("obj"); // TODO
      if (obj is XGraphicsState && ((XGraphicsState)obj).state == null)
        throw new ArgumentException("state already restored"); // TODO
      if (obj is XGraphicsContainer && ((XGraphicsContainer)obj).container == null)
        throw new ArgumentException("container already ended"); // TODO

      int count = 1;
      object top = this.stack.Pop();
      while (top != obj)
      {
        count++;
        Invalidate(top);
        top = this.stack.Pop();
      }
      Invalidate(top);
      return count;
    }

    void Invalidate(object obj)
    {
      XGraphicsState state = obj as XGraphicsState;
      if (state != null)
      {
        state.state = null;
        return;
      }

      XGraphicsContainer container = obj as XGraphicsContainer;
      if (container != null)
        container.container  = null;
    }

    Stack stack = new Stack();
  }
}
