﻿#region MigraDoc - Creating Documents on the Fly
//
// Authors:
//   Stefan Lange (mailto:Stefan.Lange@pdfsharp.com)
//   Klaus Potzesny (mailto:Klaus.Potzesny@pdfsharp.com)
//   David Stephensen (mailto:David.Stephensen@pdfsharp.com)
//
// Copyright (c) 2001-2008 empira Software GmbH, Cologne (Germany)
//
// http://www.pdfsharp.com
// http://www.migradoc.com
// http://sourceforge.net/projects/pdfsharp
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
// DEALINGS IN THE SOFTWARE.
#endregion

using System;
using System.Collections.Generic;
using System.Text;

namespace MigraDoc.DocumentObjectModel
{
  public class ImageHelper
  {
    /// <summary>
    /// Gets the first existing image from the subfolders.
    /// </summary>
    public static string GetImageName(string root, string filename, string imagePath)
    {
      List<string> subfolders = new List<string>(imagePath.Split(new char[] { ';' }, StringSplitOptions.RemoveEmptyEntries));
      subfolders.Add("");

      foreach (string subfolder in subfolders)
      {
        string fullname = System.IO.Path.Combine(System.IO.Path.Combine(root, subfolder), filename);
        if (System.IO.File.Exists(fullname))
          return fullname;
      }
      return null;
    }

    /// <summary>
    /// Gets a value indicating whether the filename given in the referenceFilename exists in the subfolders.
    /// </summary>
    public static bool InSubfolder(string root, string filename, string imagePath, string referenceFilename)
    {
      List<string> subfolders = new List<string>(imagePath.Split(new char[] { ';' }, StringSplitOptions.RemoveEmptyEntries));
      subfolders.Add("");

      foreach (string subfolder in subfolders)
      {
        string fullname = System.IO.Path.Combine(System.IO.Path.Combine(root, subfolder), filename);
        if (System.IO.File.Exists(fullname))
        {
          if (fullname == referenceFilename)
            return true;
        }
      }
      return false;
    }
  }
}
