__version__ = "0.6"

import os
import SocketServer
import BaseHTTPServer
import MeCab
import sys
import signal
import select

class TimeoutError (Exception): pass
def SIGALRM_handler(sig, stack): raise TimeoutError()
signal.signal(signal.SIGALRM, SIGALRM_handler)

class SimpleHTTPRequestHandler(BaseHTTPServer.BaseHTTPRequestHandler):

    server_version = "MeCabHTTP/" + __version__
    
    def do_GET(self):
	try:
	    mecab = MeCab.Tagger (sys.argv)	    
	    print "start"
	except RuntimeError, e:
	    print "RuntimeError:", e;
	self.send_head()
	self.wfile.write (mecab.parse (self.path))

    def do_POST(self):
	try:
	    mecab = MeCab.Tagger (sys.argv)	    
	    print "start"
	except RuntimeError, e:
	    print "RuntimeError:", e;
	self.send_head()
	length = self.headers.getheader('content-length')
	try:
	    nbytes = int(length)
	except:
	    nbytes = 0
	    
	data = self.rfile.read(nbytes)
	self.wfile.write (mecab.parse (data))

    def do_HEAD(self):
	self.send_head()

    def send_head(self):
        self.send_response(200)
        self.send_header("Content-type", "text/plain")
        self.end_headers()
	
class ThreadingHTTPServer (SocketServer.ThreadingMixIn,
                           BaseHTTPServer.HTTPServer): pass

if __name__ == '__main__':
    BaseHTTPServer.test(SimpleHTTPRequestHandler, ThreadingHTTPServer)
