<?php
	// This PHP guestbook script was written by Thomas Hettenhausen in 2003.
	// http://flatphpbook.sourceforge.net
	// http://www.hettenhausen.net
	//
	// This software is free software; you can redistribute it and/or modify
	// it under the terms of the GNU General Public License as published by
	// the Free Software Foundation; either version 2 of the License, or
	// (at your option) any later version.
	// 
	// This program is distributed in the hope that it will be useful,
	// but WITHOUT ANY WARRANTY; without even the implied warranty of
	// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	// GNU General Public License for more details.
	// 
	// You should have received a copy of the GNU General Public License
	// along with this program; if not, write to the Free Software
	// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	// starting the session for the admin login
	session_start();
	header("Cache-control: private"); // IE 6 Fix, needed for using the "Back" button with sessions and forms

	// reading the configuration from the INI file
	$INIfileName = "guestbook.ini";
	$configFromINI = parse_ini_file($INIfileName, true);

	// admin settings	
	$adminusername = "admin"; // the administrator username who can delete posts - YOU REALLY SHOULD CHANGE THIS
	$adminpassword = "adminpw" ; // the corresponding passwort - YOU REALLY SHOULD CHANGE THIS
	$adminmode = 0; // set adminmode to 0 for security reasons DO NOT CHANGE THIS
	
	// reading the language-specific content
	$languageStrings = parse_ini_file($configFromINI['Files']['languageFile']);





	////////////////////////////////////////////////////////////////////////
	//                             FUNCTIONS DECLARATIONS                            //
	////////////////////////////////////////////////////////////////////////


	// removes HTML tags and the delimiters used in the db file from the input
	function safeHTML($input)	{
		global $configFromINI;
		$input = strip_tags($input);
		$input = htmlspecialchars(stripslashes($input), ENT_QUOTES);
		$input = preg_replace("/(\015\012)|(\015)|(\012)/", "&nbsp;<br />", $input); // exchanges CR, LF and CRLF with <br />
		$input = ereg_replace($configFromINI['General']['delimiter'], "[[delimiter]]", $input);
		return $input;
	}

	// here the BBcode for formatting, links and images is replaced with the real HTML tags
	// together with any incidentally used delimiter in the database file (because a visitor wanted to use it in his text) -
	// they were exchanged by the safeHTML() function and are now reinserted for display
	function recreateUserInput($input)	{
		global $configFromINI;
		$input = str_replace("[[delimiter]]", $configFromINI['General']['delimiter'], $input);		// put the real delimiter back into the string
		$input = preg_replace('/(\[b\])(.+?)(\[\/b\])/i', '<b>\\2</b>',  $input);
		$input = preg_replace('/(\[i\])(.+?)(\[\/i\])/i', '<i>\\2</i>', $input);
		$input = preg_replace('/(\[u\])(.+?)(\[\/u\])/i', "<u>\\2</u>", $input);
		$input = preg_replace('/(\[pre\])(.+?)(\[\/pre\])/i', "<pre>\\2</pre>", $input);
		$input = preg_replace('/(\[img\])(.+?)(\[\/img\])/i', '<img src="\\2" alt="\\2">', $input);
		$input = preg_replace('/(\[color=(.+?)\])(.+?)(\[\/color\])/i', '<font color=\\2>\\3</font>', $input);
		$input = preg_replace('/(\[email\])(.+?)(\[\/email\])/i', "<a href=\"mailto:\\2\">\\2 </a>", $input);
		$input = preg_replace('/(\[email=(.+?)\])(.+?)(\[\/email\])/i', "<a href=\"mailto:\\2\">\\3</a>", $input);
		$input = preg_replace('/\[url\]http\:\/\//i', '[url]', $input);
		$input = preg_replace('/\[url=http\:\/\//i', '[url=', $input);
		$input = preg_replace('/(\[url\])(.+?)(\[\/url\])/i', "<a href=\"http://\\2\">\\2</a>", $input);
		$input = preg_replace('/(\[url=\])(.+?)(\[\/url\])/i', "<a href=\"http://\\2\">\\2</a>", $input);
		$input = preg_replace('/(\[url=(.+?)\])(.+?)(\[\/url\])/i', "<a href=\"http://\\2\">\\3</a>", $input);
		$input = str_replace('\\&quot;', '&quot;', $input);
		return $input;
	}

	// displays the input fields for a new post: name, email, you name it
	// made into a function because used twice in the script, saves place
	function displayInputForm($Nickname, $Emailaddress, $Homepage, $forgotten) {
		global $languageStrings;
		
		switch($forgotten)	{
			case "nickname":
				$highliteMessageOpen = "";
				$highliteMessageClose = "";
				$highliteNickOpen = "<span style='color: #ff0000;'>*&nbsp;";
				$highliteNickClose = "</span>";
				break;
			case "message":
				$highliteNickOpen = "";
				$highliteNickClose = "";
				$highliteMessageOpen = "<span style='color: #ff0000;'>*&nbsp;";
				$highliteMessageClose = "</span>";
				break;
			case "both":
				$highliteNickOpen = "<span style='color: #ff0000;'>*&nbsp;";
				$highliteNickClose = "</span>";
				$highliteMessageOpen = "<span style='color: #ff0000;'>*&nbsp;";
				$highliteMessageClose = "</span>";
				break;
			default:
				$highliteNickOpen = "";
				$highliteNickClose = "";
				$highliteMessageOpen = "";
				$highliteMessageClose = "";
				break;
		}
		
		if (isset($_POST["Message"]))	{
			$messageDisplay = stripslashes($_POST["Message"]);
		}
		else	{
			$messageDisplay = "";
		}
		echo "\n\t\t\t<table>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>\n\t\t\t\t\t\t<form name='inputform' method='post' action='" . $_SERVER['PHP_SELF'] . "'>\n";
		echo "\t\t\t\t\t\t\t<table border='0'>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td>".$highliteNickOpen.$languageStrings['YourName'].$highliteNickClose.":<br>";
		echo "<input type='text' name='NickName' size='26' value='".$Nickname."' /></td>\n";
		echo "\t\t\t\t\t\t\t\t\t<td>".$languageStrings['YourEmail'].":<br>";
		echo "<input type='text' name='EmailAddress' size='36' value='" . $Emailaddress . "' /></td>";
		echo "\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td colspan='2'>".$languageStrings['YourHomepage'].":<br>";
		echo "<input type='text' name='Homepage' size='67' value='" . $Homepage . "' /><br>";
		echo "\t\t\t</td></tr><tr><td colspan='2'>".$highliteMessageOpen.$languageStrings['YourMessage'].$highliteMessageClose.":<br>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<textarea rows='5' cols='50' id='messagebox' name='Message'>" . $messageDisplay . "</textarea>\n\t\t\t\t\t\t\t\t\t\t<br>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<input type='button' accesskey='h' value='".$languageStrings['ButtonWWW']."' onClick='addHyperlink(\"".$languageStrings['jsWWWurl']."\", \"".$languageStrings['jsWWWname']."\")' onMouseOver='helpHyperlink(\"".$languageStrings['jsHelpWWW']."\")' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<input type='button' accesskey='e' value='".$languageStrings['ButtonEmail']."' onClick='addEmail(\"".$languageStrings['jsEmailAddress']."\", \"".$languageStrings['jsEmailName']."\")' onMouseOver='helpEmail(\"".$languageStrings['jsHelpEmail']."\")' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<input type='button' accesskey='b' value='".$languageStrings['ButtonBold']."' style='font-weight: bold;' onClick='addBold(\"".$languageStrings['jsBold']."\", \"".$languageStrings['jsYourTextGoesHere']."\")' onMouseOver='helpBold(\"".$languageStrings['jsHelpBold']."\")' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<input type='button' accesskey='i' value='".$languageStrings['ButtonItalic']."' style='font-style: italic;' onClick='addItalics(\"".$languageStrings['jsItalic']."\", \"".$languageStrings['jsYourTextGoesHere']."\")' onMouseOver='helpItalics(\"".$languageStrings['jsHelpItalic']."\")' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<input type='button' accesskey='u' value='".$languageStrings['ButtonUnderline']."' style='text-decoration: underline;' onClick='addUnderline(\"".$languageStrings['jsUnderline']."\", \"".$languageStrings['jsYourTextGoesHere']."\")' onMouseOver='helpUnderline(\"".$languageStrings['jsHelpUnderline']."\")' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<select name='colorselect' size='1' onChange='addColor(\"".$languageStrings['jsColor']."\", \"".$languageStrings['jsYourTextGoesHere']."\")' onMouseOver='helpColor(\"".$languageStrings['jsHelpColor']."\")' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t\t<option>".$languageStrings['ButtonColor']."</option><option value='#ff0000'>".$languageStrings['red']."</option><option value='#ff8800'>".$languageStrings['orange']."</option><option value='#ffff00'>".$languageStrings['yellow']."</option>\n";
		echo "\t\t\t\t\t\t\t\t\t\t\t<option value='#884400'>".$languageStrings['brown']."</option><option value='#00ff00'>".$languageStrings['green']."</option><option value='#00ffff'>".$languageStrings['turquoise']."</option><option value='#0000ff'>".$languageStrings['blue']."</option>\n";
		echo "\t\t\t\t\t\t\t\t\t\t\t<option value='#8800ff'>".$languageStrings['violet']."</option><option value='#ff00ff'>".$languageStrings['pink']."</option><option value='#ffffff'>".$languageStrings['white']."</option>\n\t\t\t\t\t\t\t\t\t\t</select>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<input type='button' value='".$languageStrings['ButtonImage']."' onClick='addImage(\"".$languageStrings['jsImage']."\")' onMouseOver='helpImage(\"".$languageStrings['jsHelpImage']."\")' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<input type='button' value='".$languageStrings['ButtonCode']."' style='font-family: monospaced;' onClick='addCode(\"".$languageStrings['jsCode']."\", \"".$languageStrings['jsYourTextGoesHere']."\")' onMouseOver='helpCode(\"".$languageStrings['jsHelpCode']."\")' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<div id='jsHelpLine' class='jsHelpLine'>&nbsp;<br></div>\n";
		echo "\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td colspan='2'>\n\t\t\t\t\t\t\t\t\t\t<div align='left'>\n\t\t\t\t\t\t\t\t\t\t\t<input type='submit' name='submit' value='".$languageStrings['SubmitPost']."' />&nbsp;\n";
		echo "\t\t\t\t\t\t\t\t\t\t\t<input type='submit' name='preview' value='".$languageStrings['PreviewPost']."'>&nbsp;\n";
		if (isset($_POST['preview']) || isset($_POST['submit']))	{
			echo "\t\t\t\t\t\t\t\t\t\t\t<input type='submit' name='cancel' value='".$languageStrings['Cancel']."'>\n";
		}
		echo "\t\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</form>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t</table>";
	}


	// called when displaying posts on more than one page
	// adds the page navigation that looks like "< [1] 2 3 >"
	function displayPostNavigation($numberofposts, $offset)
	{
		global $configFromINI;
		if (($numberofposts > 0) && ($numberofposts > $configFromINI['Behaviour']['entriesPerPage']))	{
			$numberofpages = ceil($numberofposts / $configFromINI['Behaviour']['entriesPerPage']); // one post more than entries per page -> new page
			echo "\n\t\t<!-- navigation between the pages -->";
			echo "\n\t\t<div style='text-align: center; width: 100%;'><p style='font-weight: bold;'>";
			echo "\n\t\t\t<a href='" . $_SERVER['PHP_SELF'] . "?offset=" . max(($offset - $configFromINI['Behaviour']['entriesPerPage']), 0) . "'>&laquo;</a>";
			for ($thispage = 1; $thispage <= $numberofpages; $thispage++)  {
				if (($offset >= ($configFromINI['Behaviour']['entriesPerPage'] * ($thispage - 1))) && ($offset < ($configFromINI['Behaviour']['entriesPerPage'] * $thispage))) {
					echo "&nbsp;[" . $thispage . "]";
				}
				else {
					echo "&nbsp;<a href='" . $_SERVER['PHP_SELF'] . "?offset=" . ($configFromINI['Behaviour']['entriesPerPage'] * ($thispage - 1)) . "'>" . $thispage . "</a>";
				}
			}
			echo "&nbsp;<a href='" . $_SERVER['PHP_SELF'] . "?offset=" . min(($offset + $configFromINI['Behaviour']['entriesPerPage']), $numberofposts - 1) . "'>&raquo;</a>\n";
			echo "\t\t</p></div>\n\n";
		}
	}
	
	// displays the recurring html header that is the same on every page (page title, style sheet, JavaScript, meta tags...)
	function displayHTMLHeader()	{
		global  $configFromINI;
		echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n\n";
		echo "<html>\n\t<head>\n\t\n\t\t<title>" . $configFromINI['General']['gbName'] . "</title>\n\t\t<meta name='Author' content='Thomas Hettenhausen'>\n";
		echo "\t\t<meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1'>\n";
		echo "\t\t<link rel='stylesheet' type='text/css' href='" . $configFromINI['Files']['stylesheetFile'] . "'>\n";
		echo "\t\t<script language='JavaScript' type='text/javascript' src='" . $configFromINI['Files']['javascriptFile'] . "'></script>\n\t</head>\n\t<body>\n";
	}
	
	// displays the html footer (the link to my homepage, and the required closing tags that are the same on all pages
	function displayHTMLFooter()	{
		echo "\t\t<div style='text-align: center; margin-top: 10px;'>\n\t\t\t<a href='http://flatphpbook.sourceforge.net/' style='font-size: 9px;'>flatPHPbook by Thomas Hettenhausen</a>\n\t\t</div>";
		echo "\n\t</body>\n</html>";
	}
	
	// displays the appropriate link to either login to or logout from admin mode
	function displayAdminLinks()	{
		global $adminmode, $languageStrings;
		if ($adminmode == "1")	{
			echo "\t\t<div class='adminlink'><a href='" . $_SERVER['PHP_SELF'] . "?logout' style='font-size: 9px;'>".$languageStrings['AdminLogout']."</a></div>\n";
		}
		else {
			echo "\t\t<div class='adminlink'><a href='" . $_SERVER['PHP_SELF'] . "?adminlogin=1' style='font-size: 9px;'>".$languageStrings['AdminLogin']."</a></div>\n";
		}
	}
	
	// displays the current guestbook entries
	function displayGuestbook()	{
		global $configFromINI, $languageStrings, $adminmode;

		// checking if we are displaying posts starting with the first one or if we start somewhere else when using multiple pages
		if (isset($_GET["offset"]))	{
			$offset = $_GET["offset"];
		}
		else	{
			$offset = 0;
		}
		
		// reading the content of the guestbook file ($guestbookFile) and creating an array ($content) out of it
		//
		// if the file does not exist, create it for further use
		if (!file_exists($configFromINI['Files']['guestbookFile']))	{
			touch($configFromINI['Files']['guestbookFile']);
		}
		$content = file($configFromINI['Files']['guestbookFile']);
		$numberofposts = count($content);

		// displaying the total number of posts in the guestbook if wanted
		if ($configFromINI['Behaviour']['showTotalNumber'] == 1)	{
			echo "\n\t\t<!-- displaying the total number of posts in the guestbook -->\n";
			echo "\t\t<div class='gbinput'>\n\t\t\t<p style='font-weight: bold; text-align: center;'>\n\t\t\t\t".$languageStrings['TotalNumberOfPosts'].$numberofposts . "\n\t\t\t</p>\n\t\t</div>\n";
		}

		// if splitting the posts onto several pages, display navigation links
		if ($configFromINI['Behaviour']['entriesPerPage'] > 0)	{
			displayPostNavigation($numberofposts, $offset);
		}

		// creating array out of guestbook entry
		//
		// prepare the check whether whole guestbook or current entry is empty (either if it is the last or if there accidentally got an empty line into the database file)
		$gbIsEmpty = "1";

		// order of display is checked: usually you want newest first
		if ($configFromINI['Behaviour']['displayNewestFirst'] == "1")	{
			$content = array_reverse($content);
		}

		echo "\n\t\t<!-- beginning of the display of the guestbook entries -->\n";
		echo "\n\t\t<table class='gbdisplay' cellpadding='0' cellspacing='0'>\n";

		// looping over the posts and displaying the table rows for each one
		for ($postnumber = 0; $postnumber < $numberofposts; $postnumber++)	{
			$gbentryline = $content[$postnumber];

			// the current post might be empty, and then ...
			if (($gbentryline == "") && ($gbIsEmpty == "1"))	{
				// Obviously, the guestbook is currently empty -> display a message.
				echo "The guestbook is currently empty.";
			}
			else	{
				if (($configFromINI['Behaviour']['entriesPerPage'] == 0) || (($configFromINI['Behaviour']['entriesPerPage'] != 0) && ($postnumber >= $offset) && ($postnumber < ($offset + $configFromINI['Behaviour']['entriesPerPage']))))	{
					// if we are here, we can display the current post

					// creating an array of each line in the guestbook file
					$gbentry = split($configFromINI['General']['delimiter'], $gbentryline);

					// first line of post: dark background;left cell: "nickname", right cell: "date, time"
					echo "\n\t\t\t<!-- post number " . ($numberofposts - $postnumber) . " -->\n";
					echo "\t\t\t<tr class='layouttr'>\n\t\t\t\t<td class='posttopleft' valign='top'>";
					echo "\n\t\t\t\t\t<span class='emphasis'>" . ($numberofposts - $postnumber) . ". " . $gbentry[0] . "</span>\n\t\t\t\t</td>\n";
					echo "\t\t\t\t<td class='posttopright'  valign='top'>\n\t\t\t\t\t<span class='emphasis'>" . $gbentry[3] . ", " . $gbentry[4] . "</span>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n";

					// second line of post: light background; left cell: "homepage, email", right cell: "message"
					echo "\t\t\t<tr>\n\t\t\t\t<td class='postbottomleft'  valign='top'>";
					if ($gbentry[1] != "")	{
						echo " <a href='mailto:" . $gbentry[1] . "'><img src='" . $configFromINI['Files']['emailIcon'] . "' alt='email' border=''></a>&nbsp;";
						if ($gbentry[2] == "")	{
							echo "\n\t\t\t\t<br>";
						}
					}

					if ($gbentry[2] != "")	{
						$currentHomepage = $gbentry[2];
						if (!(preg_match("/^http:\/\//", $currentHomepage)))
							{	$currentHomepage = "http://" . $currentHomepage;	}
						echo "<a href='" . $currentHomepage . "'><img src='" . $configFromINI['Files']['homepageIcon'] . "' alt='homepage' border='0'></a><br>";
					}

					// displaying button to delete the entry if logged in as admin
					if ($adminmode == 1)	{
						echo "\n\t\t\t\t\t<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'><input type='hidden' name='whichpost' value='" . $postnumber . "'><input type='hidden' name='posttime' value='" . $gbentry[4] . "'><input type='submit' value='".$languageStrings['AdminDelete']."' name='delete'></form>";
					}
					echo "</td>\n\t\t\t\t<td class='postbottomright' valign='top'>";
					echo "\n\t\t\t\t\t" . recreateUserInput($gbentry[6], $configFromINI['General']['delimiter']) . "\t\t\t\t</td>\n\t\t\t</tr>\n";
					$gbIsEmpty = "0";
				}
			}
		}
		echo "\t\t</table>\n";
	
		// if splitting the posts onto several pages, display navigation links
		if ($configFromINI['Behaviour']['entriesPerPage'] > 0)	{
			displayPostNavigation($numberofposts, $offset);
		}
	}


	///////////////////////////////////////////////////////////////////////
	//                         MAIN BODY OF THE SCRIPT                                 //
	///////////////////////////////////////////////////////////////////////



	///////////////////////////////////////////////////////////////////////
	// FIRST: Are we admin? This is needed for e.g. deleting and configuring.
	
	// checking if logging into admin mode, setting the appropriate PHP session variables
	if (isset($_POST["Login"]) && ($_POST["adminuser"] == $adminusername) && ($_POST["adminpass"] == $adminpassword))	{
		$adminmode = 1;
		session_register('adminmode');
		$_SESSION['adminmode'] = $adminmode;
	}

	// check if already in admin mode via PHP session
	if ((isset($_SESSION['adminmode'])) && ($_SESSION['adminmode'] == 1))	{
		$adminmode = 1;
	}



	///////////////////////////////////////////////////////////////////////
	// SECOND all the special cases: previewing, submitting, logging in as admin

	// previewing and submitting a post, checking if all fields required were filled in
	if ((isset($_POST["preview"])) || isset($_POST["submit"]))	{
		
		// set the strings
		$Nickname = safeHTML($_POST["NickName"]);
		$Emailaddress = safeHTML($_POST["EmailAddress"]);
		$messageString = safeHTML($_POST["Message"]);
		if (($_POST["Homepage"] == "http://") || ($_POST["Homepage"]) == "")	{
			$Homepage = "";
		}
		else	{
			$Homepage = safeHTML($_POST["Homepage"]);
		}
		
		// getting the time the post was submitted
		if ($configFromINI['Behaviour']['timeNotation'] == "american")	{
			$currentTime = date("g:i:s a");
			$currentDate = date("m-d-Y");
		}
		elseif ($configFromINI['Behaviour']['timeNotation'] == "german")	{
			$currentTime = date("H:i:s");
			$currentDate = date("d.m.Y");
		}
		else	{
			// falling back to ISO norm
			$currentTime = date("H:i:s");
			$currentDate = date("Y-m-d");
		}
		
		// omitted both required fields
		if (($Nickname == "") && ($messageString == ""))	{
			$forgotten = "both";
		}
		// omitted one of the 2 required fields
		elseif (($Nickname == "") || ($messageString == ""))	{
			if ($Nickname == "")	{
				$forgotten =  "nickname";
			}
			elseif ($messageString == "")	{
				$forgotten =   "message";
			}
		}
		elseif (($Nickname != "") && ($messageString != ""))	{
			$forgotten =  "";
		}

		if ((isset($_POST["submit"]) && ($forgotten != "")) || (isset($_POST["preview"])))	{
			// displaying the single entry with the new data
			displayHTMLHeader();
			if ($forgotten != "")	{
				echo "\t\t<h1>" . $configFromINI['General']['gbName'] ." - ". $languageStrings['IncompletePost'] . "</h1>";
			}
			if ($forgotten == "")	{
				echo "\t\t<h1>" . $configFromINI['General']['gbName'] ." - ". $languageStrings['PreviewPost'] . "</h1>";
				echo "\t\t<table class='gbdisplay' cellpadding='0' cellspacing='0'>\n";
				echo "\t\t\t<tr class='layouttr'>\n\t\t\t\t<td class='posttopleft' valign='top'>";
				echo "\n\t\t\t\t\t<span class='emphasis'>0. " . $Nickname . "</span>\n\t\t\t\t</td>\n";
				echo "\t\t\t\t<td class='posttopright'  valign='top'>\n\t\t\t\t\t<span class='emphasis'>" . $currentDate . ", " . $currentTime . "</span>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n";
				echo "\t\t\t<tr>\n\t\t\t\t<td class='postbottomleft'  valign='top'>";
				if ($Emailaddress != "")	{
					echo " <a href='mailto:" . $Emailaddress . "'><img src='" . $configFromINI['Files']['emailIcon'] . "' alt='email' border=''></a>&nbsp;";
					if ($Homepage == "")	{
						echo "\n\t\t\t\t<br>";
					}
				}
				if ($Homepage != "")	{
					if (!(preg_match("/^http:\/\//", $Homepage)))
						{$currentHomepage = "http://" . $Homepage;}
						echo "<a href='" . $currentHomepage . "'><img src='" . $configFromINI['Files']['homepageIcon'] . "' alt='homepage' border='0'></a><br>";
				}
				echo "</td>\n\t\t\t\t<td class='postbottomright' valign='top'>";
				echo "\n\t\t\t\t\t" . recreateUserInput($messageString, $configFromINI['General']['delimiter']) . "\t\t\t\t</td>\n\t\t\t</tr>\n";
				echo "\t\t</table>\n\t\t<p>&nbsp;</p>\n";
			}
			// displaying the form fields with the data inserted, too
			echo "\t\t<div class='gbinput'>\n\t\t\t";
			displayInputForm($Nickname, $Emailaddress, $Homepage, $forgotten);
			echo "\n\t\t</div>";
		}
		// new post is being submitted and nothing was omitted
		elseif (isset($_POST["submit"]) && ($forgotten == ""))	{
			// IP address: real unless trackUserIP is set to 0, then "0.0.0.0"
			if ($configFromINI['Behaviour']['trackUserIP'] == 1)	{
				$userIP = $_SERVER['REMOTE_ADDR'];
			}
			else	{
				$userIP = "0.0.0.0";
			}
			$newguestbookline = $Nickname.$configFromINI['General']['delimiter'].$Emailaddress.$configFromINI['General']['delimiter'].$Homepage.$configFromINI['General']['delimiter'].$currentDate.$configFromINI['General']['delimiter'].$currentTime.$configFromINI['General']['delimiter'].$userIP.$configFromINI['General']['delimiter'].$messageString."\n";

			// adding the stuff to the guestbook file (simply adding a new line at the end due to design of the data structure)
			$bookInputStream = fopen($configFromINI['Files']['guestbookFile'], "a");
			fwrite($bookInputStream, $newguestbookline);
			fclose($bookInputStream);
			
			// email notification
			// if run on a Windows server or else desired, override SMTP setting from php.ini
			if ($configFromINI['Email']['sendEmail'] == "1")	{
				if ((strpos(PHP_OS, "WIN") >= 0)	|| ($configFromINI['Email']['overrideLocalhost'] == "1"))	{
					ini_set("SMTP", $configFromINI['Email']['SMTP']);
					ini_set("sendmail_from", $configFromINI['Email']['fromAddress']);
				}
				mail($configFromINI['Email']['toAddress'], "flatPHPbook: ".$languageStrings['NewPost'], $Nickname.$languageStrings['EmailNewPost'], "From: ".$configFromINI['Email']['fromAddress']."\r\nX-Mailer: PHP/".phpversion());
			}
			
			header( 'refresh: ' . $configFromINI['Behaviour']['refreshWaitingTime'] . '; url= '. $_SERVER["PHP_SELF"] );
			displayHTMLHeader();
			echo "\t\t<h1>" . $configFromINI['General']['gbName'] . "</h1>\n";
			echo "\t\t<div class='gbinput'>\n";
			echo "\t\t\t<p>".$languageStrings['ThanksForPosting']."</p>\n";
			echo "\t\t\t<p>" . $languageStrings['YouWillBeTaken1'] . $configFromINI['Behaviour']['refreshWaitingTime'] . $languageStrings['YouWillBeTaken2'] . "</p>\n";
			echo "\t\t\t<a href='" . $_SERVER["PHP_SELF"] . "'>" . $languageStrings['ClickInsteadOfWaiting'] . "</a>\n\t\t</div>";
		}
		displayHTMLFooter();
		die;
	}


	// DELETING an entry
	if (isset($_POST["delete"]) && ($adminmode == "1"))	{
		// obviously, a post is to be deleted

		// need to load the database file, build an array, remove the corresponding field, and write the array back to the database file
		$content = file($configFromINI['Files']['guestbookFile']);
		$posttobedeleted = count($content) - $_POST["whichpost"] - 1;
		$gbentry = split($configFromINI['General']['delimiter'], $content[$posttobedeleted]);	// preparing the double-checking: need to read the posttime filed from the database later on
		
		// double-checking: the post number and time the post was made have to be correct
		// if someone posts between clicking the delete button and the reloading of the page
		// the post numbers are screwed - in that case, nothing will be deleted
		if ($_POST["posttime"] == $gbentry[4])	{
			// now, $content is our array, need to remove the appropriate one
			$index_nb_elements = count($content) - 1;
			switch($posttobedeleted)
			{
				case 0:
					$content = array_slice($content, 1);
					break;
				case $index_nb_elements:
					$content = array_slice($content, 0, -1);
					break;
				default:
					$array_start = array_slice($content, 0, $posttobedeleted);
					$array_end = array_slice($content, $posttobedeleted + 1);
					$content = array_merge ($array_start, $array_end);
					break;
			}

			// writing the new array back
			$bookInputStream = fopen($configFromINI['Files']['guestbookFile'], "w");
			fseek($bookInputStream, 0);
			// $content = implode("\r\n", $content);
			foreach ($content as $gbline)	{
				fwrite($bookInputStream, trim($gbline) . "\n"); }
			fclose($bookInputStream);
		}
	}
	
	// the admin mode login, displaying a form field for entering username and passwort,
	// then directing the user to the admin mode guestbook
	if (isset($_GET["adminlogin"]))
	{
		displayHTMLHeader();
		echo "\t\t<h1>" . $configFromINI['General']['gbName']." ".$languageStrings['AdminTitle']."</h1>\n";
		echo "\t\t<div class='gbinput'>\n";
		echo "\t\t\t<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>\n";
		echo "\t\t\t\t<table>\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>".$languageStrings['AdminUserName'].":</td>\n\t\t\t\t\t\t<td><input type='text' name='adminuser'></td>\n\t\t\t\t\t</tr>\n";
		echo "\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>".$languageStrings['AdminPassword'].":</td>\n\t\t\t\t\t\t<td><input type='password' name='adminpass'></td>\n\t\t\t\t\t</tr>\n";
		echo "\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>\n\n\t\t\t\t\t\t\t<input type='submit' name='Login' value='".$languageStrings['AdminLogin']."'/>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n";
		echo "\t\t\t</form>\n\t\t</div>\n";
		displayHTMLFooter();
		die();
	}
	
	// THEN the regular display of the guestbook, even if some special conditions get checked first
	
	// checking if logging into admin mode, setting the appropriate PHP session variables
	if (isset($_POST["Login"]) && ($_POST["adminuser"] == $adminusername) && ($_POST["adminpass"] == $adminpassword))	{
		$adminmode = 1;
		session_register('adminmode');
		$_SESSION['adminmode'] = $adminmode;
	}

	// check if already in admin mode via PHP session
	if ((isset($_SESSION['adminmode'])) && ($_SESSION['adminmode'] == 1))	{
		$adminmode = 1;
	}
	
	// logging out of admin mode and destroying the associated PHP session
	if (isset($_GET["logout"]))	{
		session_unset();
		session_destroy();
		$adminmode = 0;
	}

	// CONFIGURATION - displaying the page with the web interface for editing the INI values 
	if ((isset($_GET["configure"])) && ($adminmode = "1"))	{
		displayHTMLHeader();
		echo "\t\t<h1>".$configFromINI['General']['gbName']." - ".$languageStrings['ConfigurationPage']."</h1>\n\t\t\t<div class='gbinput'>\n"; 
		echo "\t\t\t\t<form method='POST' action='".$_SERVER['PHP_SELF']."'>\n\t\t\t\t\t<table>";
		foreach ($configFromINI as $section => $sectionContents)	{
			echo "\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<td colspan='2'><b>$section:</b></td>\n\t\t\t\t\t\t</tr>";
			foreach ($sectionContents as $key => $value)	{
				if ($key == "version")	{
					echo "\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<td>".$key.":</td>\n\t\t\t\t\t\t\t<td><input style='background-color: #f0f0f0; color: #606060;' type='text' name='".$key."' value='".$value."' readonly='readonly' /></td>\n\t\t\t\t\t\t</tr>";
				}
				else
				{
					echo "\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<td>".$key.":</td>\n\t\t\t\t\t\t\t<td><input type='text' name='".$key."' value='".$value."' /></td>\n\t\t\t\t\t\t</tr>";
				}
			}
		}
		echo "\n\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t<td colspan='2'><input type='submit' name='saveChangesINI' value='".$languageStrings['SaveChanges']."' />&nbsp;";
		echo "<input type='submit' name='cancel' value='".$languageStrings['Cancel']."' />\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t</tr>\n\t\t\t\t\t</table>\n\t\t\t\t</form>\n\t\t\t</div>\n";
		displayHTMLFooter();
		die;
	}
	
	// CONFIGURATION - saves the changes to the INI made via the web interface
	if ((isset($_POST['saveChangesINI'])) && ($_POST['saveChangesINI']) && ($adminmode = "1"))	{
		//empty new string that will become the content of the new INI file
		$newINI = "";
		// loop over all lines in the INI file, requires double loop because it is a nested array
		foreach ($configFromINI as $section => $sectionContents)	{
			if ($newINI != "")	{
				$newINI .= "\n";
			}
			$newINI .= "[".$section."]\n";
			foreach ($sectionContents as $INIkey => $INIvalue)	{
				// loop over all submitted POST variables
				foreach ($_POST as $postKey => $postValue) {
					if (strstr($INIkey, $postKey))	{
						$newINI .= $INIkey." = ".$postValue."\n";
					}
				}
			}
		}
		$INIoutputStream = fopen($INIfileName, "w");
		fwrite($INIoutputStream, $newINI);
		fclose($INIoutputStream);
		// these next to have to be re-set since the INI was just saved with new values
		$configFromINI = parse_ini_file($INIfileName, true);
		$languageStrings = parse_ini_file($configFromINI['Files']['languageFile']);
		header( 'refresh: ' . $configFromINI['Behaviour']['refreshWaitingTime'] . '; url= '. $_SERVER["PHP_SELF"] );
		displayHTMLHeader();
		echo "\t\t<div class='gbinput'>\n";
		echo "\t\t\t<p>".$languageStrings['SavedSuccessfully']."</p>\n";
		echo "\t\t\t<p>" . $languageStrings['YouWillBeTaken1'] . $configFromINI['Behaviour']['refreshWaitingTime'] . $languageStrings['YouWillBeTaken2'] . "</p>\n";
		echo "\t\t\t<a href='" . $_SERVER["PHP_SELF"] . "'>" . $languageStrings['ClickInsteadOfWaiting'] . "</a>\n\t\t</div>";
		displayHTMLFooter();
		die;
	}
	
	// beginning the regular guestbok display
	displayHTMLHeader();
	
	echo "\t\t<h1>".$configFromINI['General']['gbName']." ".$languageStrings['MainPage']."</h1>\n\n";
	echo "\t\t<!-- html input form for guestbook -->\n\t\t<div class='gbinput'>";
	
	// this includes the content of welcomeMessage.html as if it was here in this file
	// this is useful for having your own welcome message
	if (is_file("./welcomeMessage.html")){
		include_once("./welcomeMessage.html");
	}
	
	// all the "if ((separateViewFromSign == 1) ... etc make sure the right parts are displayed according to the mode:
	// either everything on one page, but no links, or either the form fields or the old entries together with navigation links ("Click to view" or "Click to sign").
	if (($configFromINI['Behaviour']['separateViewFromSign'] == 1) && !isset($_GET['signgb']))	{
		echo "<p align='center'><a href='" . $_SERVER['PHP_SELF'] . "?signgb=1'>".$languageStrings['ClickHereToSign']."</a></p>";
	}
	else	{
		echo "<hr width='80%'>";
	}
	
	// calling the function which displays the long form with the input text fields and buttons
	// parameters are empty here, they are used for the preview page so that the fields can be filled with already submitted values
	if ((($configFromINI['Behaviour']['separateViewFromSign'] == 1) && isset($_GET['signgb']) && ($_GET['signgb'] == 1)) || ($configFromINI['Behaviour']['separateViewFromSign'] == 0))
	{
		displayInputForm("", "", "", "");
		if (!($configFromINI['Behaviour']['separateViewFromSign'] == 0))	{
			echo "<p align='center'><a href='" . $_SERVER['PHP_SELF'] . "'>".$languageStrings['ClickHereToView']."</a></p>";
		}
	}
	echo "\n\t\t</div>\n";
	
	if ($adminmode == "1")	{
		echo "\n\t\t<!-- this is the link that opens the configuration page -->\n";
		echo "\t\t<div class='gbinput'>\n\t\t\t<p align='center'>\n\t\t\t\t<span class='emphasis'><a href='".$_SERVER['PHP_SELF']."?configure'>".$languageStrings['ClickToEditConfig']."</a></span>\n\t\t\t</p>\n\t\t</div>\n";
	}
	
	if ((($configFromINI['Behaviour']['separateViewFromSign'] == 1) && !isset($_GET['signgb'])) || ($configFromINI['Behaviour']['separateViewFromSign'] == 0))	{
		displayGuestbook();
	}
	
	displayAdminLinks();
	displayHTMLFooter();
?>