/*
 * Decompiled with CFR 0.152.
 */
package setsuna.core.util;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import setsuna.core.util.EngineJoinQueueFolder;

public class AdapterJoinQueueMapper {
    private static final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private static final Lock r = rwl.readLock();
    private static final Lock w = rwl.writeLock();
    private static Map mappingInfomationMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createMappingInfomation(String adapterName) {
        w.lock();
        try {
            if (!mappingInfomationMap.containsKey(adapterName)) {
                mappingInfomationMap.put(adapterName, new CopyOnWriteArrayList());
            }
        }
        finally {
            w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMappingInfomation(String adapterName, String queryName) {
        w.lock();
        try {
            if (!mappingInfomationMap.containsKey(adapterName)) {
                CopyOnWriteArrayList<String> queryNameList = new CopyOnWriteArrayList<String>();
                queryNameList.add(queryName);
                mappingInfomationMap.put(adapterName, queryNameList);
            } else {
                AdapterJoinQueueMapper.executeRemoveMappingInfo(adapterName, queryName);
                List queryNameList = (List)mappingInfomationMap.get(adapterName);
                queryNameList.add(queryName);
            }
        }
        finally {
            w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMappingInfomation(String adapterName, String queryName) {
        w.lock();
        try {
            AdapterJoinQueueMapper.executeRemoveMappingInfo(adapterName, queryName);
        }
        finally {
            w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMappingAdapter(String adapterName, String queryName) {
        w.lock();
        try {
            mappingInfomationMap.remove(adapterName);
        }
        finally {
            w.unlock();
        }
    }

    private static void executeRemoveMappingInfo(String adapterName, String queryName) {
        if (mappingInfomationMap.containsKey(adapterName)) {
            List queryNameList = (List)mappingInfomationMap.get(adapterName);
            int removePoint = -1;
            for (int idx = 0; idx < queryNameList.size(); ++idx) {
                String name = (String)queryNameList.get(idx);
                if (!name.equals(queryName)) continue;
                removePoint = idx;
            }
            if (removePoint != -1) {
                queryNameList.remove(removePoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mappingAdapterData(String adapterName, Map data) {
        r.lock();
        try {
            if (mappingInfomationMap.containsKey(adapterName)) {
                List queryNameList = (List)mappingInfomationMap.get(adapterName);
                int removePoint = -1;
                for (int idx = 0; idx < queryNameList.size(); ++idx) {
                    String name = (String)queryNameList.get(idx);
                    EngineJoinQueueFolder.putAapterOutputQueue(name, data);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            r.unlock();
        }
    }

    static {
        mappingInfomationMap = new ConcurrentHashMap(1000, 800.0f, 128);
    }
}

