'------------------------------
'  TreeView & ListView Sample
'------------------------------
Option Explicit 
dim obj,tree,listview

set obj = CreateObject("SeraphyScriptTools.Instance")
WScript.ConnectObject obj.mainframe,"event_"

obj.mainframe.SetPlacement ,,500,500
with obj.mainframe.form
	.label "TreeView",10
	.Label("ListView",10).SetPlacement 250
	set tree = .treeview(15,10).SetID(40)
	set listview = .listview("ږ :ԍ ",,10).SetID(41).SetPlacement(250)
	.ControlPad ,5
	.button("ADD",4).SetID(50)
	.button("Delete",5).SetID(54).SetPlacement 400
	.button("EXPAND",4).SetID(51)
	.ControlBreak
	.button("SHOW",4).SetID(52)
	.button("Delete",4).SetID(53)
	.Button("EXIT",5).SetID(1).SetPlacement 400
end with

' !!ACeɂ̓EBhE쐬ĂȂ΂ȂȂ!!
obj.mainframe.setwindowstyle(0,2,0).setplacement(,,,300).open("TreeView & ListView TEST").BackColor = "&HC0C0C0"
tree.addString "HELLO1"
tree.addString "HELLO2"
with tree.addString("HELLO3")
	.Create "CHILD1"
	.Create "CHILD2"
	.Create "CHILD3"
end with

obj.mainframe.domodal

'--------------
'   nh
'--------------
sub event_OnCommand
	dim ev
	set ev = obj.mainframe.event
	if    ( ev.parameter = 50) then   ' <= ADD
		call AddItem
	elseif( ev.parameter = 51) then   ' <= EXPAND
		call Expand
	elseif( ev.parameter = 52) then   ' <= SHOW
		call ShowItem
	elseif( ev.parameter = 53) then   ' <= DELETE(TREEVIEW)
		call DeleteTreeItem
	elseif( ev.parameter = 54) then   ' <= DELETE(LISTVIEW)
		call DeleteListItem
	elseif( ev.parameter = 40) then   ' <= TREEVIEW
		call SelectItem
	else
		obj.dialog.messagebox "R}hԍ=" & ev.parameter
	end if
end sub

'-------------
dim iteminsertcount
sub AddItem
	' c[r[ɃACeǉ
	dim arr
	arr = obj.dialog.MultiOpenFileDialog
	if(isArray(arr)) then
		dim x,itm
		if(isObject(tree.CurrentSelectedItem)) then
			set itm = tree.CurrentSelectedItem
			for each x in arr
				iteminsertcount = iteminsertcount + 1
				with itm.Create(x)
					.Object.Value("Number") = iteminsertcount
					.Select
				end with
			next
		else
			' [gɒǉ
			for each x in arr
				iteminsertcount = iteminsertcount + 1
				tree.addString(x).Object.Value("Number") = iteminsertcount
			next
		end if
	end if
end sub

sub Expand
	if(isObject(tree.CurrentSelectedItem)) then
		tree.CurrentSelectedItem.Expand
	end if
end sub

sub ShowItem
	if(isObject(tree.CurrentSelectedItem)) then
		obj.dialog.messagebox "̃ACe" & tree.CurrentSelectedItem.object.Value("Number") & "Ԗڂɑ}܂B"
	end if
end sub

sub DeleteTreeItem
	if(isObject(tree.CurrentSelectedItem)) then
		tree.CurrentSelectedItem.Erase
	end if
end sub

sub DeleteListItem
	dim x
	if(listview.selectedcount > 0) then
		' IACe̗񋓂̓XibvVbgȂ̂
		' 񋓒ɃACěƃXibvVbg͖ɂȂ
		listview.DeleteSelectedItem
	else
		obj.dialog.messagebox "I܂",0,1
	end if
end sub

sub SelectItem
	if(isObject(tree.CurrentSelectedItem)) then
		dim itm,idx,count
		set itm = tree.CurrentSelectedItem
		idx = listview.addstring(itm.text)
		with listview
			count = tree.CurrentSelectedItem.object.Value("Number")
			.setcolumntext idx,1,count
			with .itemobject(idx)
				' AzzSORT??ƂL[쐬ƃXgr[̓\[gs
				.value("SORT0") = itm.text
				.value("SORT1") = int(count)
			end with
		end with
	end if
end sub

sub event_OnContextMenu
	dim ev,cmd
	set ev = obj.mainframe.event
	if(ev.parameter = 41) then
		cmd = obj.mainframe.trackpopupmenu("ACe폜")
		if(cmd = 1)then
			call DeleteListItem
		end if
	elseif(ev.parameter = 40) then
		cmd = obj.mainframe.trackpopupmenu("ACe폜,JEg\")
		if(cmd = 1) then
			call DeleteTreeItem
		elseif(cmd = 2) then
			call ShowItem
		end if
	end if
end sub
