#!/usr/bin/env ruby
# Copyright(C) 2008 Brazil
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of
# the GNU General Public License version 2.

# grep all of memory functions and
# set SEN_FMALLOC_LINE/SEN_FMALLOC_LINE and
# execute all_test.rbx and
# handle SIGSEGV

# SCRIPT_NAME = 'run-test.sh'
SCRIPT_NAME = 'all_test.rbx'

require 'pp' # for debug

MEMORY_FUNCS = %w|
SEN_MMAP
SEN_MALLOC
SEN_CALLOC
SEN_REALLOC
SEN_STRDUP
SEN_GMALLOC
SEN_GCALLOC
SEN_GREALLOC
SEN_GSTRDUP
SEN_MALLOCN
SEN_GMALLOCN
SEN_CTX_ALLOC
SEN_CTX_ALLOC_L
STR2DBL
SEN_ARRAY_AT
DO_MAP
LEX_TOKEN
SEN_ARRAY_NEXT
SEG_MAP
SEN_SET_INT_ADD
SEN_IO_SEG_MAP
USE_SEG_MAP
|

DEFINE_REGEX = /\A\s*\#define\s+([_A-Za-z0-9]+)/
MEMORY_FUNC_REGEX = /#{MEMORY_FUNCS.join('|')}/

envary = []

Dir::glob('../../../lib/*.[c|h]').each {|f|
  source = File::basename(f)
  open(f) {|file|
    lcnt = 0
    macro_name = nil
    while l = file.gets
      lcnt += 1
      if DEFINE_REGEX.match(l)
        macro_name = $1
      end
      if macro_name
        if MEMORY_FUNC_REGEX.match(l)
          unless MEMORY_FUNCS.index(macro_name)
            # if macro calls memory function,
            # it should be added to MEMORY_FUNCS.
            puts "* add #{macro_name} in MEMORY_FUNCS !!!"
          end
        end
        macro_name = nil unless l[-2, 1] == '\\'
      elsif MEMORY_FUNC_REGEX.match(l)
        envary << [source, lcnt.to_s]
      end
    end
  }
}

open('fmalloc_test.sh', 'w+', 0755) {|f|
  # write test script
  f.puts "#!/bin/sh"
  envary.each {|e|
    f.puts "echo \"file: #{e[0]} line: #{e[1]}\""
    f.puts "SEN_FMALLOC_FILE=#{e[0]} SEN_FMALLOC_LINE=#{e[1]} SEN_FMALLOC_PROB=1 ./#{SCRIPT_NAME}"
  }
}
