/* Copyright(C) 2004 Brazil

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "senna_in.h"
#include <stdio.h>
#include "senna.h"

#include "set.h"

int
main(int argc, char **argv)
{
  char buf[0x100000];
  int score;
  sen_index *i;
  sen_query *q;
  sen_records *r;
  const char *rest;
  if (argc < 2) {
    fputs("usage: qtest indexname\n", stderr);
    return -1;
  }
  sen_init();
  if (!(i = sen_index_open(argv[1]))) {
    fprintf(stderr, "index open failed (%s)\n", argv[1]);
    return -1;
  }
  while (!feof(stdin) && fgets(buf, 0x100000, stdin)) {
    r = sen_records_open(sen_rec_document, sen_rec_none, 0);
    q = sen_query_open(buf, sen_sel_and, 10, sen_enc_euc_jp);
    rest = sen_query_rest(q);
    if (*rest) { printf("too long query rest.. \"%s\"\n", rest); }
    sen_query_exec(i, q, r, sen_sel_or);
    sen_query_close(q);
    printf("%d hits\n", sen_records_nhits(r));
    sen_records_sort(r, 10, NULL);
    while (sen_records_next(r, buf, 0x100000, &score)) {
      printf("%s: %d\n", buf, score);
    }
    sen_records_close(r);
  }
  return 0;
}
