/* Copyright(C) 2004 Brazil

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include "sym.h"

extern void sen_sym_inspect(sen_sym *sym);

#define NUL		'\0'
#define NL		'\n'

unsigned char buffer[65536];
unsigned char symbuf[8192];

void
doit(int argc, char **argv)
{
  int value;
  int i;
  sen_sym *sym;
  unsigned char *p, *p2;
  FILE *fp;
  char *filename;

  filename = argv[3];

  if (!(sym = sen_sym_open(filename))) {
    sym = sen_sym_create(filename, 0, SEN_SYM_WITH_SIS, sen_enc_euc_jp);
    // sym = sen_sym_create(filename, 0, 0);
  }
  if (!sym) {
    puts("error...");
    return;
  }

  // sen_sym_inspect(sym);

  if (strcmp(argv[1], "get")) {
    fp = fopen(argv[2], "r");
    i = 1;
    while ((p = fgets(buffer, 65535, fp))) {
      for (p2 = p; *p2 && *p2 != NL; p2++);
      *p2 = NUL;
      value = sen_sym_get(sym, p);
      if (i != value) {
	//	printf("put: %s: %d!=%d\n", p, i, value);
      }
      i++;
    }
    fclose(fp);
  }

   sen_sym_inspect(sym);


  if (strcmp(argv[1], "put")) {
    fp = fopen(argv[2], "r");
    i = 1;
    while ((p = fgets(buffer, 65535, fp))) {
      for (p2 = p; *p2 && *p2 != NL; p2++);
      *p2 = NUL;
      value = sen_sym_at(sym, p);
      if (i++ != value) {
	/*
	  sen_sym_key(sym, value, symbuf, 8192);
	  printf("get: %s: %s\n", p, symbuf);
	*/
      }
    }
    fclose(fp);
  }

  return ;

  /*

  {
    sprintf(buffer, "/proc/%d/status", getpid());
    fp = fopen(buffer, "r");
    buffer[fread(buffer, 1, 65536, fp)] = NUL;
    puts(buffer);
    fclose(fp);
  }

  sen_sym_inspect(sym);

  */
  {
    int n = sen_sym_size(sym);
    // printf("nrec=%d\n", n);
    //    sen_sym_dump(sym, 20);
    for (i = 1; i <= n; i++) {
      sen_sym_key(sym, value, symbuf, 8192);
      sen_sym_del(sym, symbuf);
      /*
      if (!(i % 10000)) {
	printf("deleting(%d) %s->%d\n", i, key, sen_sym_at(sym, key));
	sen_sym_inspect(sym);
	sen_sym_dump(sym, 10);
      }
      */
      if (i + sen_sym_size(sym) != n) {
	printf("oho!!, i=%d, s=%d, n=%d\n", i, sen_sym_size(sym), n);
	return;
      }
    }

    return;


    printf("deleted all records. i=%d, nrec=%d, nrec0=%d\n", i, sen_sym_size(sym), n);
    for (i = 1; i < n; i++) {
      sen_sym_key(sym, value, symbuf, 8192);
      if (sen_sym_at(sym, symbuf)) {
	printf("%s->%d\n", symbuf, sen_sym_at(sym, symbuf));
      }
    }

    sen_sym_inspect(sym);
    puts("checked..");
    fp = fopen(argv[2], "r");
    i = 1;
    while ((p = fgets(buffer, 65535, fp))) {
      for (p2 = p; *p2 && *p2 != NL; p2++);
      *p2 = NUL;
      value = sen_sym_get(sym, p);
      if (i + n != value) {
	//	printf("%s: %d\n", p, value);
      }
      i++;
    }
    fclose(fp);

    fp = fopen(argv[2], "r");
    i = 1;
    while ((p = fgets(buffer, 65535, fp))) {
      for (p2 = p; *p2 && *p2 != NL; p2++);
      *p2 = NUL;
      value = sen_sym_at(sym, p);
      if (n + i++ != value) {
	/*
	  sen_sym_key(sym, value, symbuf, 8192);
	  printf("%s: %s\n", p, symbuf);
	*/
      }
    }
    fclose(fp);
    printf("registered again.. i=%d, nrec=%d, nrec0=%d\n", i, sen_sym_size(sym), n);

  }
  sen_sym_inspect(sym);
  sen_sym_close(sym);
}

int
main(int argc, char **argv)
{
  if (argc < 4) {
    puts("Usage: ttest get|put|whole datafile symfilename");
    return 1;
  }
  doit(argc, argv);
  return 0;
}
