/* Copyright(C) 2004 Brazil

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "str.h"
#include "set.h"

#define NUL		'\0'
#define NL		'\n'

unsigned char buffer[65536];

int
do_set(int argc, char **argv)
{
  int i, *v;
  FILE *fp;
  unsigned char *p, *p2;

  sen_set *set = sen_set_open(0, sizeof(int), 0);

  fp = fopen(argv[3], "r");
  for (i = 0; (p = fgets(buffer, 65535, fp)); i++) {
    for (p2 = p; *p2 && *p2 != NL; p2++);
    *p2 = NUL;
    sen_set_get(set, p, (void *)&v);
    *v = i;
  }
  fclose(fp);

  if (*argv[2] != 'p') {
    fp = fopen(argv[3], "r");
    for (i = 0; (p = fgets(buffer, 65535, fp)); i++) {
      for (p2 = p; *p2 && *p2 != NL; p2++);
      *p2 = NUL;
      if (!sen_set_at(set, p, (void *)&v)) {
	printf("%s: not found\n", p);
      }
      if (*v != i) {
	printf("%s: %d != %d\n", p, *v, i);
      }
    }
    fclose(fp);
  }

  if (*argv[2] == 'f') {
    int j;
    for (j = 0; j < 100; j++) {
      sen_set_cursor *c = sen_set_cursor_open(set);
      for (i = 0; sen_set_cursor_next(c, (void *)&p, (void *)&v); i++);
      sen_set_cursor_close(c);
    }
  }

  {
    sprintf(buffer, "/proc/%d/status", getpid());
    fp = fopen(buffer, "r");
    buffer[fread(buffer, 1, 65536, fp)] = NUL;
    puts(buffer);
    fclose(fp);
  }

  return 0;

  sen_set_close(set);
}

int
sort_set(int argc, char **argv)
{
  unsigned int i, j, k, *v;
  FILE *fp;
  unsigned char *p, *p2;
  sen_set_eh *sorted;
  sen_set *set = sen_set_open(sizeof(int), sizeof(int), 0);
  fp = fopen(argv[2], "r");
  for (i = 0; (p = fgets(buffer, 65535, fp)); i++) {
    for (p2 = p; *p2 && *p2 != NL; p2++);
    *p2 = NUL;
    k = atoi(p);
    sen_set_get(set, &k, (void *)&v);
    *v = i;
  }
  fclose(fp);
  sen_log("sort start");
  sorted = sen_set_sort(set, 0, NULL);
  sen_log("sort end");
  for (i = 0, k = 0; i < set->n_entries; i++, k = j) {
    j = *(((int **)sorted)[i]);
    if (k > j) { sen_log("zid=%d %d", j, k - j); }
  }
  return 0;
}

#include <stdlib.h>

int compar(const void *a, const void *b)
{
  return *((int *)a) - *((int *)b);
}

int
qsort_test(int argc, char **argv)
{
  char *p;
  char buffer[65536];
  int array[65536];
  int max = 0, i, j, k;
  FILE *fp = fopen(argv[2], "r");
  while (!feof(fp)) {
    p = fgets(buffer, 100, fp);
    if (p) {
      array[max++] = atoi(p);
    }
  }
  sen_log("qsort start");
  qsort(array, max, sizeof(int), compar);
  sen_log("qsort end");
  for (i = 0, k = 0; i < max; i++, k = j) {
    j = array[i];
    if (k > j ) { sen_log("id=%d %d", j, k -j); }
  }
  return max;
}

int
main(int argc, char **argv)
{
  switch (*argv[1]) {
  case 'h' :
    return do_set(argc, argv);
    break;
  case 's' :
    return sort_set(argc, argv);
    break;
  case 'q' :
    return qsort_test(argc, argv);
    break;
  }
  return 1;
}
