/* Copyright(C) 2004 Brazil

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
//#include <sys/param.h>

#ifndef _SEN_SYM_H
#define _SEN_SYM_H

#ifndef _SENNA_IN_H
#include "senna_in.h"
#endif /* _SENNA_IN_H */

#ifndef _SEN_SET_H
#include "set.h"
#endif /* _SEN_SET_H */

#ifndef _SEN_STR_H
#include "str.h"
#endif /* _SEN_STR_H */

#ifndef _SEN_IO_H
#include "io.h"
#endif /* _SEN_IO_H */

#ifdef	__cplusplus
extern "C" {
#endif

  /* SEN_SYM_SEGMENT_SIZE * SEN_SYM_MAX_SEGMENT == 0x100000000 */
#define SEN_SYM_MAX_SEGMENT 0x400

  /* sizeof(pat_node) * (SEN_SYM_MAX_ID + 1) == 0x100000000 */
#define SEN_SYM_MAX_ID 0xfffffff

#define SEN_SYM_MAX_KEY_LENGTH 0xffff
  /* must be 2 ^ n */
#define SEN_SYM_NDELINFOS 0x100
#define SEN_SYM_MDELINFOS (SEN_SYM_NDELINFOS - 1)

typedef struct {
  /* stat : 2, ld : 30 */
  sen_id bitfield;
  sen_id d;
} syn_sym_delinfo;

struct sen_sym_header {
  char idstr[16];
  uint32_t flags;
  sen_encoding encoding;
  uint32_t key_size;
  uint32_t nrecords;
  uint32_t curr_rec;
  int32_t curr_key;
  int32_t curr_del;
  int32_t curr_del2;
  int32_t curr_del3;
  uint8_t segments[SEN_SYM_MAX_SEGMENT];
  syn_sym_delinfo delinfos[SEN_SYM_NDELINFOS];
  sen_id garbages[(SEN_SYM_MAX_KEY_LENGTH + 1) / 8];
};

struct _sen_sym {
  sen_io *io;
  struct sen_sym_header *header;
  uint32_t flags;
  sen_encoding encoding;
  uint32_t key_size;
  sen_io_seginfo keyarray[SEN_SYM_MAX_SEGMENT];
  sen_io_seginfo patarray[SEN_SYM_MAX_SEGMENT];
  sen_io_seginfo sisarray[SEN_SYM_MAX_SEGMENT];
};

const char *_sen_sym_key(sen_sym *sym, sen_id id);
sen_id sen_sym_del_with_sis(sen_sym *sym, sen_id id);

#ifdef __cplusplus
}
#endif

#endif /* _SEN_SYM_H */
