/*
 * Copyright(C) 2007 Jiro Nishiguchi <jiro@cpan.org>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package senna;

/**
 * Wrapper for sen_snip
 */
public class Snippet {

    private int ptr;

    /**
     * create new object by sen_snip_open().
     * 
     * @param encoding
     *            encoding
     * @param flags
     *            flags
     * @param width
     *            width
     * @param maxResults
     *            maxResults
     * @param defaultOpenTag
     *            defaultOpenTag
     * @param defaultCloseTag
     *            defaultCloseTag
     * @param mapping
     *            mapping
     * @throws SennaException
     */
    public Snippet(int encoding, int flags, int width, int maxResults,
            String defaultOpenTag, String defaultCloseTag, int mapping)
            throws SennaException {
        open(encoding, flags, width, maxResults, defaultOpenTag,
                defaultCloseTag, mapping);
    }

    private native void open(int encoding, int flags, int width,
            int max_results, String defaultopentag, String defaultclosetag,
            int mapping) throws SennaException;

    /**
     * call sen_snip_add_cond().
     * 
     * @param keyword
     *            keyword
     * @throws SennaException
     */
    public void addCond(String keyword) throws SennaException {
        addCond(keyword, null, null);
    }

    /**
     * call sen_snip_add_cond().
     * 
     * @param keyword
     *            keyword
     * @param openTag
     *            openTag
     * @throws SennaException
     */
    public void addCond(String keyword, String openTag) throws SennaException {
        addCond(keyword, openTag, null);
    }

    /**
     * call sen_snip_add_cond().
     * 
     * @param keyword
     *            keyword
     * @param openTag
     *            openTag
     * @param closeTag
     *            closeTag
     * @throws SennaException
     */
    public native void addCond(String keyword, String openTag, String closeTag)
            throws SennaException;

    /**
     * call sen_snip_exec().
     * 
     * @param string
     *            string
     * @return results
     */
    public native String[] exec(String string) throws SennaException;

    /**
     * call sen_snip_close().
     * 
     * @throws SennaException
     */
    public native void close() throws SennaException;
}
