/*
 * Copyright(C) 2007 Jiro Nishiguchi <jiro@cpan.org>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package senna;

/**
 * Senna Java Binding.
 */
public class Senna {

    static {
        System.loadLibrary("sennajava");
    }

    /** SEN_INDEX_NORMALIZE */
    public static final int SEN_INDEX_NORMALIZE = 0x0001;

    /** SEN_INDEX_SPLIT_ALPHA */
    public static final int SEN_INDEX_SPLIT_ALPHA = 0x0002;

    /** SEN_INDEX_SPLIT_DIGIT */
    public static final int SEN_INDEX_SPLIT_DIGIT = 0x0004;

    /** SEN_INDEX_SPLIT_SYMBOL */
    public static final int SEN_INDEX_SPLIT_SYMBOL = 0x0008;

    /** SEN_INDEX_MORPH_ANALYSE */
    public static final int SEN_INDEX_MORPH_ANALYSE = 0x0000;

    /** SEN_INDEX_NGRAM */
    public static final int SEN_INDEX_NGRAM = 0x0010;

    /** SEN_INDEX_DELIMITED */
    public static final int SEN_INDEX_DELIMITED = 0x0020;

    /** SEN_INDEX_ENABLE_SUFFIX_SEARCH */
    public static final int SEN_INDEX_ENABLE_SUFFIX_SEARCH = 0x0100;

    /** SEN_INDEX_DISABLE_SUFFIX_SEARCH */
    public static final int SEN_INDEX_DISABLE_SUFFIX_SEARCH = 0x0200;

    /** SEN_INDEX_WITH_STORE */
    public static final int SEN_INDEX_WITH_STORE = 0x1000;

    /** SEN_INDEX_WITH_VACUUM */
    public static final int SEN_INDEX_WITH_VACUUM = 0x8000;

    /** sen_enc_default */
    public static final int SEN_ENC_DEFAULT = 0;

    /** sen_enc_none */
    public static final int SEN_ENC_NONE = 1;

    /** sen_enc_eucjp */
    public static final int SEN_ENC_EUCJP = 2;

    /** sen_enc_utf8 */
    public static final int SEN_ENC_UTF8 = 3;

    /** sen_enc_sjis */
    public static final int SEN_ENC_SJIS = 4;

    /** sen_enc_latin1 */
    public static final int SEN_ENC_LATIN1 = 5;

    /** sen_enc_koi8r */
    public static final int SEN_ENC_KOI8R = 6;

    /**
     * call sen_init().
     * 
     * @throws SennaException
     */
    public static native void init() throws SennaException;

    /**
     * call sen_fin().
     * 
     * @throws SennaException
     */
    public static native void fin() throws SennaException;

}

