/*
 * Copyright(C) 2007 Jiro Nishiguchi <jiro@cpan.org>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "senna_java.h"

void
ThrowNewSennaException(JNIEnv *env, const char *msg, sen_rc rc)
{
    jclass e;
    jstring msg_str;
    jmethodID c;
    jobject t;
    e = (*env)->FindClass(env, "senna/SennaException");
    msg_str = (*env)->NewStringUTF(env, msg);
    if (rc) {
        c = (*env)->GetMethodID(env, e, "<init>", "(Ljava/lang/String;I)V");
        t = (*env)->NewObject(env, e, c, msg_str, (jint) rc);
    } else {
        c = (*env)->GetMethodID(env, e, "<init>", "(Ljava/lang/String;)V");
        t = (*env)->NewObject(env, e, c, msg_str);
    }
    (void) (*env)->Throw(env, t);
}

