/*
 * Copyright(C) 2007 Jiro Nishiguchi <jiro@cpan.org>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "senna_java.h"
#include "senna_Senna.h"

JNIEXPORT void JNICALL
Java_senna_Senna_init(JNIEnv *env, jclass clazz)
{
    sen_rc rc;
    rc = sen_init();
    if (rc != sen_success)
        ThrowNewSennaException(env, "Failed to call sen_init().", rc);
}

JNIEXPORT void JNICALL
Java_senna_Senna_fin(JNIEnv *env, jclass clazz)
{
    sen_rc rc;
    rc = sen_fin();
    if (rc != sen_success)
        ThrowNewSennaException(env, "Failed to call sen_fin().", rc);
}

