/*
 * Copyright(C) 2007 Jiro Nishiguchi <jiro@cpan.org>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "senna_java.h"
#include "senna_Index.h"

static sen_records *
this_sen_records(JNIEnv *env, jobject obj)
{
    jclass clazz;
    jfieldID id;
    clazz = (*env)->FindClass(env, "senna/Records");
    id = (*env)->GetFieldID(env, clazz, "ptr", "I");
    return (sen_records *) (*env)->GetIntField(env, obj, id);
}

JNIEXPORT jstring JNICALL
Java_senna_Records_next(JNIEnv *env, jobject obj)
{
    sen_records *records;
    char key[SEN_MAX_KEY_SIZE + 1];
    int key_size;
    records = this_sen_records(env, obj);
    key_size = sen_records_next(records, key, SEN_MAX_KEY_SIZE, 0);
    if (key_size == 0)
        return NULL;
    return (*env)->NewStringUTF(env, key);
}

JNIEXPORT void JNICALL
Java_senna_Records_close(JNIEnv *env, jobject obj)
{
    sen_records *records;
    sen_rc rc;
    records = this_sen_records(env, obj);
    rc = sen_records_close(records);
    if (rc != sen_success)
        ThrowNewSennaException(env, "Failed to call sen_records_close().", rc);
}

JNIEXPORT jint JNICALL
Java_senna_Records_currScore(JNIEnv *env, jobject obj)
{
    sen_records *records;
    records = this_sen_records(env, obj);
    return (jint) sen_records_curr_score(records);
}

JNIEXPORT jstring JNICALL
Java_senna_Records_currKey(JNIEnv *env, jobject obj)
{
    sen_records *records;
    char key[SEN_MAX_KEY_SIZE + 1];
    int key_size;
    records = this_sen_records(env, obj);
    key_size = sen_records_curr_key(records, key, SEN_MAX_KEY_SIZE);
    if (key_size == 0)
        return NULL;
    return (*env)->NewStringUTF(env, key);
}

JNIEXPORT void JNICALL
Java_senna_Records_rewind(JNIEnv *env, jobject obj)
{
    sen_records *records;
    sen_rc rc;
    records = this_sen_records(env, obj);
    rc = sen_records_rewind(records);
    if (rc != sen_success)
        ThrowNewSennaException(env, "Failed to call sen_records_rewind().", rc);
}

JNIEXPORT jint JNICALL
Java_senna_Records_nhits(JNIEnv *env, jobject obj)
{
    sen_records *records;
    records = this_sen_records(env, obj);
    return (jint) sen_records_nhits(records);
}

JNIEXPORT jint JNICALL
Java_senna_Records_find(JNIEnv *env, jobject obj, jstring find_str)
{
    sen_records *records;
    const char *find;
    int score;
    records = this_sen_records(env, obj);
    find = (*env)->GetStringUTFChars(env, find_str, NULL);
    score = sen_records_find(records, find);
    (*env)->ReleaseStringUTFChars(env, find_str, find);
    return score;
}

