/*
 * include/asm-sh/cpu-sh4/port.h
 *
 * Copyright (C) 1999 Niibe Yutaka
 * Copyright (C) 2003 Paul Mundt
 *               2005 Yutaro Ebihara
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 */
#ifndef __ASM_CPU_SH4_PORT_H
#define __ASM_CPU_SH4_PORT_H

#define PORT_INPUPA  0xFE400028
#define PORT_DMAPCR  0xFE40002C
#define PORT_SCIHZR  0xFE400030
#define PORT_IPSELR  0xFE400034
#define PORT_MODSELR 0xFE4000AC
#define PORT_GPIOIC  0xFF800048

#define PORT_PAPUPR  0xFE400080

#define PORT_PACR    0xfe400000
#define PORT_PBCR    0xfe400004
#define PORT_PCCR    0xfe400008
#define PORT_PDCR    0xfe40000c
#define PORT_PECR    0xfe400010
#define PORT_PFCR    0xfe400014
#define PORT_PGCR    0xfe400018
#define PORT_PHCR    0xfe40001c
#define PORT_PJCR    0xfe400020
#define PORT_PKCR    0xfe400024

#define PORT_PADR    0xfe400040       /* port A data register */
#define PORT_PBDR    0xfe400044       /* port B data register */
#define PORT_PCDR    0xfe400048       /* port C data register */
#define PORT_PDDR    0xfe40004c       /* port D data register */
#define PORT_PEDR    0xfe400050       /* port E data register */
#define PORT_PFDR    0xfe400054       /* port F data register */
#define PORT_PGDR    0xfe400058       /* port G data register */
#define PORT_PHDR    0xfe40005c       /* port H data register */
#define PORT_PJDR    0xfe400060       /* port J data register */
#define PORT_PKDR    0xfe400064       /* port K data register */

#define PMOD	(0)
#define POUT	(1)
#define PIN_	(2)
#define PINP	(3)
#define PORT_CONTROL(ADDRESS,P7,P6,P5,P4,P3,P2,P1,P0) \
                *((volatile unsigned short*)(ADDRESS)) = ((P7<<14) | (P6<<12) | (P5<<10) | (P4<<8) | \
                              (P3<<6)  | (P2<<4)  | (P1<<2)  | (P0))

#define PORT_CONTROL_BIT(ADDRESS, BIT, MOD) \
	do{		\
		unsigned short tmp,mask;						\
		mask = 3<< (BIT*2);								\
		tmp = *((volatile unsigned short*)(ADDRESS));	\
		tmp &= ~mask;									\
		tmp |= (MOD)<<(BIT*2);							\
		*((volatile unsigned short*)(ADDRESS)) = tmp;	\
	}while(0)

#endif /* __ASM_CPU_SH4_PORT_H */

