/*
 * Flash on CAT760/CAT709
 *
 * (C) 2006 Yutaro Ebihara
 *
 * GPL'd
 */

#include <linux/module.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <asm/io.h>
#include <linux/mtd/mtd.h>
#include <linux/mtd/map.h>
#include <linux/mtd/partitions.h>

#include <asm/cat/cat760.h>

static struct mtd_info *flash_mtd;
static struct mtd_info *sram_mtd;
static struct mtd_partition *parsed_parts;



struct map_info cat_flash_map = {
	.name		= "CAT FLASH",
	.size		= CAT_FLASH_SIZE,
	.bankwidth	= 2,
};

struct map_info cat_sram_map = {
	.name		= "CAT SRAM",
	.size		= 512*1024,
	.bankwidth	= 2,
};


static struct mtd_partition cat_partitions[] = {
	{
		.name	= "ipl",
		.offset	= 0,
		.size	= 0x10000,
	},
	{
		.name	= "kernel",
		.offset	= MTDPART_OFS_NXTBLK,
		.size	= 0x130000,
	},
	{
		.name	= "Flash FS",
		.offset	= MTDPART_OFS_NXTBLK,
		.size	= MTDPART_SIZ_FULL,
	}
};

static int __init init_cat_maps(void)
{
	int nr_parts;
	short kernel_size;
// FLASH
	cat_flash_map.phys = 0;
	cat_flash_map.virt = (void __iomem *)P2SEGADDR(0);

	simple_map_init(&cat_flash_map);

	printk(KERN_NOTICE "Probing for flash chips at %x:\n",cat_flash_map.phys);
	flash_mtd = do_map_probe("cfi_probe", &cat_flash_map);
	if (!flash_mtd) {
		printk(KERN_NOTICE "Flash chips not detected at either possible location.\n");
		return -ENXIO;
	}
	printk(KERN_NOTICE "CAT: Flash at virt 0x%08lx\n", cat_flash_map.virt);
	flash_mtd->owner = THIS_MODULE;

	parsed_parts = cat_partitions;
	nr_parts = ARRAY_SIZE(cat_partitions);

// read EEPROM
	rtc9701_eeprom_read(&kernel_size,EEPROM_KERNEL_SIZE,2);
	if( (kernel_size>=8) && (kernel_size<=0x18)){
		cat_partitions[1].size = kernel_size * 0x10000;
	}
	add_mtd_partitions(flash_mtd, parsed_parts, nr_parts);

// SRAM
	cat_sram_map.phys = CAT_SRAM_BASE;
	cat_sram_map.virt = (void __iomem *)P2SEGADDR(CAT_SRAM_BASE);
	simple_map_init(&cat_sram_map);

	printk(KERN_NOTICE "Probing for SRAM  chips at %x:\n",cat_sram_map.virt);
	sram_mtd = do_map_probe("map_ram", &cat_sram_map);
	if (!sram_mtd) {
		printk(KERN_NOTICE "SRAM  chips not detected at either possible location.\n");
		return -ENXIO;
	}
	printk(KERN_NOTICE "CAT: SRAM  at virt 0x%08lx\n", cat_sram_map.virt);
	sram_mtd->owner = THIS_MODULE;

	add_mtd_device(sram_mtd);
	return 0;
}

static void __exit cleanup_cat_maps(void)
{
	if (parsed_parts)
		del_mtd_partitions(flash_mtd);
	else
		del_mtd_device(flash_mtd);
	map_destroy(flash_mtd);

        if(sram_mtd) {
		del_mtd_device(sram_mtd);
		map_destroy(sram_mtd);
        }
}

module_init(init_cat_maps);
module_exit(cleanup_cat_maps);

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Yutaro Ebihara <ebihara@si-linux.com>");
MODULE_DESCRIPTION("MTD map driver for CAT709/CAT760 boards.");
