/*
 * include/asm-sh/cpu-sh3/port.h
 *
 * Copyright (C) 1999 Niibe Yutaka
 * Copyright (C) 2003 Paul Mundt
 *               2005 Yutaro Ebihara
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 */
#ifndef __ASM_CPU_SH3_PORT_H
#define __ASM_CPU_SH3_PORT_H

#define PORT_PACR    0xa4000100
#define PORT_PBCR    0xa4000102
#define PORT_PCCR    0xa4000104
#define PORT_PDCR    0xa4000106
#define PORT_PECR    0xa4000108
#define PORT_PFCR    0xa400010a
#define PORT_PGCR    0xa400010c
#define PORT_PHCR    0xa400010e
#define PORT_PJCR    0xa4000110
#define PORT_PKCR    0xa4000112
#define PORT_PLCR    0xa4000114
#define PORT_SCPCR   0xa4000116

#define PORT_PADR    0xa4000120       /* port A data register */
#define PORT_PBDR    0xa4000122       /* port B data register */
#define PORT_PCDR    0xa4000124       /* port C data register */
#define PORT_PDDR    0xa4000126       /* port D data register */
#define PORT_PEDR    0xa4000128       /* port E data register */
#define PORT_PFDR    0xa400012a       /* port F data register */
#define PORT_PGDR    0xa400012c       /* port G data register */
#define PORT_PHDR    0xa400012e       /* port H data register */
#define PORT_PJDR    0xa4000130       /* port J data register */
#define PORT_PKDR    0xa4000132       /* port K data register */
#define PORT_PLDR    0xa4000134       /* port L data register */
#define PORT_SCPDR   0xa4000136       /* port SC data register */

#define PMOD	(0)
#define POUT	(1)
#define PINP	(2)
#define PIN_	(3)
#define PORT_CONTROL(ADDRESS,P7,P6,P5,P4,P3,P2,P1,P0) \
                *((volatile unsigned short*)(ADDRESS)) = ((P7<<14) | (P6<<12) | (P5<<10) | (P4<<8) | \
                              (P3<<6)  | (P2<<4)  | (P1<<2)  | (P0))

#define PORT_CONTROL_BIT(ADDRESS, BIT, MOD) \
	do{	\
		unsigned short tmp,mask;						\
		mask = 3<< (BIT*2);								\
		tmp = *((volatile unsigned short*)(ADDRESS));	\
		tmp &= ~mask;									\
		tmp |= (MOD)<<(BIT*2);							\
		*((volatile unsigned short*)(ADDRESS)) = tmp;	\
	}while(0)

#endif /* __ASM_CPU_SH3_PORT_H */

