#ifndef __ASM_SH_CAT760_H
#define __ASM_SH_CAT760_H

/*
 * linux/include/asm-sh/cat/cat760.h
 *
 *
 */
#define SH7760_USB_IRQ		64
#define SH7760_USB_BASE         (0xFE340000)
#define SH7760_USB_SRAM          (0xFE341000)
#define SH7760_USB_SRAM_SIZE     (0x2000)

/* Box specific addresses.  */

//FLASH
#define CAT_FLASH_SIZE          16*1024*1024

//SRAM
#define CAT_SRAM_BASE           0xb0000000

// IOAhXË
#define CAT760_AX88796_PHYS      0xb8000000
#define CAT760_CF_SOCKET0_PHYS   0xb8008000     /* /dev/hda       */
#define CAT760_CF_SOCKET1_PHYS   0xb800a000     /* PCMCIA cardmgr */
#define CAT760_TL16C554_PHYS     0xb800c000


#define CAT760_IRQ_CF0		8		/* IRL2  CF socket 0 IRQ */
#define CAT769_IRQ_CF1		11		/* IRL3  CF socket 0 IRQ */
#define CAT760_IRQ_AX88796	33		/* PK7 ... GPIO Interrupt */
#define CAT760_TL16C554_IRQA    2       /* IRL 0 */
#define CAT760_TL16C554_IRQB    2       /* IRL 0 */
#define CAT760_TL16C554_IRQC    5       /* IRL 1 */
#define CAT760_TL16C554_IRQD    5       /* IRL 1 */

#define __IO_PREFIX cat760
#include <asm/io_generic.h>

// EEPROM MAP

#define EEPROM_MAC 0x1f0
#define EEPROM_KERNEL_SIZE  0x1f8

extern int rtc9701_eeprom_read(unsigned char *to, int addr, int len);

#endif  /* __ASM_SH_IODATA_LANDISK_H */

