/*
 * arch/sh/boards/cat/setup.c
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 */
#include <linux/init.h>
#include <linux/platform_device.h>
#include <linux/pata_platform.h>
#include <linux/pm.h>
#include <linux/mm.h>
#include <linux/delay.h>
#include <net/ax88796.h>
#include <asm/machvec.h>
#include <asm/cat/cat760.h>
#include <asm/io.h>
#include <asm/cpu-sh4/port.h>

void __init init_cat760_IRQ(void);

/*=============================================================*/
/* IDE                                                         */

static struct resource cf_ide_resources[3];  /* 1f0,3f6,IRQ */

static struct pata_platform_info pata_info = {
	.ioport_shift	= 0,  /* */
};

static struct platform_device cf_ide_device = {
	.name		= "pata_platform",	/*  */
	.id		= -1,
	.num_resources	= ARRAY_SIZE(cf_ide_resources),
	.resource	= cf_ide_resources,
	.dev		= {
		.platform_data = &pata_info,
	},
};

static int __init cat760_cfenabler(void)
{
// CF0 tuple
	pgprot_t prot;
	unsigned long paddrbase;
	void *cf_attribute_base;

	printk("%s()\n",__FUNCTION__);
	/* open I/O area window */
	paddrbase = virt_to_phys((void *)CAT760_CF_SOCKET0_PHYS);
	prot = PAGE_KERNEL_PCC(1, _PAGE_PCC_ATR16);  /* attribute memory */
	cf_attribute_base = p3_ioremap(paddrbase, PAGE_SIZE, prot.pgprot);
	if (!cf_attribute_base) {
		printk("allocate_cf_area : can't open CF ATTRIBUTE window!\n");
		return -ENOMEM;
	}
	printk("%s() cf_attribute_base=0x%p\n",__FUNCTION__,
		cf_attribute_base);

	*(volatile unsigned short*)(cf_attribute_base+0x200) = 0x0042;

    iounmap(cf_attribute_base);
    return 0;
}

int __init cat760_ide_setup(void)
{
	pgprot_t prot;
	unsigned long paddrbase;
	void *cf_ide_base;

	printk("%s()\n",__FUNCTION__);
	// 
	//   CF0 PA4
	//   CF1 PA5
	*(volatile unsigned char*)PORT_PADR = 0xff;
	*(volatile unsigned char*)PORT_PADR &= ~(1<<5);
	*(volatile unsigned char*)PORT_PADR &= ~(1<<4);
	mdelay(1);
	cat760_cfenabler();

	/* open I/O area window */
	paddrbase = virt_to_phys((void *)CAT760_CF_SOCKET0_PHYS);
	prot = PAGE_KERNEL_PCC(1, _PAGE_PCC_IO16);
	cf_ide_base = p3_ioremap(paddrbase, PAGE_SIZE, prot.pgprot);
	if (!cf_ide_base) {
		printk("allocate_cf_area : can't open CF I/O window!\n");
		return -ENOMEM;
	}
	printk("%s() cf_ide_base=0x%p\n",__FUNCTION__,
		cf_ide_base);

	/* IDE cmd address : 0x1f0-0x1f7 and 0x3f6 */
	cf_ide_resources[0].start = (unsigned long)cf_ide_base + 0x1f0;
	cf_ide_resources[0].end   = (unsigned long)cf_ide_base + 0x1f7;
	cf_ide_resources[0].flags = IORESOURCE_IO;
	cf_ide_resources[1].start = (unsigned long)cf_ide_base + 0x3f6;
	cf_ide_resources[1].end   = (unsigned long)cf_ide_base + 0x3f6;
	cf_ide_resources[1].flags = IORESOURCE_IO;
	cf_ide_resources[2].start = CAT760_IRQ_CF0;
	cf_ide_resources[2].flags = IORESOURCE_IRQ;
}

/*=============================================================*/
/* AX88796                                                     */

static struct resource ax88796_resources[3];  /* iobase, irq   */

static struct ax_plat_data ax88796_platdata = {
	.flags          = 0,	/* was AXFLG_MAC_FROMDEV */
	.wordlength     = 2,
	.dcr_val        = 0x1,
	.rcr_val        = 0x00,	/* CAT760=0x00, CAT709=0x40 */
};

static struct platform_device ax88796_device = {
	.name           = "ax88796",
	.id             = 0,

	.dev    = {
		.platform_data = &ax88796_platdata,
	},

	.num_resources  = ARRAY_SIZE(ax88796_resources),
	.resource       = ax88796_resources,
};

int __init cat760_ax88796_setup(void)
{
	pgprot_t prot;
	unsigned long paddrbase;
	void *ax88796_base;

	printk("%s()\n",__FUNCTION__);

	/* open I/O area window */
	paddrbase = virt_to_phys((void *)CAT760_AX88796_PHYS);
	prot = PAGE_KERNEL_PCC(1, _PAGE_PCC_IO16);
	ax88796_base = p3_ioremap(paddrbase, PAGE_SIZE, prot.pgprot);
	if (!ax88796_base) {
		printk("allocate_cf_area : can't open AX88796 I/O window!\n");
		return -ENOMEM;
	}
	printk("%s() ax88796_base=0x%p\n",__FUNCTION__,
		ax88796_base);

	ax88796_resources[0].start = (unsigned long)ax88796_base;
	ax88796_resources[0].end   = (unsigned long)ax88796_base+0x1f;
	ax88796_resources[0].flags = IORESOURCE_MEM;

	ax88796_resources[1].start = CAT760_IRQ_AX88796;
	ax88796_resources[1].end   = CAT760_IRQ_AX88796;
	ax88796_resources[1].flags = IORESOURCE_IRQ;

	/* PK7 */
 	ctrl_outw(0x0040,PORT_GPIOIC);     /* PK7 */
}


/*=============================================================*/
/* RTC                                                         */

static struct platform_device rtc_device = {
	.name		= "rtc9701je",
	.id		= -1,
};

/*=============================================================*/

static struct platform_device *cat760_devices[] __initdata = {
	&cf_ide_device,
	&ax88796_device,
	&rtc_device,
};


int __init cat760_devices_setup(void)
{
	printk("%s()\n",__FUNCTION__);

	cat760_ide_setup();
	cat760_ax88796_setup();

	return platform_add_devices(cat760_devices,
				    ARRAY_SIZE(cat760_devices));
}

__initcall(cat760_devices_setup);

static void __init cat760_setup(char **cmdline_p)
{
	printk(KERN_INFO "%s()\n",__FUNCTION__);
/**/
	//                       7    6    5    4    3    2    1    0
	PORT_CONTROL(PORT_PACR,  POUT,POUT,POUT,POUT,PINP,PINP,0,   0   );
	PORT_CONTROL(PORT_PBCR,  PINP,PINP,PINP,PINP,PINP,PINP,PINP,0   );
	PORT_CONTROL(PORT_PCCR,  PINP,PINP,PINP,PINP,PINP,PINP,PINP,PINP);
	PORT_CONTROL(PORT_PDCR,  PINP,PINP,PINP,PINP,PINP,PINP,PINP,PINP);
	PORT_CONTROL(PORT_PECR,  PINP,PINP,PINP,PINP,PINP,PINP,PINP,PINP);
	PORT_CONTROL(PORT_PFCR,  0   ,0   ,0   ,0   ,PINP,PINP,PINP,PINP);
	PORT_CONTROL(PORT_PGCR,  PINP,PMOD,PMOD,POUT,PMOD,PMOD,PMOD,PMOD);
	PORT_CONTROL(PORT_PHCR,  PINP,PMOD,PMOD,PMOD,PMOD,PMOD,PMOD,PMOD);
	PORT_CONTROL(PORT_PJCR,  PINP,PINP,PINP,PINP,PINP,PINP,POUT,0   );
	PORT_CONTROL(PORT_PKCR,  PINP,PINP,PIN_,POUT,POUT,POUT,0,   0   );
	//
	//

	*(volatile unsigned short*)PORT_IPSELR &= ~0x1000;
}

/*
 * The Machine Vector
 */
static struct sh_machine_vector mv_cat760 __initmv = {
	.mv_name = "CAT760",
	.mv_nr_irqs = 72,
	.mv_setup = cat760_setup,
	.mv_init_irq = init_cat760_IRQ,
};

