%{
/*
 * All Rights Reserved, Copyright (C) 2003, Hitachi Software Engineering Co., Ltd.
 */
/* $Id: middle_lang.y,v 1.1.1.1 2003/01/20 02:39:36 ueno Exp $ */
/*yacc specification for middle language*/

#include "action.h"
#include "middle_lang.h"
#include "convert.h"
#include "initial_policy.h"
#include "initial_sids.h"
#include "security_class.h"

#define YYSTYPE char *
%}

%token DOMAIN
%token ROLE
%token USER
%token ALLOW
%token ALLOWONLY
%token ALLOWNET
%token ALLOWCOM
%token ALLOWADM
%token ALLOWTTY
%token ALLOWPTS
%token ALLOWPROC
%token ALLOWTMPFS
%token RAW
%token TCP
%token UDP
%token ALLPORT
%token WELLKNOWN
%token UNIX
%token SEM
%token MSG
%token MSG
%token MSGQ
%token SHM
%token PIPE
%token SIG
%token PORT
%token SECURITY
%token SYSTEM
%token SELF
%token OTHER
%token KMSG
%token PROC
%token CREATE
%token CHANGE
%token GENERAL
%token DENY
%token DENYONLY
%token DOMAIN_TRANS
%token PATH
%token GLOBAL_DOMAIN
%token IDENTIFIER
%token NUMBER
%token EXCLUSIVE_FILE
%%

POLICY : POLICY TE_SECTION
       |GLOBAL_SECTION
       |POLICY RBAC_SECTION
       ;

GLOBAL_SECTION : '{' GLOBAL_DOMAIN_DEF   PERM_DEFS '}'
               |'{' GLOBAL_DOMAIN_DEF '}'
               ;

TE_SECTION  :'{' DOMAIN_DEF DOMAIN_TRANS_DEFS PERM_DEFS '}'
         |'{' DOMAIN_DEF PERM_DEFS '}'
         |'{' DOMAIN_DEF  '}'
         |'{' DOMAIN_DEF DOMAIN_TRANS_DEFS '}'
         ;


RBAC_SECTION :'{' ROLE_DEF USER_DEFS DOMAIN_TRANS_DEFS PERM_DEFS '}'
             |'{' ROLE_DEF  DOMAIN_TRANS_DEFS PERM_DEFS '}'
             |'{' ROLE_DEF   PERM_DEFS '}'
             |'{' ROLE_DEF USER_DEFS  PERM_DEFS '}'
;


ROLE_DEF: ROLE IDENTIFIER ';'{registar_role($2);}
;

USER_DEFS: USER_DEFS USER_DEF
         | USER_DEF
;

USER_DEF: USER IDENTIFIER ';'{registar_user($2);}
;

GLOBAL_DOMAIN_DEF  : DOMAIN GLOBAL_DOMAIN ';' {registar_domain($2,0); }
;

DOMAIN_DEF  : DOMAIN IDENTIFIER ';' {registar_domain($2,0); }
;

PERM_DEFS :ALLOW_DEF|DENY_DEF|ALLOWONLY_DEF|DENYONLY_DEF|ALLOWNET_DEF|ALLOWCOM_DEF|ALLOWADM_DEF|ALLOWTTY_DEF|ALLOWPTS_DEF|ALLOWPROC_DEF|ALLOWTMPFS_DEF
          |PERM_DEFS ALLOW_DEF
          |PERM_DEFS DENY_DEF
          |PERM_DEFS ALLOWONLY_DEF
          |PERM_DEFS DENYONLY_DEF
          |PERM_DEFS ALLOWNET_DEF
          |PERM_DEFS ALLOWCOM_DEF
          |PERM_DEFS ALLOWADM_DEF
          |PERM_DEFS ALLOWTTY_DEF
          |PERM_DEFS ALLOWPTS_DEF
          |PERM_DEFS ALLOWPROC_DEF
          |PERM_DEFS ALLOWTMPFS_DEF
;

ALLOW_DEF  : ALLOW PATH  PERMISSIONS ';' {registar_file_acl($2,0);}
           |ALLOW  PATH EXCLUSIVE_FILE IDENTIFIER ';'{registar_exc_file_acl($2,$4);}
           |ALLOW IDENTIFIER  PERMISSIONS ';' {registar_file_acl($2,0);}
;


ALLOWONLY_DEF: ALLOWONLY PATH PERMISSIONS ';'{registar_file_acl($2,1);}
;


PERMISSIONS : PERMISSIONS ',' IDENTIFIER {add_permission($3,FILE_PERM,0);}
            |IDENTIFIER { add_permission($1,FILE_PERM,1); }
;


DENY_DEF :DENY PATH ';'{registar_deny($2,0);}
;

DENYONLY_DEF:DENYONLY PATH ';'{registar_deny($2,1);}
;

DOMAIN_TRANS_DEFS:DOMAIN_TRANS_DEF
                 |DOMAIN_TRANS_DEFS DOMAIN_TRANS_DEF

DOMAIN_TRANS_DEF:DOMAIN_TRANS IDENTIFIER PATH ';' {registar_domain_trans($2,$3);}
;

ALLOWNET_DEF:ALLOWNET ';'{ registar_net_acl(0,0);}
            |ALLOWNET RAW ';' { registar_net_acl(1,0);}
            |ALLOWNET TCP PORT NUMBER';'{registar_net_acl(2,atoi($4));}
            |ALLOWNET UDP PORT NUMBER';'{registar_net_acl(3,atoi($4));}
            |ALLOWNET WELLKNOWN ';' {registar_net_acl(4,0);}
            |ALLOWNET TCP ALLPORT ';'{registar_net_acl(5,0);}
            |ALLOWNET UDP ALLPORT ';'{registar_net_acl(6,0);;}
;

ALLOWCOM_DEF:ALLOWCOM TCP IDENTIFIER ';' { registar_com_acl(TCP_ACL,$3);}
            |ALLOWCOM TCP GLOBAL_DOMAIN ';' { registar_com_acl(TCP_ACL,$3);}
            |ALLOWCOM UDP IDENTIFIER ';' { registar_com_acl(UDP_ACL,$3);}
            |ALLOWCOM UDP GLOBAL_DOMAIN ';' { registar_com_acl(UDP_ACL,$3);}
            |ALLOWCOM UNIX IDENTIFIER  ';' { registar_com_acl(UNIX_ACL,$3);}
            |ALLOWCOM UNIX GLOBAL_DOMAIN  ';' { registar_com_acl(UNIX_ACL,$3);}
            |ALLOWCOM SEM IDENTIFIER READ_WRITE_PERMISSIONS';' {registar_com_acl(SEM_ACL,$3);}
            |ALLOWCOM SEM GLOBAL_DOMAIN READ_WRITE_PERMISSIONS';' {registar_com_acl(SEM_ACL,$3);}
            |ALLOWCOM MSG IDENTIFIER READ_WRITE_PERMISSIONS';' {registar_com_acl(MSG_ACL,$3);}
            |ALLOWCOM MSG GLOBAL_DOMAIN READ_WRITE_PERMISSIONS';' {registar_com_acl(MSG_ACL,$3);}

            |ALLOWCOM MSGQ IDENTIFIER READ_WRITE_PERMISSIONS';' {registar_com_acl(MSGQ_ACL,$3);}
            |ALLOWCOM MSGQ GLOBAL_DOMAIN READ_WRITE_PERMISSIONS';' {registar_com_acl(MSGQ_ACL,$3);}
            |ALLOWCOM SHM IDENTIFIER READ_WRITE_PERMISSIONS';' {registar_com_acl(SHM_ACL,$3);}
            |ALLOWCOM SHM GLOBAL_DOMAIN READ_WRITE_PERMISSIONS';' {registar_com_acl(SHM_ACL,$3);}


            |ALLOWCOM PIPE IDENTIFIER READ_WRITE_PERMISSIONS';' {registar_com_acl(PIPE_ACL,$3);}
            |ALLOWCOM PIPE GLOBAL_DOMAIN READ_WRITE_PERMISSIONS';' {registar_com_acl(PIPE_ACL,$3);}

            |ALLOWCOM SIG IDENTIFIER SIG_PERMISSIONS';' {registar_com_acl(SIG_ACL,$3);}
            |ALLOWCOM SIG GLOBAL_DOMAIN SIG_PERMISSIONS ';' {registar_com_acl(SIG_ACL,$3);}
;


SIG_PERMISSIONS : SIG_PERMISSIONS ',' IDENTIFIER {add_permission($3,SIG_PERM,0);}
                |IDENTIFIER { add_permission($1,SIG_PERM,1); }
;

ALLOWADM_DEF:ALLOWADM  ADM_PERMISSIONS ';'{registar_adm_acl(ADM_PERM);}
;

ADM_PERMISSIONS: ADM_PERMISSIONS ',' IDENTIFIER {add_adm_permission($3,ADM_PERM,0);}
               |IDENTIFIER {add_adm_permission($1,ADM_PERM,1);}
;


ALLOWTTY_DEF:ALLOWTTY CREATE ';'{registar_tty_acl(NULL,0);}
            |ALLOWTTY IDENTIFIER READ_WRITE_PERMISSIONS ';' {registar_tty_acl($2,2);}
            |ALLOWTTY GLOBAL_DOMAIN READ_WRITE_PERMISSIONS ';' {registar_tty_acl($2,2);}
            |ALLOWTTY GENERAL READ_WRITE_PERMISSIONS ';' {registar_tty_acl($2,2);}
            |ALLOWTTY CHANGE IDENTIFIER ';' {registar_tty_acl($3,1);};
            |ALLOWTTY CHANGE GENERAL ';' {registar_tty_acl($3,1);};
            |ALLOWTTY CHANGE GLOBAL_DOMAIN ';' {registar_tty_acl($3,1);};

;


ALLOWPTS_DEF:ALLOWPTS CREATE ';'{registar_pts_acl(NULL,0);}
            |ALLOWPTS CHANGE IDENTIFIER  ';'{registar_pts_acl($3,1);}
            |ALLOWPTS CHANGE GENERAL ';' {registar_pts_acl($3,1);}
            |ALLOWPTS CHANGE GLOBAL_DOMAIN ';' {registar_pts_acl($3,1);}
            |ALLOWPTS IDENTIFIER READ_WRITE_PERMISSIONS ';'{registar_pts_acl($2,2);}
            |ALLOWPTS GENERAL READ_WRITE_PERMISSIONS ';'{registar_pts_acl($2,2);}
            |ALLOWPTS GLOBAL_DOMAIN READ_WRITE_PERMISSIONS ';'{registar_pts_acl($2,2);}
;

ALLOWPROC_DEF:ALLOWPROC SELF READ_WRITE_PERMISSIONS ';'{registar_proc_acl(PROC_SELF);}
             |ALLOWPROC OTHER READ_WRITE_PERMISSIONS ';'{registar_proc_acl(PROC_OTHER);}
             |ALLOWPROC SYSTEM READ_WRITE_PERMISSIONS ';'{registar_proc_acl(PROC_SYSTEM);}
             |ALLOWPROC KMSG READ_WRITE_PERMISSIONS ';'{registar_proc_acl(PROC_KMSG);}
             |ALLOWPROC PROC READ_WRITE_PERMISSIONS ';'{registar_proc_acl(PROC_PROC);}
;

ALLOWTMPFS_DEF:ALLOWTMPFS CREATE ';'{registar_tmpfs_create();}
              |ALLOWTMPFS IDENTIFIER READ_WRITE_PERMISSIONS ';'{registar_com_acl(TMPFS_ACL,$2);}
              |ALLOWTMPFS GLOBAL_DOMAIN READ_WRITE_PERMISSIONS ';'{registar_com_acl(TMPFS_ACL,$2);}
              |ALLOWTMPFS GENERAL READ_WRITE_PERMISSIONS ';'{registar_com_acl(TMPFS_ACL,$2);}
;


READ_WRITE_PERMISSIONS: READ_WRITE_PERMISSIONS',' IDENTIFIER {add_permission($3,RW_PERM,0);}
                    |IDENTIFIER { add_permission($1,RW_PERM,1); }
;

%%

#include "lex.yy.c"

extern FILE *yyin;

#define DEFAULT_INFILE		"test.conf"
#define DEFAULT_POLICY		"policy.conf"
#define DEFAULT_FILE_CONTEXT	"file_context"

const char usage[]= "Usage : converter -i <infile> -o <policyfile> -f <file_context>";

int
main(int argc, char **argv)
{
	FILE *output  = stdout;
	FILE *context = stdout;
	int ch;

	/*  char *s=strdup("/");
	    printf("%d", chk_child_file(s, "/.autofsck"));
	    return ;
	*/


	if (argc == 1)
	{
		fprintf(stderr, "%s\n", usage);
		exit(1);
	}

	while ((ch = getopt(argc, argv, "o:i:f:")) != EOF)
	{
		switch (ch)
		{
		case 'o':
			if ((output = fopen(optarg, "w")) == NULL)
			{
				perror(optarg);
				exit(1);
			}
			break;

		case 'i':
			if ((yyin = fopen(optarg, "r")) == NULL)
			{
				perror(optarg);
				exit(1);
			}
			break;

		case 'f':
			if ((context = fopen(optarg, "w")) == NULL)
			{
				perror(optarg);
				exit(1);
			}
			break;

		default:
			fprintf(stderr, "%s\n", usage);
			exit(1);
			break;
		}
	}

	/* create hash table for label table */
	defined_label_table = create_hash_table(LABEL_LIST_SIZE);

	/* initialize default class and contexts arrray */
	init_initial_contexts(INITIAL_SID_CONTEXT_FILE);
	init_classes(SECURITY_CLASS_FILE);

	/* register inital domain type into label table */
	register_initial_types();

	if (yyparse() != 0)
		exit(1);

	/* print default files */
	include_file(SECURITY_CLASS_FILE, output);
	include_file(INITIAL_SIDS_FILE, output);
	include_file(ACCESS_VECTORS_FILE, output);

	/* print default all attribute */
	declare_attributes(output);

	/* print initial types */
	declare_initial_types(output);

	/* print "allow" at least necessary to configuration */
	/* print "socket allow"				     */
	default_allow(output);

	/* print initial roles */
	declare_initial_roles(output);

	/* convert middle language to SELinux configuration language */
	convert(output, context);

	/* print constraints */
	declare_initial_constrains(output);

	/* declare default contexts */
	include_file(INITIAL_SID_CONTEXT_FILE, output);

	/* include fs_use, genfs_conf */
	include_file(FS_USE_FILE, output);
	include_file(GENFS_CONTEXT_FILE, output);

	/* print portcon rules */
	out_netcontext(output);

#if 0
	free_all_objects();

	if (context != stdout)
		fclose(context);

	if (output != stdout)
		fclose(output);

	if (yyin != stdin)
		fclose(yyin);

#endif

	return 0;
}
