/*
 * All Rights Reserved, Copyright (C) 2003, Hitachi Software Engineering Co., Ltd.
 */
/* $Id: initial_sids.c,v 1.1.1.1 2003/01/20 02:39:36 ueno Exp $ */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "common.h"
#include "initial_sids.h"
#include "initial_policy.h"


static CONTEXT initial_contexts[MAX_CONTEXTS];
static int initial_contexts_num;

/**
 *  @name:	print_initial_contexts
 *  @about:	print initial contexts
 *  @args:	none
 *  @return:	none
 */
void
print_initial_contexts()
{
	int i;

	for (i = 0; i < initial_contexts_num; i++)
	{
		printf("%s\n", initial_contexts[i].context);
		printf("%s\n", initial_contexts[i].user);
		printf("%s\n", initial_contexts[i].role);
		printf("%s\n", initial_contexts[i].type);
	}

	return;
}

/**
 *  @name:	get_initial_contexts_num
 *  @about:	get number of initial contexts
 *  @args:	none
 *  @return:	none
 */
int
get_initial_contexts_num()
{
	return initial_contexts_num;
}

/**
 *  @name:	get_initial_contexts
 *  @about:	get initial context with specified number
 *  @args:	i (int) -> target id
 *  @return:	return initial context
 */
CONTEXT
get_initial_contexts(int i)
{
	return initial_contexts[i];
}

/**
 *  Takefumi Onabuta 2004/11/27 <onabuta@selinux.gr.jp>
 */ 
/**
 *  @name:	check_dup_sid
 *  @about:	check whether sid dupplicate
 *  @args:	i (int) -> target context id
 *  @args:	p (char *) -> target context name
 *  @return:	return 0 if p is not dupplicated, otherwise return 1.
 */
int 
check_dup_sid(int i, char *p)
{
	int x;
	for (x = 0; x < i; x++) 
	{
		if (strcmp(initial_contexts[x].context, p) == 0) 
		{
			return(1);
		}
	}
	return(0);
}

/**
 *  @name:	init_initial_contexts
 *  @about:	initialize contexts array.
 *  @args:	initial_sid_context_file (char *) -> sid_context_file name
 *  @return:	return 0 on success
 */
int
init_initial_contexts(char *initial_sid_context_file)
{
	FILE *fp;
	char buf[MAX_INITIAL_SIDS_FILE_LINE_LEN];
	int i=0;
	char *p;
	char *user;
	char *role;
	char *type;

	if ((fp = fopen(initial_sid_context_file, "r")) == NULL)
	{
		fprintf(stderr, "File %s doesn't exist\n", initial_sid_context_file);
		exit(1);
	}

	while (fgets(buf, sizeof(buf), fp) != NULL)
	{
		if (buf[0] == '#')
			continue;

		chop_nl(buf);

		p = get_nth_tok(buf, " \t", 3);
		if (p == NULL)
			continue;

		/**
		 *  Takefumi Onabuta 2004/11/27 <onabuta@selinux.gr.jp>
		 */ 
		if (check_dup_sid(i, p)) 
			continue;

		strcpy(initial_contexts[i].context, p);

		user = get_nth_tok(p, ":", 1);
		strcpy(initial_contexts[i].user,user);
		strcpy(p, initial_contexts[i].context);	/* by strtok,":" is deleted,so restore */

		role = get_nth_tok(p, ":", 2);
		strcpy(initial_contexts[i].role, role);
		strcpy(p, initial_contexts[i].context);

		type = get_nth_tok(p, ":", 3);
		strcpy(initial_contexts[i].type, type);

		i++;

	}

	initial_contexts_num = i;

	fclose(fp);

	return 0;
}
