/*
 * All Rights Reserved, Copyright (C) 2003, Hitachi Software Engineering Co., Ltd.
 */
/* $Id: initial_policy.h,v 1.1.1.1 2003/01/20 02:39:36 ueno Exp $ */

#ifndef INITIAL_POLICY_H
#define INITIAL_POLICY_H

#define SECURITY_CLASS_FILE		"/etc/security/selinux/src/policy/flask/security_classes"
#define INITIAL_SIDS_FILE		"/etc/security/selinux/src/policy/flask/initial_sids"
#define INITIAL_SID_CONTEXT_FILE	"initial_sid_contexts"
#define FS_USE_FILE			"fs_use"
#define GENFS_CONTEXT_FILE		"genfs_contexts"
#define ACCESS_VECTORS_FILE		"/etc/security/selinux/src/policy/flask/access_vectors"

#define BUFSIZE				1024
#define CONTEXT_LEN			64
#define USER_LEN			64
#define ROLE_LEN			64
#define TYPE_LEN			64

/**
 *  structure for containing sid contexts
 */
typedef struct context_t
{
	char		context[CONTEXT_LEN];
	char		user[USER_LEN];
	char		role[ROLE_LEN];
	char		type[TYPE_LEN];
}	CONTEXT;

int include_file(char *f, FILE *);
void declare_initial_types(FILE *);
void declare_initial_roles(FILE *);
void declare_initial_users(FILE *);
void declare_initial_constrains(FILE *);
void declare_attributes(FILE *);
void test_allow(FILE *);
void default_allow(FILE *);
void register_initial_types();

#endif
